/*
 * Decompiled with CFR 0.152.
 */
package enhancedcore.gui;

import enhancedcore.gui.EnhancedCoreContainer;
import enhancedcore.gui.GuiEnhancedCore;
import enhancedcore.util.Properties;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import org.lwjgl.opengl.GL11;

public abstract class GuiAdvancedInterface
extends GuiEnhancedCore {
    public AdvancedSlot[] slots;

    public GuiAdvancedInterface(EnhancedCoreContainer container, IInventory inventory) {
        super(container, inventory);
    }

    protected void drawBackgroundSlots() {
        int cornerX = (this.field_73880_f - this.field_74194_b) / 2;
        int cornerY = (this.field_73881_g - this.field_74195_c) / 2;
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        int i1 = 240;
        int k1 = 240;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)i1 / 1.0f), (float)((float)k1 / 1.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (AdvancedSlot slot : this.slots) {
            if (slot == null) continue;
            slot.drawSprite(cornerX, cornerY);
        }
        GL11.glPopMatrix();
    }

    protected void drawForegroundSelection(int mouseX, int mouseY) {
        AdvancedSlot slot;
        String s = "";
        int cornerX = (this.field_73880_f - this.field_74194_b) / 2;
        int cornerY = (this.field_73881_g - this.field_74195_c) / 2;
        int position = this.getSlotAtLocation(mouseX - cornerX, mouseY - cornerY);
        if (position != -1 && (slot = this.slots[position]) != null) {
            s = slot.getDescription();
        }
        if (s.length() > 0) {
            int i2 = mouseX - cornerX;
            int k2 = mouseY - cornerY;
            this.func_74190_a(s, i2, k2);
            RenderHelper.func_74520_c();
        }
    }

    public int getSlotAtLocation(int i, int j) {
        for (int position = 0; position < this.slots.length; ++position) {
            AdvancedSlot s = this.slots[position];
            if (i < s.x || i > s.x + 16 || j < s.y || j > s.y + 16) continue;
            return position;
        }
        return -1;
    }

    public class ItemSlot
    extends AdvancedSlot {
        public ItemStack stack;

        public ItemSlot(int x, int y) {
            super(x, y);
        }

        @Override
        public ItemStack getItemStack() {
            return this.stack;
        }
    }

    public class IInventorySlot
    extends AdvancedSlot {
        private IInventory tile;
        private int slot;

        public IInventorySlot(int x, int y, IInventory tile, int slot) {
            super(x, y);
            this.tile = tile;
            this.slot = slot;
        }

        @Override
        public ItemStack getItemStack() {
            return this.tile.func_70301_a(this.slot);
        }
    }

    public abstract class AdvancedSlot {
        public final int x;
        public final int y;

        public AdvancedSlot(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void drawSprite(int cornerX, int cornerY) {
            if (!this.isDefined()) {
                return;
            }
            if (this.getItemStack() != null) {
                this.drawStack(this.getItemStack());
            } else if (this.getTexture() != null) {
                Properties.bindTexture(GuiAdvancedInterface.this.field_73882_e.field_71446_o, "gui/items.png");
                GuiAdvancedInterface.this.func_94065_a(cornerX + this.x, cornerY + this.y, this.getTexture(), 16, 16);
            }
        }

        public void drawStack(ItemStack item) {
            if (item != null) {
                int cornerX = (GuiAdvancedInterface.this.field_73880_f - GuiAdvancedInterface.this.field_74194_b) / 2;
                int cornerY = (GuiAdvancedInterface.this.field_73881_g - GuiAdvancedInterface.this.field_74195_c) / 2;
                field_74196_a.field_77023_b = 200.0f;
                field_74196_a.func_82406_b(GuiAdvancedInterface.this.field_73886_k, GuiAdvancedInterface.this.field_73882_e.field_71446_o, item, cornerX + this.x, cornerY + this.y);
                field_74196_a.func_77021_b(GuiAdvancedInterface.this.field_73886_k, GuiAdvancedInterface.this.field_73882_e.field_71446_o, item, cornerX + this.x, cornerY + this.y);
                field_74196_a.field_77023_b = 0.0f;
            }
        }

        public String getDescription() {
            if (this.getItemStack() != null) {
                return this.getItemStack().func_77973_b().func_77628_j(this.getItemStack());
            }
            return "";
        }

        public ItemStack getItemStack() {
            return null;
        }

        public Icon getTexture() {
            return null;
        }

        public boolean isDefined() {
            return true;
        }
    }
}

