/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.gui.controls;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import powercrystals.core.gui.Control;
import powercrystals.core.gui.GuiColor;
import powercrystals.core.gui.GuiRender;

public abstract class SliderVertical
extends Control {
    private int _value;
    private int _valueMax;
    private boolean _isDragging;
    public int borderColor = new GuiColor(120, 120, 120, 255).getColor();
    public int backgroundColor = new GuiColor(0, 0, 0, 255).getColor();

    protected SliderVertical(GuiContainer guiContainer, int n, int n2, int n3, int n4, int n5) {
        super(guiContainer, n, n2, n3, n4);
        this._valueMax = n5;
    }

    public void setValue(int n) {
        if (n != this._value && n >= 0 && n <= this._valueMax) {
            this._value = n;
            this.onValueChanged(this._value);
        }
    }

    @Override
    public void drawBackground(int n, int n2, float f) {
        GuiRender.drawRect(this.x - 1, this.y - 1, this.x + this.width + 1, this.y + this.height + 1, this.borderColor);
        GuiRender.drawRect(this.x, this.y, this.x + this.width, this.y + this.height, this.backgroundColor);
    }

    @Override
    public void drawForeground(int n, int n2) {
        int n3 = this.width;
        int n4 = 8;
        int n5 = this.x;
        int n6 = this.y + (this.height - n4) * this._value / this._valueMax;
        if (this.enabled && this.isPointInBounds(n, n2)) {
            this.containerScreen.field_73882_e.field_71446_o.func_110577_a(new ResourceLocation("powercrystalscore:textures/gui/button_hover.png"));
        } else if (this.enabled) {
            this.containerScreen.field_73882_e.field_71446_o.func_110577_a(new ResourceLocation("powercrystalscore:textures/gui/button_enabled.png"));
        } else {
            this.containerScreen.field_73882_e.field_71446_o.func_110577_a(new ResourceLocation("powercrystalscore:textures/gui/button_disabled.png"));
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiRender.drawTexturedModalRect(n5, n6, 0, 0, n3 / 2, n4 / 2);
        GuiRender.drawTexturedModalRect(n5, n6 + n4 / 2, 0, 256 - n4 / 2, n3 / 2, n4 / 2);
        GuiRender.drawTexturedModalRect(n5 + n3 / 2, n6, 256 - n3 / 2, 0, n3 / 2, n4 / 2);
        GuiRender.drawTexturedModalRect(n5 + n3 / 2, n6 + n4 / 2, 256 - this.width / 2, 256 - n4 / 2, n3 / 2, n4 / 2);
    }

    @Override
    public boolean onMousePressed(int n, int n2, int n3) {
        this._isDragging = true;
        return true;
    }

    @Override
    public void onMouseReleased(int n, int n2) {
        this._isDragging = false;
    }

    @Override
    public void updateTick(int n, int n2) {
        if (this._isDragging) {
            this.setValue(this._valueMax * (n2 - this.y) / this.height);
        }
    }

    public abstract void onValueChanged(int var1);
}

