/*
 * Decompiled with CFR 0.152.
 */
package cofh;

import cofh.api.world.WeightedRandomBlock;
import cofh.core.CoFHProps;
import cofh.util.ConfigHandler;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cofh.util.StringHelper;
import cofh.world.TickHandlerWorld;
import cofh.world.WorldHandler;
import cofh.world.feature.FeatureOreGenNormal;
import cofh.world.feature.FeatureOreGenUniform;
import cofh.world.feature.WorldGenMinableCluster;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="CoFHWorld", name="CoFH World", version="2.0.0.2", dependencies="required-after:CoFHCore@[2.0.0.2,)")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class CoFHWorld {
    @Mod.Instance(value="CoFHWorld")
    public static CoFHWorld instance;
    public static final int MAX_BEDROCK_LAYERS = 5;
    public static final int ORE_UNIFORM = 0;
    public static final int ORE_NORMAL = 1;
    public static final String CUSTOM_GEN_TEMPLATE = "#This file allows for the addition of custom generation TEMPLATES to World.cfg.\n#Generation parameters are changed inside World.cfg.\n#These values are only used as defaults and in the template comments.\n#\n";
    public static final String CUSTOM_GEN_FORMAT = "#Format (TAB DELIMITED): GenType\tName\tBlockID\tBlockMeta\tClusterSize\tNumClusters\tminY\tmaxY\tregen\n#GenType is either UNIFORM or NORMAL. If NORMAL, minY is the average height and maxY is the maximum variance.\n#\n";
    public static final String CUSTOM_GEN_UNIFORM = "#Creates a template with default values of 4 clusters of 4 ores (1000:0) randomly between y = 32 and y = 64. Retrogen Enabled:\n#UNIFORM\ttestUniform\t1000\t0\t4\t4\t32\t64\ttrue\n#\n";
    public static final String CUSTOM_GEN_NORMAL = "#Creates a template with default values of 6 clusters of 16 ores (1000:1) in a 32-height Normal Distribution centered at y = 32. RetroGen Disabled:\n#NORMAL\ttestNormal\t1000\t1\t16\t6\t32\t16\tfalse\n#\n";
    public static final Logger log;
    public static ConfigHandler config;
    public static ConfigHandler configGeneration;
    public static File customGen;
    public static boolean allowCustomGen;
    public static boolean genFlatBedrock;
    public static boolean genReplaceVanilla;
    public static boolean retroFlatBedrock;
    public static boolean retroOreGeneration;
    public static boolean forceFullRegeneration;
    public static int layersBedrock;
    public static ArrayList<String> registeredFeatureNames;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CoFHWorld.convertLegacyConfig(false);
        config.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/CoFHWorld.cfg")));
        configGeneration.setConfiguration(new Configuration(new File(CoFHProps.configDir, "/cofh/CoFHWorld-Generation.cfg")));
        String category = "feature";
        String comment = null;
        comment = "This allows for custom generation to be specified in the WorldCustomGen.txt file.";
        allowCustomGen = config.get(category, "AllowCustomGeneration", false, comment);
        comment = "This allows for vanilla ore generation to be REPLACED. Configure in the 'world.vanilla' section of the CoFHWorld-Generation.cfg; vanilla defaults have been provided.";
        genReplaceVanilla = config.get(category, "ReplaceVanillaGeneration", false, comment);
        comment = "This will flatten the bedrock layer.";
        genFlatBedrock = config.get(category, "FlatBedrock", false, comment);
        comment = "The number of layers of bedrock to flatten to. (Max: 5)";
        layersBedrock = config.get(category, "FlatBedrockLayers", 1, comment);
        layersBedrock = MathHelper.clampI(layersBedrock, 1, 5);
        comment = "If FlatBedrock is enabled, this will enforce it in previously generated chunks.";
        retroFlatBedrock = config.get(category, "RetroactiveFlatBedrock", false, comment);
        comment = "This will retroactively generate ores in previously generated chunks.";
        retroOreGeneration = config.get(category, "RetroactiveOreGeneration", false, comment);
        this.loadWorldGeneration();
        GameRegistry.registerWorldGenerator((IWorldGenerator)WorldHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)WorldHandler.instance);
        MinecraftForge.ORE_GEN_BUS.register((Object)WorldHandler.instance);
        CoFHWorld.convertLegacyConfig(true);
        config.save();
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.parseCustomGeneration();
        if (genFlatBedrock && retroFlatBedrock || retroOreGeneration) {
            TickRegistry.registerTickHandler((ITickHandler)TickHandlerWorld.instance, (Side)Side.SERVER);
        }
    }

    void loadWorldGeneration() {
        String category = "world.vanilla";
        ConfigCategory cat = configGeneration.getCategory(category);
        cat.setComment("This section controls generation specifically related to vanilla Minecraft ores. THESE VALUES ARE USED INSTEAD OF STANDARD GENERATION IF REPLACEMENT IS ENABLED.");
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_71979_v), "dirt", 32, 20, 0, 128, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_71940_F), "gravel", 32, 10, 0, 128, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_71950_I), "coal", 16, 20, 0, 128, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_71949_H), "iron", 8, 20, 0, 64, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_71941_G), "gold", 8, 2, 0, 32, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_72047_aN), "redstone", 7, 8, 0, 16, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_72073_aw), "diamond", 7, 1, 0, 16, 0, true, genReplaceVanilla);
        CoFHWorld.addFeature("world.vanilla", new ItemStack(Block.field_71947_N), "lapis", 6, 1, 16, 16, 1, true, genReplaceVanilla);
        configGeneration.save();
    }

    void parseCustomGeneration() {
        customGen = new File(CoFHProps.configDir, "/cofh/WorldCustomGen.txt");
        try {
            if (!customGen.exists()) {
                customGen.createNewFile();
                Files.write((byte[])"#This file allows for the addition of custom generation TEMPLATES to World.cfg.\n#Generation parameters are changed inside World.cfg.\n#These values are only used as defaults and in the template comments.\n#\n#Format (TAB DELIMITED): GenType\tName\tBlockID\tBlockMeta\tClusterSize\tNumClusters\tminY\tmaxY\tregen\n#GenType is either UNIFORM or NORMAL. If NORMAL, minY is the average height and maxY is the maximum variance.\n#\n#Creates a template with default values of 4 clusters of 4 ores (1000:0) randomly between y = 32 and y = 64. Retrogen Enabled:\n#UNIFORM\ttestUniform\t1000\t0\t4\t4\t32\t64\ttrue\n#\n#Creates a template with default values of 6 clusters of 16 ores (1000:1) in a 32-height Normal Distribution centered at y = 32. RetroGen Disabled:\n#NORMAL\ttestNormal\t1000\t1\t16\t6\t32\t16\tfalse\n#\n".getBytes(), (File)customGen);
            }
            List lines = Files.readLines((File)customGen, (Charset)Charsets.UTF_8);
            for (String line : lines) {
                String[] tokens;
                if (line.startsWith("#") || (tokens = line.split("\t")).length != 9) continue;
                try {
                    int type;
                    String genType = tokens[0].toLowerCase(Locale.ENGLISH);
                    String name = tokens[1].toLowerCase(Locale.ENGLISH);
                    int oreId = Integer.valueOf(tokens[2]);
                    int oreMeta = Integer.valueOf(tokens[3]);
                    int clusterSize = Integer.valueOf(tokens[4]);
                    int numClusters = Integer.valueOf(tokens[5]);
                    int minY = Integer.valueOf(tokens[6]);
                    int maxY = Integer.valueOf(tokens[7]);
                    boolean regen = Boolean.valueOf(tokens[8]);
                    if (genType.equals("uniform")) {
                        type = 0;
                    } else if (genType.equals("normal")) {
                        type = 1;
                    } else {
                        log.log(Level.SEVERE, "The WorldCustomGen.txt file has an invalid entry: '" + tokens[1] + "'.");
                        continue;
                    }
                    if (oreId >= 4096) {
                        log.log(Level.SEVERE, "The WorldCustomGen.txt file has an invalid entry: '" + tokens[1] + "'. The ID is too high!");
                        continue;
                    }
                    CoFHWorld.addCustomFeature(oreId, oreMeta, tokens[1], clusterSize, numClusters, minY, maxY, type, regen, true);
                }
                catch (NumberFormatException e) {
                    log.log(Level.SEVERE, "The WorldCustomGen.txt file has an invalid entry: '" + tokens[1] + "'.");
                }
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "The WorldCustomGen.txt file could not be read! Skipping custom generation.");
        }
    }

    public static void addCustomFeature(int oreId, int oreMeta, String featureName, int clusterSize, int numClusters, int minY, int maxY, int feature, boolean regen, boolean enable) {
        if (registeredFeatureNames.contains(featureName)) {
            log.log(Level.SEVERE, "There is a duplicate feature entry name: '" + featureName + "' - only the first one will be used.");
            return;
        }
        if (Block.field_71973_m[oreId] == null) {
            log.log(Level.SEVERE, "The entry for custom ore '" + featureName + "' is invalid - the block is null.");
            return;
        }
        String category = "world.custom." + featureName.toLowerCase(Locale.ENGLISH);
        int bId = configGeneration.get(category, "BlockId", oreId);
        int bMeta = configGeneration.get(category, "BlockMeta", oreMeta);
        CoFHWorld.addFeature("world.custom", new ItemStack(bId, 1, bMeta), featureName, clusterSize, numClusters, minY, maxY, feature, regen, enable);
    }

    public static void addFeature(String category, ItemStack stack, String featureName, int clusterSize, int numClusters, int minY, int maxY, int feature, boolean regen, boolean enable) {
        ArrayList<WeightedRandomBlock> resList = new ArrayList<WeightedRandomBlock>();
        resList.add(new WeightedRandomBlock(stack));
        CoFHWorld.addFeature(category, resList, featureName, clusterSize, numClusters, minY, maxY, feature, regen, enable);
    }

    public static void addFeature(String category, List<WeightedRandomBlock> resList, String featureName, int clusterSize, int numClusters, int minY, int maxY, int feature, boolean regen, boolean enable) {
        category = category + "." + featureName.toLowerCase(Locale.ENGLISH);
        ConfigCategory cat = configGeneration.getCategory(category);
        String featureType = "<UNIFORM>";
        String strMin = "MinY";
        String strMax = "MaxY";
        if (feature == 1) {
            featureType = "<NORMAL>";
            strMin = "MeanY";
            strMax = "MaxVar";
        }
        cat.setComment(featureType + " Generation settings for " + StringHelper.titleCase(featureName) + "; Defaults: ClusterSize = " + clusterSize + ", NumClusters = " + numClusters + ", " + strMin + " = " + minY + ", " + strMax + " = " + maxY);
        clusterSize = configGeneration.get(category, "ClusterSize", clusterSize);
        numClusters = configGeneration.get(category, "NumClusters", numClusters);
        minY = configGeneration.get(category, strMin, minY);
        maxY = configGeneration.get(category, strMax, maxY);
        regen = configGeneration.get(category, "RetroGen", regen);
        configGeneration.save();
        if (!enable) {
            return;
        }
        if (feature == 0) {
            WorldHandler.addFeature(new FeatureOreGenUniform(featureName, new WorldGenMinableCluster(resList, clusterSize), numClusters, minY, maxY, regen));
        } else if (feature == 1) {
            WorldHandler.addFeature(new FeatureOreGenNormal(featureName, new WorldGenMinableCluster(resList, clusterSize), numClusters, minY, maxY, regen));
        }
    }

    public static void convertLegacyConfig(boolean stage) {
        if (!stage) {
            File oldFile = new File(CoFHProps.configDir, "/cofh/World.cfg");
            if (oldFile.exists()) {
                try {
                    CoreUtils.copyFileUsingChannel(oldFile, new File(CoFHProps.configDir, "/cofh/CoFHWorld-Generation.cfg"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                oldFile.renameTo(new File(CoFHProps.configDir, "/cofh/CoFHWorld.cfg"));
            }
            return;
        }
        config.getCategory("world.feature").remove((Object)"Vanilla.Augment");
        config.removeCategory("world.feature");
        config.removeCategory("world.tweak");
        config.removeCategory("world");
        configGeneration.removeCategory("feature");
    }

    static {
        log = Logger.getLogger("CoFHWorld");
        config = new ConfigHandler("2.0.0.2");
        configGeneration = new ConfigHandler("2.0.0.2");
        log.setParent(FMLLog.getLogger());
        allowCustomGen = false;
        genFlatBedrock = false;
        genReplaceVanilla = false;
        retroFlatBedrock = false;
        retroOreGeneration = false;
        forceFullRegeneration = false;
        layersBedrock = 1;
        registeredFeatureNames = new ArrayList();
    }
}

