/*
 * Decompiled with CFR 0.152.
 */
package cofh.gui.element;

import cofh.api.tileentity.ISecureTile;
import cofh.gui.GuiBase;
import cofh.gui.element.TabBase;
import cofh.util.StringHelper;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class TabSecurity
extends TabBase {
    public static final String[] TOOLTIPS = new String[]{StringHelper.localize("info.cofh.accessPublic"), StringHelper.localize("info.cofh.accessRestricted"), StringHelper.localize("info.cofh.accessPrivate")};
    ISecureTile myTile;
    String myPlayer;
    int headerColor = 14797103;
    int subheaderColor = 11186104;
    int textColor = 0;

    public TabSecurity(GuiBase gui, ISecureTile theTile, String playerName) {
        super(gui);
        this.myPlayer = playerName;
        this.myTile = theTile;
        this.maxHeight = 68;
        this.maxWidth = 112;
        this.backgroundColor = 5020082;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        this.drawBackground();
        if (this.myTile.getAccess().isPublic()) {
            this.drawTabIcon("IconAccessPublic");
        } else if (this.myTile.getAccess().isRestricted()) {
            this.drawTabIcon("IconAccessFriends");
        } else if (this.myTile.getAccess().isPrivate()) {
            this.drawTabIcon("IconAccessPrivate");
        }
        if (!this.isFullyOpened()) {
            return;
        }
        elementFontRenderer.func_78261_a(StringHelper.localize("info.cofh.security"), this.posX + 20, this.posY + 6, this.headerColor);
        elementFontRenderer.func_78261_a(StringHelper.localize("info.cofh.accessMode") + ":", this.posX + 8, this.posY + 42, this.subheaderColor);
        if (this.myTile.getAccess().isPublic()) {
            this.gui.drawButton("IconAccessPublic", this.posX + 28, this.posY + 20, 1, 1);
            this.gui.drawButton("IconAccessFriends", this.posX + 48, this.posY + 20, 1, 0);
            this.gui.drawButton("IconAccessPrivate", this.posX + 68, this.posY + 20, 1, 0);
            elementFontRenderer.func_78276_b(TOOLTIPS[0], this.posX + 16, this.posY + 54, this.textColor);
        } else if (this.myTile.getAccess().isRestricted()) {
            this.gui.drawButton("IconAccessPublic", this.posX + 28, this.posY + 20, 1, 0);
            this.gui.drawButton("IconAccessFriends", this.posX + 48, this.posY + 20, 1, 1);
            this.gui.drawButton("IconAccessPrivate", this.posX + 68, this.posY + 20, 1, 0);
            elementFontRenderer.func_78276_b(TOOLTIPS[1], this.posX + 16, this.posY + 54, this.textColor);
        } else if (this.myTile.getAccess().isPrivate()) {
            this.gui.drawButton("IconAccessPublic", this.posX + 28, this.posY + 20, 1, 0);
            this.gui.drawButton("IconAccessFriends", this.posX + 48, this.posY + 20, 1, 0);
            this.gui.drawButton("IconAccessPrivate", this.posX + 68, this.posY + 20, 1, 1);
            elementFontRenderer.func_78276_b(TOOLTIPS[2], this.posX + 16, this.posY + 54, this.textColor);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize("info.cofh.owner") + ": " + this.myTile.getOwnerName());
            return;
        }
        int x = this.gui.getMouseX() - this.currentShiftX;
        int y = this.gui.getMouseY() - this.currentShiftY;
        if (28 <= x && x < 44 && 20 <= y && y < 36) {
            list.add(TOOLTIPS[0]);
        } else if (48 <= x && x < 64 && 20 <= y && y < 36) {
            list.add(TOOLTIPS[1]);
        } else if (68 <= x && x < 84 && 20 <= y && y < 36) {
            list.add(TOOLTIPS[2]);
        }
    }

    @Override
    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (!this.myPlayer.equals(this.myTile.getOwnerName())) {
            return true;
        }
        if (!this.isFullyOpened()) {
            return false;
        }
        if ((x -= this.currentShiftX) < 24 || x >= 88 || (y -= this.currentShiftY) < 16 || y >= 40) {
            return false;
        }
        if (28 <= x && x < 44 && 20 <= y && y < 36) {
            if (!this.myTile.getAccess().isPublic()) {
                this.myTile.setAccess(ISecureTile.AccessMode.PUBLIC);
                elementSoundManager.func_77366_a("random.click", 1.0f, 0.4f);
            }
        } else if (48 <= x && x < 64 && 20 <= y && y < 36) {
            if (!this.myTile.getAccess().isRestricted()) {
                this.myTile.setAccess(ISecureTile.AccessMode.RESTRICTED);
                elementSoundManager.func_77366_a("random.click", 1.0f, 0.6f);
            }
        } else if (68 <= x && x < 84 && 20 <= y && y < 36 && !this.myTile.getAccess().isPrivate()) {
            this.myTile.setAccess(ISecureTile.AccessMode.PRIVATE);
            elementSoundManager.func_77366_a("random.click", 1.0f, 0.8f);
        }
        return true;
    }

    @Override
    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.gui.func_73729_b(this.posX + 24, this.posY + 16, 16, 20, 64, 24);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void setFullyOpen() {
        if (!this.myPlayer.equals(this.myTile.getOwnerName())) {
            return;
        }
        super.setFullyOpen();
    }
}

