/*
 * Decompiled with CFR 0.152.
 */
package cofh.plugin;

import cofh.CoFHCore;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ForgeIRC {
    private static DecimalFormat floatfmt = new DecimalFormat("##0.00");
    private static final int MAX_TPS = 20;
    private static final int MIN_TICKMS = 50;

    public static List<String> onMessage(String n, String u, String h, String d, String m) {
        n = ForgeIRC.colorNick(n, u, h);
        if (CoFHCore.proxy.isServer() && m.split(" ")[0].equals("!tps")) {
            return ForgeIRC.commandTps(m.split(" "));
        }
        return null;
    }

    static String colorNick(String n, String u, String h) {
        if (n.toLowerCase().equals("zeldokavira") || n.toLowerCase().equals("zeldo")) {
            return "\u00a7f" + n + "\u00a7r";
        }
        if (n.toLowerCase().equals("kinglemmingcofh") || n.toLowerCase().equals("kinglemming") || n.toLowerCase().equals("king_lemming")) {
            return "\u00a71" + n + "\u00a7r";
        }
        if (n.toLowerCase().equals("jadedcat")) {
            return "\u00a75" + n + "\u00a7r";
        }
        if (n.toLowerCase().equals("morvelaira")) {
            return "\u00a7d" + n + "\u00a7r";
        }
        return n;
    }

    public static List<String> onMessage(String s, String d, String m) {
        return null;
    }

    public static List<String> commandTps(String[] arguments) {
        LinkedList<String> toReturn = new LinkedList<String>();
        if (arguments.length < 2) {
            double tps = ForgeIRC.getTps(null);
            double tickms = ForgeIRC.getTickMs(null);
            toReturn.add("Overall: " + floatfmt.format(tps) + " TPS/" + floatfmt.format(tickms) + "MS (" + (int)(tps / 20.0 * 100.0) + "%)");
            for (WorldServer world : CoFHCore.server.field_71305_c) {
                tps = ForgeIRC.getTps((World)world);
                tickms = ForgeIRC.getTickMs((World)world);
                toReturn.add(world.field_73011_w.func_80007_l() + " [" + world.field_73011_w.field_76574_g + "]: " + floatfmt.format(tps) + " TPS/" + floatfmt.format(tickms) + "MS (" + (int)(tps / 20.0 * 100.0) + "%)");
            }
        } else if (arguments[1].toLowerCase().charAt(0) == 'o') {
            double tickms = ForgeIRC.getTickMs(null);
            double tps = ForgeIRC.getTps(null);
            toReturn.add("Overall server tick");
            toReturn.add("\u00a7r\u00a7r\u00a7rTPS: " + floatfmt.format(tps) + " TPS of " + floatfmt.format(20L) + " TPS (" + (int)(tps / 20.0 * 100.0) + "%)");
            toReturn.add("\u00a7r\u00a7r\u00a7rTick time: " + floatfmt.format(tickms) + " ms of " + floatfmt.format(50L) + " ms");
        } else if (arguments[1].toLowerCase().charAt(0) == 'a') {
            double tickms = ForgeIRC.getTickMs(null);
            double tps = ForgeIRC.getTps(null);
            toReturn.add("Overall server tick");
            toReturn.add("\u00a7r\u00a7r\u00a7rTPS: " + floatfmt.format(tps) + " TPS of " + floatfmt.format(20L) + " TPS (" + (int)(tps / 20.0 * 100.0) + "%)");
            toReturn.add("\u00a7r\u00a7r\u00a7rTick time: " + floatfmt.format(tickms) + " ms of " + floatfmt.format(50L) + " ms");
            int loadedChunks = 0;
            int entities = 0;
            int te = 0;
            int worlds = 0;
            for (WorldServer world : CoFHCore.server.field_71305_c) {
                loadedChunks += world.func_72863_F().func_73152_e();
                entities += world.field_72996_f.size();
                te += world.field_73009_h.size();
                ++worlds;
            }
            toReturn.add("\u00a7r\u00a7r\u00a7rTotal Loaded Worlds/Chunks: " + worlds + "/" + loadedChunks);
            toReturn.add("\u00a7r\u00a7r\u00a7rTotal Entities/TileEntities: " + entities + "/" + te);
        } else {
            int dim = 0;
            try {
                dim = Integer.parseInt(arguments[1]);
            }
            catch (Throwable e) {
                toReturn.add("");
                return toReturn;
            }
            WorldServer world = CoFHCore.server.func_71218_a(dim);
            if (world == null) {
                throw new PlayerNotFoundException("World not found", new Object[0]);
            }
            double tickms = ForgeIRC.getTickMs((World)world);
            double tps = ForgeIRC.getTps((World)world);
            toReturn.add("World " + world.field_73011_w.field_76574_g + ": " + world.field_73011_w.func_80007_l() + " - Loaded chunks: " + world.func_72863_F().func_73152_e());
            toReturn.add("\u00a7r\u00a7r\u00a7rTPS: " + floatfmt.format(tps) + "/" + floatfmt.format(20L) + " TPS (" + (int)(tps / 20.0 * 100.0) + "%) - Tick: " + floatfmt.format(tickms) + " ms of " + floatfmt.format(50L) + " ms");
            toReturn.add("\u00a7r\u00a7r\u00a7rEntities: " + world.field_72996_f.size() + " - Tile entities: " + world.field_73009_h.size());
        }
        return toReturn;
    }

    private static double getTickTimeSum(long[] times) {
        long timesum = 0L;
        if (times == null) {
            return 0.0;
        }
        for (int i = 0; i < times.length; ++i) {
            timesum += times[i];
        }
        return timesum / (long)times.length;
    }

    private static double getTickMs(World world) {
        return ForgeIRC.getTickTimeSum(world == null ? CoFHCore.server.field_71311_j : (long[])CoFHCore.server.worldTickTimes.get(world.field_73011_w.field_76574_g)) * 1.0E-6;
    }

    private static double getTps(World world) {
        double tps = 1000.0 / ForgeIRC.getTickMs(world);
        return tps > 20.0 ? 20.0 : tps;
    }
}

