/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.block.frame;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.block.frame.BlockFrame;
import shukaro.artifice.net.PlayerTracking;
import shukaro.artifice.render.IconHandler;
import shukaro.artifice.render.TextureHandler;
import shukaro.artifice.render.connectedtexture.ConnectedTextureBase;
import shukaro.artifice.render.connectedtexture.ConnectedTextures;
import shukaro.artifice.render.connectedtexture.schemes.SolidConnectedTexture;
import shukaro.artifice.util.BlockCoord;
import shukaro.artifice.util.ChunkCoord;
import shukaro.artifice.util.PacketWrapper;

public class BlockFrameScaffold
extends BlockFrame {
    private static final ForgeDirection[] sides = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.DOWN};
    private Icon[] sideIcons = new Icon[ArtificeCore.tiers.length];
    private ConnectedTextureBase basic = new SolidConnectedTexture(ConnectedTextures.BasicScaffold);
    private ConnectedTextureBase reinforced = new SolidConnectedTexture(ConnectedTextures.ReinforcedScaffold);
    private ConnectedTextureBase industrial = new SolidConnectedTexture(ConnectedTextures.IndustrialScaffold);
    private ConnectedTextureBase advanced = new SolidConnectedTexture(ConnectedTextures.AdvancedScaffold);

    public BlockFrameScaffold(int id) {
        super(id);
        this.func_71864_b("artifice.scaffold");
        this.func_71905_a(0.01f, 0.01f, 0.01f, 0.99f, 0.99f, 0.99f);
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.field_72572_g = 0;
        }
        entity.field_70143_R = 0.0f;
        if (entity.field_70123_F) {
            entity.field_70181_x = 0.2;
        } else if (PlayerTracking.sneaks.contains(entity.field_70157_k)) {
            double diff = entity.field_70167_r - entity.field_70163_u;
            entity.field_70121_D.field_72338_b += diff;
            entity.field_70121_D.field_72337_e += diff;
            entity.field_70163_u = entity.field_70167_r;
        } else {
            entity.field_70181_x = -0.1;
        }
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        ItemStack held = player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c];
        if (held != null && held.field_77993_c == this.field_71990_ca && held.func_77960_j() == world.func_72805_g(x, y, z)) {
            while (world.func_72798_a(x, y, z) == this.field_71990_ca) {
                ++y;
            }
            if (this.checkStay(world, x, y, z, held.func_77960_j()) && (Block.field_71973_m[world.func_72798_a(x, y, z)] == null || Block.field_71973_m[world.func_72798_a(x, y, z)].isAirBlock(world, x, y, z))) {
                world.func_72832_d(x, y, z, this.field_71990_ca, held.func_77960_j(), 3);
                if (!player.field_71075_bZ.field_75098_d) {
                    --held.field_77994_a;
                    if (held.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                }
            }
        }
    }

    public boolean func_94331_a(World world, int x, int y, int z, int side, ItemStack stack) {
        return this.checkStay(world, x, y, z, stack.func_77960_j());
    }

    public int getOverhang(int meta) {
        switch (meta) {
            case 0: {
                return 4;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 16;
            }
        }
        return 0;
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        return this.checkStay(world, x, y, z, world.func_72805_g(x, y, z));
    }

    private boolean checkStay(World world, int x, int y, int z, int meta) {
        BlockCoord c = new BlockCoord(x, y, z);
        if (this.isRooted(world, x, y, z, meta)) {
            return true;
        }
        for (ForgeDirection d : sides) {
            BlockCoord t = c.copy().offset(d.ordinal());
            if (!(t.getBlock(world) instanceof BlockFrameScaffold)) continue;
            if (t.blockEquals(world, this.field_71990_ca, meta)) {
                if (this.isRooted(world, t.x, t.y, t.z, meta)) {
                    return true;
                }
                for (BlockCoord match : c.getRadiusMatches(world, this.getOverhang(meta), this.field_71990_ca, meta)) {
                    if (!this.isRooted(world, match.x, match.y, match.z, meta) || !c.isConnected(world, match, this.field_71990_ca, meta) || !(c.getDistance(match) <= (float)this.getOverhang(meta))) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean isRooted(World world, int x, int y, int z, int meta) {
        for (int i = y - 1; i > 0; --i) {
            if (world.isBlockSolidOnSide(x, i, z, ForgeDirection.UP)) {
                if (world.func_72798_a(x, i, z) == this.field_71990_ca) {
                    if (world.func_72805_g(x, i, z) == meta) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_71863_a(World world, int x, int y, int z, int neighborID) {
        if (!world.field_72995_K) {
            BlockCoord c = new BlockCoord(x, y, z);
            PacketDispatcher.sendPacketToAllAround((double)c.x, (double)c.y, (double)c.z, (double)192.0, (int)world.field_73011_w.field_76574_g, (Packet)PacketWrapper.createPacket("Artifice", 2, new Object[]{c.x, c.y, c.z}));
        }
        if (!this.func_71854_d(world, x, y, z)) {
            this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_94571_i(x, y, z);
        }
    }

    @Override
    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.UP || side == ForgeDirection.DOWN;
    }

    @Override
    public boolean func_71926_d() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister reg) {
        ArtificeConfig.registerConnectedTextures(reg);
        for (int i = 0; i < ArtificeCore.tiers.length; ++i) {
            this.sideIcons[i] = IconHandler.registerSingle(reg, ArtificeCore.tiers[i].toLowerCase(Locale.ENGLISH), "scaffold/sides");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (meta >= ArtificeCore.tiers.length) {
            meta = 0;
        }
        if (side == 0 || side == 1) {
            switch (meta) {
                case 0: {
                    return ConnectedTextures.BasicScaffold.textureList[0];
                }
                case 1: {
                    return ConnectedTextures.ReinforcedScaffold.textureList[0];
                }
                case 2: {
                    return ConnectedTextures.IndustrialScaffold.textureList[0];
                }
                case 3: {
                    return ConnectedTextures.AdvancedScaffold.textureList[0];
                }
            }
            return ConnectedTextures.BasicScaffold.textureList[0];
        }
        return this.sideIcons[meta];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess access, int x, int y, int z, int side) {
        int meta = access.func_72805_g(x, y, z);
        if (meta > ArtificeCore.tiers.length) {
            meta = 0;
        }
        if (side == 0 || side == 1) {
            BlockCoord coord = new BlockCoord(x, y, z);
            boolean found = false;
            for (ChunkCoord sector : ArtificeCore.textureCache.keySet()) {
                if (!ArtificeCore.textureCache.get(sector).containsKey(coord)) continue;
                found = true;
            }
            if (!found) {
                TextureHandler.updateTexture(coord);
            }
            if (TextureHandler.getConnectedTexture(this.func_71858_a(side, meta)) != null && ArtificeCore.textureCache.containsKey(new ChunkCoord(coord)) && ArtificeCore.textureCache.get(new ChunkCoord(coord)).get(coord) != null) {
                return TextureHandler.getConnectedTexture((Icon)this.func_71858_a((int)side, (int)meta)).textureList[ArtificeCore.textureCache.get(new ChunkCoord(coord)).get(coord)[side]];
            }
            return this.func_71858_a(side, meta);
        }
        return this.sideIcons[access.func_72805_g(x, y, z)];
    }

    public int func_71857_b() {
        return ArtificeConfig.frameRenderID;
    }
}

