/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.compat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.util.IdMetaPair;

public abstract class ArtificeRegistry {
    private static final List<Integer> dimensionBlacklist = new ArrayList<Integer>();
    private static final Set<Integer> stoneTypes = new HashSet<Integer>();
    private static final List<String> worldTypeBlacklist = new ArrayList<String>();
    private static final Map<IdMetaPair, ArrayList<ItemStack>> sledgeBlocks = new HashMap<IdMetaPair, ArrayList<ItemStack>>();
    private static final Map<Integer, ArrayList<ItemStack>> wildSledgeBlocks = new HashMap<Integer, ArrayList<ItemStack>>();
    private static final Map<IdMetaPair, List<String>> tooltipMap = new HashMap<IdMetaPair, List<String>>();
    private static final List<ItemStack> marbleTypes = new ArrayList<ItemStack>();
    private static final List<ItemStack> basaltTypes = new ArrayList<ItemStack>();

    public static void registerMarbleType(int id, int meta) {
        ArtificeCore.logger.log(Level.INFO, "Registering marble type " + id + ":" + meta);
        ItemStack stack = new ItemStack(id, 1, meta);
        if (marbleTypes.isEmpty()) {
            marbleTypes.add(stack);
        } else if (!marbleTypes.contains(stack)) {
            marbleTypes.add(stack);
            if (!ArtificeConfig.stoneCycleRecipes.getBoolean(true)) {
                return;
            }
            if (marbleTypes.size() < 3) {
                ShapelessOreRecipe inner = new ShapelessOreRecipe(marbleTypes.get(1), new Object[]{marbleTypes.get(0)});
                ShapelessOreRecipe wrap = new ShapelessOreRecipe(marbleTypes.get(0), new Object[]{marbleTypes.get(1)});
                CraftingManager.func_77594_a().func_77592_b().add(inner);
                CraftingManager.func_77594_a().func_77592_b().add(wrap);
            } else {
                ShapelessOreRecipe inner = new ShapelessOreRecipe(marbleTypes.get(marbleTypes.size() - 1), new Object[]{marbleTypes.get(marbleTypes.size() - 2)});
                ShapelessOreRecipe wrap = new ShapelessOreRecipe(marbleTypes.get(0), new Object[]{marbleTypes.get(marbleTypes.size() - 1)});
                for (Object o : CraftingManager.func_77594_a().func_77592_b().toArray()) {
                    ArrayList input;
                    ItemStack output;
                    if (!(o instanceof ShapelessOreRecipe) || !(output = ((ShapelessOreRecipe)o).func_77571_b()).func_77969_a(marbleTypes.get(0)) || (input = ((ShapelessOreRecipe)o).getInput()).size() > 1 || !((ItemStack)input.get(0)).func_77969_a(marbleTypes.get(marbleTypes.size() - 2))) continue;
                    CraftingManager.func_77594_a().func_77592_b().remove(o);
                }
                CraftingManager.func_77594_a().func_77592_b().add(inner);
                CraftingManager.func_77594_a().func_77592_b().add(wrap);
            }
        }
    }

    public static List<ItemStack> getMarbleTypes() {
        return marbleTypes;
    }

    public static void registerBasaltType(int id, int meta) {
        ArtificeCore.logger.log(Level.INFO, "Registering basalt type " + id + ":" + meta);
        ItemStack stack = new ItemStack(id, 1, meta);
        if (basaltTypes.isEmpty()) {
            basaltTypes.add(stack);
        } else if (!basaltTypes.contains(stack)) {
            basaltTypes.add(stack);
            if (!ArtificeConfig.stoneCycleRecipes.getBoolean(true)) {
                return;
            }
            if (basaltTypes.size() < 3) {
                ShapelessOreRecipe inner = new ShapelessOreRecipe(basaltTypes.get(1), new Object[]{basaltTypes.get(0)});
                ShapelessOreRecipe wrap = new ShapelessOreRecipe(basaltTypes.get(0), new Object[]{basaltTypes.get(1)});
                CraftingManager.func_77594_a().func_77592_b().add(inner);
                CraftingManager.func_77594_a().func_77592_b().add(wrap);
            } else {
                ShapelessOreRecipe inner = new ShapelessOreRecipe(basaltTypes.get(basaltTypes.size() - 1), new Object[]{basaltTypes.get(basaltTypes.size() - 2)});
                ShapelessOreRecipe wrap = new ShapelessOreRecipe(basaltTypes.get(0), new Object[]{basaltTypes.get(basaltTypes.size() - 1)});
                for (Object o : CraftingManager.func_77594_a().func_77592_b().toArray()) {
                    ArrayList input;
                    ItemStack output;
                    if (!(o instanceof ShapelessOreRecipe) || !(output = ((ShapelessOreRecipe)o).func_77571_b()).func_77969_a(basaltTypes.get(0)) || (input = ((ShapelessOreRecipe)o).getInput()).size() > 1 || !((ItemStack)input.get(0)).func_77969_a(basaltTypes.get(basaltTypes.size() - 2))) continue;
                    CraftingManager.func_77594_a().func_77592_b().remove(o);
                }
                CraftingManager.func_77594_a().func_77592_b().add(inner);
                CraftingManager.func_77594_a().func_77592_b().add(wrap);
            }
        }
    }

    public static List<ItemStack> getBasaltTypes() {
        return basaltTypes;
    }

    public static void registerTooltip(int id, int meta, String line) {
        IdMetaPair pair = new IdMetaPair(id, meta);
        if (tooltipMap.get(pair) == null) {
            ArrayList<String> temp = new ArrayList<String>();
            temp.add(line);
            tooltipMap.put(pair, temp);
        } else {
            tooltipMap.get(pair).add(line);
        }
    }

    public static Map<IdMetaPair, List<String>> getTooltipMap() {
        return tooltipMap;
    }

    public static void registerSledgeBlock(int id, int meta, ArrayList<ItemStack> drops) {
        IdMetaPair pair = new IdMetaPair(id, meta);
        if (!pair.isValidBlock()) {
            ArtificeCore.logger.log(Level.WARNING, "Tried to register non-block id-meta pair in the sledgeBlock map: " + pair.toString());
        } else if (sledgeBlocks.get(pair) == null) {
            ArtificeCore.logger.log(Level.INFO, "Registering sledgeable block " + pair);
            sledgeBlocks.put(pair, drops);
        }
    }

    public static void registerWildSledgeBlock(int id, ArrayList<ItemStack> drops) {
        if (wildSledgeBlocks.get(id) == null) {
            ArtificeCore.logger.log(Level.INFO, "Registering non-meta'd sledgeable block with ID " + id);
            wildSledgeBlocks.put(id, drops);
        }
    }

    public static Map<Integer, ArrayList<ItemStack>> getWildSledgeBlocks() {
        return wildSledgeBlocks;
    }

    public static Map<IdMetaPair, ArrayList<ItemStack>> getSledgeBlocks() {
        return sledgeBlocks;
    }

    public static void registerDimensionBlacklist(int dimID) {
        if (!dimensionBlacklist.contains(dimID)) {
            ArtificeCore.logger.log(Level.INFO, "Registering " + dimID + " to dimension blacklist");
            dimensionBlacklist.add(dimID);
        }
    }

    public static List<Integer> getDimensionBlacklist() {
        return dimensionBlacklist;
    }

    public static void registerStoneType(int stoneID) {
        if (!stoneTypes.contains(stoneID)) {
            ArtificeCore.logger.log(Level.INFO, "Registering stone type with ID " + stoneID);
            stoneTypes.add(stoneID);
        }
    }

    public static Set<Integer> getStoneTypes() {
        return stoneTypes;
    }

    public static void registerWorldTypeBlacklist(String type) {
        if (!worldTypeBlacklist.contains(type)) {
            ArtificeCore.logger.log(Level.INFO, "Registering " + type + " to world type blacklist");
            worldTypeBlacklist.add(type);
        }
    }

    public static List<String> getWorldTypeBlacklist() {
        return worldTypeBlacklist;
    }
}

