/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.crate;

import codechicken.multipart.ControlKeyModifer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import resonant.lib.prefab.block.BlockTile;
import resonant.lib.utility.LanguageUtility;
import resonantinduction.archaic.crate.ItemBlockCrate;
import resonantinduction.archaic.crate.PathfinderCrate;
import resonantinduction.archaic.crate.TileCrate;
import universalelectricity.api.UniversalElectricity;

public class BlockCrate
extends BlockTile {
    Icon advanced;
    Icon elite;

    public BlockCrate(int id) {
        super(id, UniversalElectricity.machine);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconReg) {
        this.field_94336_cN = iconReg.func_94245_a("resonantinduction:crate_wood");
        this.advanced = iconReg.func_94245_a("resonantinduction:crate_iron");
        this.elite = iconReg.func_94245_a("resonantinduction:crate_steel");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (meta == 1) {
            return this.advanced;
        }
        if (meta == 2) {
            return this.elite;
        }
        return this.field_94336_cN;
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K && world.func_72796_p(x, y, z) instanceof TileCrate) {
            TileCrate tileEntity = (TileCrate)world.func_72796_p(x, y, z);
            this.tryEject(tileEntity, player, System.currentTimeMillis() - tileEntity.prevClickTime < 200L);
            tileEntity.prevClickTime = System.currentTimeMillis();
        }
    }

    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && world.func_72796_p(x, y, z) instanceof TileCrate) {
            TileCrate tile = (TileCrate)world.func_72796_p(x, y, z);
            tile.buildSampleStack();
            ItemStack sampleStack = tile.getSampleStack();
            int oreID = OreDictionary.getOreID((ItemStack)sampleStack);
            if (ControlKeyModifer.isControlDown((EntityPlayer)player)) {
                tile.oreFilterEnabled = !tile.oreFilterEnabled;
                player.func_70006_a(ChatMessageComponent.func_111066_d((String)LanguageUtility.getLocal((String)("crate.orefilter." + tile.oreFilterEnabled))));
            } else if (oreID != -1) {
                ArrayList ores = OreDictionary.getOres((Integer)oreID);
                for (int oreIndex = 0; oreIndex < ores.size(); ++oreIndex) {
                    if (!((ItemStack)ores.get(oreIndex)).func_77969_a(sampleStack)) continue;
                    int nextIndex = (oreIndex + 1) % ores.size();
                    ItemStack desiredStack = ((ItemStack)ores.get(nextIndex)).func_77946_l();
                    desiredStack.field_77994_a = sampleStack.field_77994_a;
                    for (int index = 0; index < tile.func_70302_i_(); ++index) {
                        tile.func_70299_a(index, null);
                    }
                    tile.addStackToStorage(desiredStack);
                    break;
                }
            }
        }
        return true;
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && world.func_72796_p(x, y, z) instanceof TileCrate) {
            TileCrate tile = (TileCrate)world.func_72796_p(x, y, z);
            if (ControlKeyModifer.isControlDown((EntityPlayer)player)) {
                if (!(player.func_71045_bC() == null || player.func_71045_bC().func_77973_b().func_77645_m() && player.func_71045_bC().func_77973_b().getDamage(player.func_71045_bC()) <= 0)) {
                    ItemStack filter = player.func_71045_bC().func_77946_l();
                    filter.field_77994_a = 0;
                    tile.setFilter(filter);
                } else {
                    tile.setFilter(null);
                }
            } else {
                ItemStack current = player.field_71071_by.func_70448_g();
                if (player.field_71075_bZ.field_75098_d) {
                    if (side == 1) {
                        if (current != null && tile.getSampleStack() == null) {
                            ItemStack cStack = current.func_77946_l();
                            cStack.field_77994_a = TileCrate.getSlotCount(world.func_72805_g(x, y, z)) * 64;
                            BlockCrate.addStackToCrate(tile, cStack);
                        }
                    } else if ((double)hitY <= 0.5) {
                        this.tryEject(tile, player, System.currentTimeMillis() - tile.prevClickTime < 250L);
                    } else {
                        this.tryInsert(tile, player, System.currentTimeMillis() - tile.prevClickTime < 250L);
                    }
                } else {
                    this.tryInsert(tile, player, System.currentTimeMillis() - tile.prevClickTime < 250L);
                }
            }
            tile.prevClickTime = System.currentTimeMillis();
        }
        return true;
    }

    public void tryInsert(TileCrate tileEntity, EntityPlayer player, boolean allMode, boolean doSearch) {
        boolean success;
        boolean bl = success = allMode ? this.insertAllItems(tileEntity, player) : this.insertCurrentItem(tileEntity, player);
        if (!success && doSearch) {
            PathfinderCrate pathfinder = new PathfinderCrate().init((TileEntity)tileEntity);
            for (TileEntity checkTile : pathfinder.iteratedNodes) {
                if (!(checkTile instanceof TileCrate)) continue;
                this.tryInsert((TileCrate)checkTile, player, allMode, false);
            }
        }
    }

    public void tryInsert(TileCrate tileEntity, EntityPlayer player, boolean allMode) {
        this.tryInsert(tileEntity, player, allMode, true);
    }

    public void tryEject(TileCrate tileEntity, EntityPlayer player, boolean allMode) {
        if (tileEntity.getSampleStack() == null) {
            return;
        }
        if (allMode && !player.func_70093_af()) {
            this.ejectItems(tileEntity, player, tileEntity.getSlotCount() * 64);
        } else if (player.func_70093_af()) {
            this.ejectItems(tileEntity, player, 1);
        } else {
            this.ejectItems(tileEntity, player, tileEntity.getSampleStack().func_77976_d());
        }
    }

    public boolean insertCurrentItem(TileCrate tileEntity, EntityPlayer player) {
        ItemStack currentStack = player.func_71045_bC();
        if (currentStack != null) {
            if (currentStack.func_77973_b().field_77779_bT == this.field_71990_ca) {
                ItemStack containedStack = ItemBlockCrate.getContainingItemStack(currentStack);
                ItemStack crateStack = tileEntity.getSampleStack();
                if (containedStack != null && (crateStack == null || ItemStack.func_77989_b((ItemStack)containedStack, (ItemStack)crateStack))) {
                    ItemStack returned = BlockCrate.addStackToCrate(tileEntity, containedStack);
                    ItemBlockCrate.setContainingItemStack(currentStack, returned);
                    return true;
                }
            } else {
                if (!(tileEntity.getSampleStack() == null || tileEntity.getSampleStack().func_77969_a(currentStack) || tileEntity.oreFilterEnabled && !OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)tileEntity.getSampleStack())).equals("Unknown") && OreDictionary.getOreID((ItemStack)tileEntity.getSampleStack()) == OreDictionary.getOreID((ItemStack)currentStack))) {
                    return false;
                }
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, BlockCrate.addStackToCrate(tileEntity, currentStack));
                return true;
            }
        }
        return false;
    }

    public boolean insertAllItems(TileCrate tileEntity, EntityPlayer player) {
        ItemStack requestStack = null;
        if (tileEntity.getSampleStack() != null) {
            requestStack = tileEntity.getSampleStack().func_77946_l();
        }
        if (requestStack == null) {
            requestStack = player.func_71045_bC();
        }
        if (requestStack != null && requestStack.field_77993_c != this.field_71990_ca) {
            boolean success = false;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack currentStack = player.field_71071_by.func_70301_a(i);
                if (currentStack == null || !requestStack.func_77969_a(currentStack)) continue;
                player.field_71071_by.func_70299_a(i, BlockCrate.addStackToCrate(tileEntity, currentStack));
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                }
                success = true;
            }
            return success;
        }
        return false;
    }

    public boolean ejectItems(TileCrate tileEntity, EntityPlayer player, int requestSize) {
        World world = tileEntity.field_70331_k;
        if (!world.field_72995_K) {
            ItemStack sampleStack = tileEntity.getSampleStack();
            int ammountEjected = 0;
            if (sampleStack != null && requestSize > 0) {
                for (int slot = 0; slot < tileEntity.getInventory().func_70302_i_(); ++slot) {
                    ItemStack slotStack = tileEntity.getInventory().func_70301_a(slot);
                    if (slotStack != null && slotStack.field_77994_a > 0) {
                        int amountToTake = Math.min(slotStack.field_77994_a, requestSize);
                        ItemStack dropStack = slotStack.func_77946_l();
                        dropStack.field_77994_a = amountToTake;
                        if (!player.field_71071_by.func_70441_a(dropStack)) {
                            tileEntity.getInventory().func_70299_a(slot, slotStack);
                            ammountEjected += amountToTake - slotStack.field_77994_a;
                            break;
                        }
                        tileEntity.getInventory().func_70299_a(slot, null);
                        ammountEjected += amountToTake;
                    }
                    if (ammountEjected < requestSize) continue;
                    return true;
                }
                player.field_71071_by.func_70296_d();
                tileEntity.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public static ItemStack addStackToCrate(TileCrate tileEntity, ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77973_b().func_77645_m() && itemStack.func_77973_b().getDamage(itemStack) > 0) {
            return itemStack;
        }
        ItemStack containingStack = tileEntity.getSampleStack();
        if (containingStack == null || containingStack.func_77969_a(itemStack) || tileEntity.oreFilterEnabled && OreDictionary.getOreID((ItemStack)containingStack) == OreDictionary.getOreID((ItemStack)itemStack)) {
            int room = Math.max(tileEntity.getInventory().func_70302_i_() * 64 - (containingStack != null ? containingStack.field_77994_a : 0), 0);
            if (itemStack.field_77994_a <= room) {
                tileEntity.addToStack(itemStack);
                itemStack = null;
            } else {
                tileEntity.addToStack(itemStack, room);
                itemStack.field_77994_a -= room;
            }
            return itemStack;
        }
        if (itemStack.field_77994_a <= 0) {
            return null;
        }
        return itemStack;
    }

    public int func_71899_b(int metadata) {
        return metadata;
    }

    public TileEntity func_72274_a(World var1) {
        return new TileCrate();
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
    }
}

