/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.engineering;

import codechicken.multipart.ControlKeyModifer;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;
import resonant.api.IRotatable;
import resonant.api.ISlotPickResult;
import resonant.api.recipe.MachineRecipes;
import resonant.api.recipe.RecipeResource;
import resonant.lib.content.module.TileRender;
import resonant.lib.content.module.prefab.TileInventory;
import resonant.lib.gui.ContainerDummy;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.item.ItemBlockSaved;
import resonant.lib.prefab.vector.Cuboid;
import resonant.lib.render.RenderItemOverlayUtility;
import resonant.lib.type.Pair;
import resonant.lib.utility.LanguageUtility;
import resonant.lib.utility.WorldUtility;
import resonant.lib.utility.inventory.AutoCraftingManager;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.archaic.engineering.ItemHammer;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.prefab.imprint.ItemImprint;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector2;
import universalelectricity.api.vector.Vector3;

public class TileEngineeringTable
extends TileInventory
implements IPacketReceiver,
IRotatable,
ISidedInventory,
ISlotPickResult,
AutoCraftingManager.IAutoCrafter {
    public static final int CRAFTING_MATRIX_END = 9;
    public static final int CRAFTING_OUTPUT_END = 10;
    public static final int PLAYER_OUTPUT_END = 50;
    public static final int CENTER_SLOT = 4;
    public static final int CRAFTING_OUTPUT_SLOT = 0;
    private AutoCraftingManager craftManager;
    public static final int CRAFTING_MATRIX_SIZE = 9;
    public ItemStack[] craftingMatrix = new ItemStack[9];
    public static final int[] craftingSlots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public ItemStack[] outputInventory = new ItemStack[1];
    public boolean searchInventories = true;
    private InventoryPlayer invPlayer = null;
    private int[] playerSlots;
    @SideOnly(value=Side.CLIENT)
    private static Icon iconTop;
    @SideOnly(value=Side.CLIENT)
    private static Icon iconFront;
    @SideOnly(value=Side.CLIENT)
    private static Icon iconSide;

    public TileEngineeringTable() {
        super(Material.field_76245_d);
        this.bounds = new Cuboid(0.0, 0.0, 0.0, 1.0, (double)0.9f, 1.0);
        this.isOpaqueCube = false;
        this.normalRender = false;
        this.itemBlock = ItemBlockSaved.class;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(int side, int meta) {
        return side == 1 ? iconTop : (side == meta ? iconFront : iconSide);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        iconTop = iconRegister.func_94245_a(this.getTextureName() + "_top");
        iconFront = iconRegister.func_94245_a(this.getTextureName() + "_front");
        iconSide = iconRegister.func_94245_a(this.getTextureName() + "_side");
    }

    public void click(EntityPlayer player) {
        if (!this.world().field_72995_K && ControlKeyModifer.isControlDown((EntityPlayer)player)) {
            for (int i = 0; i < this.func_70302_i_() - 1; ++i) {
                if (this.func_70301_a(i) == null) continue;
                InventoryUtility.dropItemStack((World)this.world(), (Vector3)new Vector3((Entity)player), (ItemStack)this.func_70301_a(i));
                this.func_70299_a(i, null);
            }
        }
    }

    protected boolean use(EntityPlayer player, int hitSide, Vector3 hit) {
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemHammer) {
            for (int slot = 0; slot < 10; ++slot) {
                RecipeResource[] outputs;
                String oreName;
                ItemStack inputStack = this.func_70301_a(slot);
                if (inputStack == null || (oreName = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)inputStack))) == null || oreName.equals("Unknown") || (outputs = MachineRecipes.INSTANCE.getOutput(ResonantInduction.RecipeType.CRUSHER.name(), new Object[]{oreName})) == null || outputs.length <= 0) continue;
                if (!this.world().field_72995_K && (double)this.world().field_73012_v.nextFloat() < 0.2) {
                    for (RecipeResource resource : outputs) {
                        ItemStack outputStack = resource.getItemStack().func_77946_l();
                        if (outputStack == null) continue;
                        InventoryUtility.dropItemStack((World)this.world(), (Vector3)new Vector3((Entity)player), (ItemStack)outputStack, (int)0);
                        this.func_70299_a(slot, --inputStack.field_77994_a <= 0 ? null : inputStack);
                    }
                }
                ResonantInduction.proxy.renderBlockParticle(this.world(), new Vector3((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5), new Vector3((Math.random() - 0.5) * 3.0, (Math.random() - 0.5) * 3.0, (Math.random() - 0.5) * 3.0), inputStack.field_77993_c, 1.0f);
                this.world().func_72908_a((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5, "resonantinduction:hammer", 0.5f, 0.8f + 0.2f * this.world().field_73012_v.nextFloat());
                player.func_71020_j(0.1f);
                player.func_71045_bC().func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
            return true;
        }
        if (hitSide == 1) {
            if (!this.world().field_72995_K) {
                Vector3 hitVector = new Vector3(hit.x, 0.0, hit.z);
                double regionLength = 0.3333333333333333;
                hitVector.translate((IVector3)new Vector3(-0.5, 0.0, -0.5));
                hitVector.rotate((float)WorldUtility.getAngleFromForgeDirection((ForgeDirection)this.getDirection()), Vector3.UP());
                hitVector.translate((IVector3)new Vector3(0.5, 0.0, 0.5));
                block2: for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        Vector2 check = new Vector2((double)j, (double)k).scale(0.3333333333333333);
                        if (!(check.distance(hitVector.toVector2()) < 0.3333333333333333)) continue;
                        int slotID = j * 3 + k;
                        this.interactCurrentItem((IInventory)this, slotID, player);
                        break block2;
                    }
                }
                this.func_70296_d();
            }
            return true;
        }
        if (hitSide != 0) {
            if (!this.world().field_72995_K) {
                this.setPlayerInventory(player.field_71071_by);
                ItemStack output = this.func_70301_a(9);
                boolean firstLoop = true;
                while (output != null && (firstLoop || ControlKeyModifer.isControlDown((EntityPlayer)player))) {
                    this.onPickUpFromSlot(player, 9, output);
                    if (output.field_77994_a > 0) {
                        InventoryUtility.dropItemStack((World)this.world(), (Vector3)new Vector3((Entity)player), (ItemStack)output, (int)0);
                    }
                    this.func_70299_a(9, null);
                    this.func_70296_d();
                    output = this.func_70301_a(9);
                    firstLoop = false;
                }
                this.setPlayerInventory(null);
            }
            return true;
        }
        return false;
    }

    protected boolean configure(EntityPlayer player, int side, Vector3 hit) {
        if (player.func_70093_af()) {
            boolean bl = this.searchInventories = !this.searchInventories;
            if (!this.world().field_72995_K) {
                if (this.searchInventories) {
                    player.func_71035_c(LanguageUtility.getLocal((String)"engineerTable.config.inventory.true"));
                } else {
                    player.func_71035_c(LanguageUtility.getLocal((String)"engineerTable.config.inventory.false"));
                }
            }
            this.markUpdate();
            return true;
        }
        return super.configure(player, side, hit);
    }

    public ArrayList<ItemStack> getDrops(int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void onRemove(int par5, int par6) {
        ItemStack stack = ItemBlockSaved.getItemStackWithNBT((Block)this.func_70311_o(), (World)this.world(), (int)this.x(), (int)this.y(), (int)this.z());
        InventoryUtility.dropItemStack((World)this.world(), (Vector3)this.center(), (ItemStack)stack);
    }

    public void setPlayerInventory(InventoryPlayer invPlayer) {
        if (this.searchInventories) {
            if (invPlayer != null) {
                this.playerSlots = new int[invPlayer.func_70302_i_()];
                for (int i = 0; i < this.playerSlots.length; ++i) {
                    this.playerSlots[i] = i + 10;
                }
            } else {
                this.playerSlots = null;
            }
            this.invPlayer = invPlayer;
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public AutoCraftingManager getCraftingManager() {
        if (this.craftManager == null) {
            this.craftManager = new AutoCraftingManager((AutoCraftingManager.IAutoCrafter)this);
        }
        return this.craftManager;
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{nbt});
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            this.func_70307_a(PacketHandler.readNBTTagCompound((DataInput)data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int func_70302_i_() {
        return 10 + (this.invPlayer != null ? this.invPlayer.func_70302_i_() : 0);
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 9) {
            return this.craftingMatrix[slot];
        }
        if (slot < 10) {
            return this.outputInventory[slot - 9];
        }
        if (slot < 50 && this.invPlayer != null) {
            return this.invPlayer.func_70301_a(slot - 10);
        }
        if (this.searchInventories) {
            int idDisplacement = 50;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = new Vector3((TileEntity)this).translate(dir).getTileEntity((IBlockAccess)this.field_70331_k);
                if (!(tile instanceof IInventory)) continue;
                IInventory inventory = (IInventory)tile;
                int slotID = slot - idDisplacement;
                if (slotID >= 0 && slotID < inventory.func_70302_i_()) {
                    return inventory.func_70301_a(slotID);
                }
                idDisplacement += inventory.func_70302_i_();
            }
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int amount) {
        if (this.func_70301_a(i) != null) {
            if (this.func_70301_a((int)i).field_77994_a <= amount) {
                ItemStack stack = this.func_70301_a(i);
                this.func_70299_a(i, null);
                return stack;
            }
            ItemStack stack = this.func_70301_a(i).func_77979_a(amount);
            if (this.func_70301_a((int)i).field_77994_a == 0) {
                this.func_70299_a(i, null);
            }
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot < 9) {
            this.craftingMatrix[slot] = itemStack;
        } else if (slot < 10) {
            this.outputInventory[slot - 9] = itemStack;
        } else if (slot < 50 && this.invPlayer != null) {
            this.invPlayer.func_70299_a(slot - 10, itemStack);
            EntityPlayer player = this.invPlayer.field_70458_d;
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
            }
        } else if (this.searchInventories) {
            int idDisplacement = 50;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = new Vector3((TileEntity)this).translate(dir).getTileEntity((IBlockAccess)this.field_70331_k);
                if (!(tile instanceof IInventory)) continue;
                IInventory inventory = (IInventory)tile;
                int slotID = slot - idDisplacement;
                if (slotID >= 0 && slotID < inventory.func_70302_i_()) {
                    inventory.func_70299_a(slotID, itemStack);
                }
                idDisplacement += inventory.func_70302_i_();
            }
        }
        this.func_70296_d();
    }

    public ItemStack func_70304_b(int slot) {
        if (this.func_70301_a(slot) != null) {
            ItemStack var2 = this.func_70301_a(slot);
            this.func_70299_a(slot, null);
            return var2;
        }
        return null;
    }

    public String func_70303_b() {
        return this.func_70311_o().func_71931_t();
    }

    public void func_70295_k_() {
        this.func_70296_d();
    }

    public void func_70305_f() {
        this.func_70296_d();
    }

    public InventoryCrafting getCraftingMatrix() {
        InventoryCrafting inventoryCrafting = new InventoryCrafting((Container)new ContainerDummy((TileEntity)this), 3, 3);
        for (int i = 0; i < this.craftingMatrix.length; ++i) {
            inventoryCrafting.func_70299_a(i, this.craftingMatrix[i]);
        }
        return inventoryCrafting;
    }

    public void func_70296_d() {
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
            ItemStack filterStack;
            this.outputInventory[0] = null;
            boolean didCraft = false;
            InventoryCrafting inventoryCrafting = this.getCraftingMatrix();
            ItemStack matrixOutput = CraftingManager.func_77594_a().func_82787_a(inventoryCrafting, this.field_70331_k);
            if (matrixOutput != null && this.getCraftingManager().getIdealRecipe(matrixOutput) != null) {
                this.outputInventory[0] = matrixOutput;
                didCraft = true;
            }
            if (!didCraft && (filterStack = this.craftingMatrix[4]) != null && filterStack.func_77973_b() instanceof ItemImprint) {
                HashSet filters = ItemImprint.getFilters((ItemStack)filterStack);
                for (ItemStack outputStack : filters) {
                    ItemStack recipeOutput;
                    Pair idealRecipe;
                    if (outputStack == null || (idealRecipe = this.getCraftingManager().getIdealRecipe(outputStack)) == null || !((recipeOutput = (ItemStack)idealRecipe.left()) != null & recipeOutput.field_77994_a > 0)) continue;
                    this.outputInventory[0] = recipeOutput;
                    didCraft = true;
                    break;
                }
            }
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public void onPickUpFromSlot(EntityPlayer entityPlayer, int slotID, ItemStack itemStack) {
        if (!this.field_70331_k.field_72995_K && itemStack != null) {
            Pair idealRecipeItem = this.getCraftingManager().getIdealRecipe(itemStack);
            if (idealRecipeItem != null) {
                this.getCraftingManager().consumeItems((ItemStack[])((ItemStack[])idealRecipeItem.right()).clone());
            } else {
                itemStack.field_77994_a = 0;
            }
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagList nbtList = nbt.func_74761_m("Items");
        this.craftingMatrix = new ItemStack[9];
        this.outputInventory = new ItemStack[1];
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = (NBTTagCompound)nbtList.func_74743_b(i);
            byte id = stackTag.func_74771_c("Slot");
            if (id < 0 || id >= this.func_70302_i_()) continue;
            this.func_70299_a(id, ItemStack.func_77949_a((NBTTagCompound)stackTag));
        }
        this.searchInventories = nbt.func_74767_n("searchInventories");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        NBTTagList nbtList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(var4);
            nbtList.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)nbtList);
        nbt.func_74757_a("searchInventories", this.searchInventories);
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public int[] func_94128_d(int side) {
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        if (this.func_70301_a(4) != null && this.func_70301_a(4).func_77973_b() instanceof ItemImprint) {
            return true;
        }
        int minSize = 64;
        int optimalSlot = -1;
        for (int i = 0; i < this.craftingMatrix.length; ++i) {
            ItemStack checkStack = this.func_70301_a(i);
            if (checkStack == null || !checkStack.func_77969_a(itemstack) || checkStack.field_77994_a >= minSize && optimalSlot >= 0) continue;
            optimalSlot = i;
            minSize = checkStack.field_77994_a;
        }
        return slot == optimalSlot;
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        ItemStack outputStack = this.func_70301_a(9);
        if (outputStack != null) {
            Pair idealRecipeItem = this.getCraftingManager().getIdealRecipe(outputStack);
            ItemStack[] doubleResults = (ItemStack[])ArrayUtils.addAll((Object[])((Object[])idealRecipeItem.right()), (Object[])((Object[])idealRecipeItem.right()));
            if (!this.getCraftingManager().consumeItems(false, doubleResults)) {
                return false;
            }
        }
        return slot == 9;
    }

    public int[] getCraftingInv() {
        int[] slots = craftingSlots;
        if (this.playerSlots != null) {
            slots = ArrayUtils.addAll((int[])this.playerSlots, (int[])slots);
        }
        if (this.searchInventories) {
            int temporaryInvID = 50;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = new Vector3((TileEntity)this).translate(dir).getTileEntity((IBlockAccess)this.field_70331_k);
                if (!(tile instanceof IInventory)) continue;
                IInventory inventory = (IInventory)tile;
                int[] nearbySlots = new int[inventory.func_70302_i_()];
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    nearbySlots[i] = temporaryInvID++;
                }
                slots = ArrayUtils.addAll((int[])nearbySlots, (int[])slots);
            }
        }
        return slots;
    }

    @SideOnly(value=Side.CLIENT)
    protected TileRender newRenderer() {
        return new TileRender(){

            public boolean renderDynamic(Vector3 position, boolean isItem, float frame) {
                if (!isItem) {
                    GL11.glPushMatrix();
                    RenderItemOverlayUtility.renderItemOnSides((TileEntity)TileEngineeringTable.this, (ItemStack)TileEngineeringTable.this.func_70301_a(9), (double)position.x, (double)position.y, (double)position.z);
                    RenderItemOverlayUtility.renderTopOverlay((TileEntity)TileEngineeringTable.this, (ItemStack[])TileEngineeringTable.this.craftingMatrix, (ForgeDirection)TileEngineeringTable.this.getDirection(), (double)position.x, (double)(position.y - 0.1), (double)position.z);
                    GL11.glPopMatrix();
                }
                return false;
            }
        };
    }
}

