/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.firebox;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import resonant.lib.prefab.block.BlockTile;
import resonant.lib.utility.FluidUtility;
import resonantinduction.archaic.firebox.TileFirebox;

public class BlockFirebox
extends BlockTile {
    private Icon topOn;
    private Icon topOff;
    private Icon sideOn;
    private Icon sideOff;
    private Icon topElectricOn;
    private Icon topElectricOff;
    private Icon sideOnElectric;
    private Icon sideOffElectric;

    public BlockFirebox(int id) {
        super(id, Material.field_76246_e);
        this.func_71907_b(true);
        this.func_111022_d("resonantinduction:material_stone_slab");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconReg) {
        super.func_94332_a(iconReg);
        this.sideOn = iconReg.func_94245_a("resonantinduction:firebox_side_on");
        this.sideOff = iconReg.func_94245_a("resonantinduction:firebox_side_off");
        this.topOn = iconReg.func_94245_a("resonantinduction:firebox_top_on");
        this.topOff = iconReg.func_94245_a("resonantinduction:firebox_top_off");
        this.sideOnElectric = iconReg.func_94245_a("resonantinduction:firebox_electric_side_on");
        this.sideOffElectric = iconReg.func_94245_a("resonantinduction:firebox_electric_side_off");
        this.topElectricOn = iconReg.func_94245_a("resonantinduction:firebox_electric_top_on");
        this.topElectricOff = iconReg.func_94245_a("resonantinduction:firebox_electric_top_off");
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileFirebox) {
            TileFirebox tile = (TileFirebox)tileEntity;
            this.extractItem((IInventory)tile, 0, player);
        }
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileFirebox) {
            TileFirebox tile = (TileFirebox)tileEntity;
            if (FluidUtility.playerActivatedFluidItem((World)world, (int)x, (int)y, (int)z, (EntityPlayer)player, (int)side)) {
                return true;
            }
            return this.interactCurrentItem((IInventory)tile, 0, player);
        }
        return false;
    }

    public Icon func_71895_b(IBlockAccess access, int x, int y, int z, int side) {
        if (side == 0) {
            return this.field_94336_cN;
        }
        boolean isElectric = access.func_72805_g(x, y, z) == 1;
        boolean isBurning = false;
        TileEntity tile = access.func_72796_p(x, y, z);
        if (tile instanceof TileFirebox) {
            isBurning = ((TileFirebox)tile).isBurning();
        }
        if (side == 1) {
            return isBurning ? (isElectric ? this.topElectricOn : this.topOn) : (isElectric ? this.topElectricOff : this.topOff);
        }
        return isBurning ? (isElectric ? this.sideOnElectric : this.sideOn) : (isElectric ? this.sideOffElectric : this.sideOff);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (side == 0) {
            return this.field_94336_cN;
        }
        boolean isElectric = meta == 1;
        boolean isBurning = false;
        if (side == 1) {
            return isBurning ? (isElectric ? this.topElectricOn : this.topOn) : (isElectric ? this.topElectricOff : this.topOff);
        }
        return isBurning ? (isElectric ? this.sideOnElectric : this.sideOn) : (isElectric ? this.sideOffElectric : this.sideOff);
    }

    public void func_71862_a(World world, int x, int y, int z, Random par5Random) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (((TileFirebox)tileEntity).isBurning()) {
            float xDisplace = (float)x + 0.5f;
            float yDisplace = (float)y + 0.0f + par5Random.nextFloat() * 6.0f / 16.0f;
            float zDisplace = (float)z + 0.5f;
            float modifier = 0.52f;
            float randomValue = par5Random.nextFloat() * 0.6f - 0.3f;
            world.func_72869_a("smoke", (double)(xDisplace - modifier), (double)yDisplace, (double)(zDisplace + randomValue), 0.0, 0.0, 0.0);
            world.func_72869_a("flame", (double)(xDisplace - modifier), (double)yDisplace, (double)(zDisplace + randomValue), 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)(xDisplace + modifier), (double)yDisplace, (double)(zDisplace + randomValue), 0.0, 0.0, 0.0);
            world.func_72869_a("flame", (double)(xDisplace + modifier), (double)yDisplace, (double)(zDisplace + randomValue), 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)(xDisplace + randomValue), (double)yDisplace, (double)(zDisplace - modifier), 0.0, 0.0, 0.0);
            world.func_72869_a("flame", (double)(xDisplace + randomValue), (double)yDisplace, (double)(zDisplace - modifier), 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)(xDisplace + randomValue), (double)yDisplace, (double)(zDisplace + modifier), 0.0, 0.0, 0.0);
            world.func_72869_a("flame", (double)(xDisplace + randomValue), (double)yDisplace, (double)(zDisplace + modifier), 0.0, 0.0, 0.0);
            int blockIDAbove = world.func_72798_a(x, y + 1, z);
            if (blockIDAbove == Block.field_71943_B.field_71990_ca) {
                for (int i = 0; i < 4; ++i) {
                    world.func_72869_a("bubble", (double)xDisplace + ((double)par5Random.nextFloat() - 0.5), (double)yDisplace + 1.5, (double)zDisplace + ((double)par5Random.nextFloat() - 0.5), 0.0, 0.05, 0.0);
                }
            }
        }
    }

    public float func_71870_f(IBlockAccess access, int x, int y, int z) {
        TileEntity tileEntity = access.func_72796_p(x, y, z);
        if (((TileFirebox)tileEntity).isBurning()) {
            return 1.0f;
        }
        return 0.0f;
    }

    public int func_71899_b(int par1) {
        return par1;
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
    }

    public TileEntity func_72274_a(World world) {
        return new TileFirebox();
    }
}

