/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.firebox;

import com.google.common.io.ByteArrayDataInput;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.Synced;
import resonant.lib.prefab.tile.TileElectricalInventory;
import resonant.lib.thermal.BoilEvent;
import resonant.lib.thermal.ThermalPhysics;
import resonantinduction.archaic.Archaic;
import resonantinduction.archaic.fluid.gutter.TileGutter;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.resource.ResourceGenerator;
import resonantinduction.core.resource.TileMaterial;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.vector.Vector3;

public class TileFirebox
extends TileElectricalInventory
implements IPacketReceiver,
IFluidHandler {
    private final long POWER = 100000L;
    protected FluidTank tank = new FluidTank(1000);
    @Synced
    private int burnTime;
    private long heatEnergy = 0L;
    private int boiledVolume;

    public TileFirebox() {
        this.energy = new EnergyStorageHandler(100000L, 10000L);
        this.setIO(ForgeDirection.UP, 0);
    }

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            FluidStack drainFluid = this.tank.drain(1000, false);
            if (drainFluid != null && drainFluid.amount == 1000 && drainFluid.fluidID == FluidRegistry.LAVA.getID()) {
                if (this.burnTime == 0) {
                    this.tank.drain(1000, true);
                    this.burnTime += 20000;
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
            } else if (this.isElectrical() && this.energy.checkExtract()) {
                this.energy.extractEnergy();
                if (this.burnTime == 0) {
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
                this.burnTime += 2;
            } else if (this.canBurn(this.func_70301_a(0)) && this.burnTime == 0) {
                this.burnTime += TileEntityFurnace.func_70398_a((ItemStack)this.func_70301_a(0));
                this.func_70298_a(0, 1);
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            int blockID = this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
            if (this.burnTime > 0) {
                TileEntity tileEntity;
                if (blockID == 0 && blockID != Block.field_72067_ar.field_71990_ca) {
                    this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, Block.field_72067_ar.field_71990_ca);
                }
                this.heatEnergy += 5000L;
                boolean usedHeat = false;
                if (blockID == ResonantInduction.blockDust.field_71990_ca || blockID == ResonantInduction.blockRefinedDust.field_71990_ca) {
                    usedHeat = true;
                    TileEntity dustTile = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
                    if (dustTile instanceof TileMaterial) {
                        String name = ((TileMaterial)dustTile).name;
                        int meta = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
                        if (this.heatEnergy >= this.getMeltIronEnergy((float)(meta + 1) / 7.0f * 1000.0f)) {
                            int volumeMeta = blockID == ResonantInduction.blockRefinedDust.field_71990_ca ? meta : meta / 2;
                            this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, ResourceGenerator.getMolten((String)name).field_71990_ca, volumeMeta, 3);
                            TileEntity tile = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
                            if (tile instanceof TileMaterial) {
                                ((TileMaterial)tile).name = name;
                            }
                            this.heatEnergy = 0L;
                        }
                    }
                } else if (blockID == Block.field_71943_B.field_71990_ca) {
                    usedHeat = true;
                    int volume = 100;
                    if (this.heatEnergy >= this.getRequiredBoilWaterEnergy(volume)) {
                        if (FluidRegistry.getFluid((String)"steam") != null) {
                            MinecraftForge.EVENT_BUS.post((Event)new BoilEvent(this.field_70331_k, new Vector3((TileEntity)this).translate(0.0, 1.0, 0.0), new FluidStack(FluidRegistry.WATER, volume), new FluidStack(FluidRegistry.getFluid((String)"steam"), volume), 2, false));
                            this.boiledVolume += volume;
                        }
                        if (this.boiledVolume >= 1000) {
                            this.boiledVolume = 0;
                            this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, 0);
                        }
                        this.heatEnergy = 0L;
                    }
                } else if (blockID == Archaic.blockGutter.field_71990_ca && (tileEntity = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)) instanceof TileGutter) {
                    usedHeat = true;
                    int volume = Math.min(((TileGutter)tileEntity).getInternalTank().getFluidAmount(), 10);
                    if (volume > 0 && this.heatEnergy >= this.getRequiredBoilWaterEnergy(volume)) {
                        if (FluidRegistry.getFluid((String)"steam") != null) {
                            MinecraftForge.EVENT_BUS.post((Event)new BoilEvent(this.field_70331_k, new Vector3((TileEntity)this).translate(0.0, 1.0, 0.0), new FluidStack(FluidRegistry.WATER, volume), new FluidStack(FluidRegistry.getFluid((String)"steam"), volume), 2, false));
                            ((TileGutter)tileEntity).drain(ForgeDirection.DOWN, volume, true);
                        }
                        this.heatEnergy = 0L;
                    }
                }
                if (!usedHeat) {
                    this.heatEnergy = 0L;
                }
                if (--this.burnTime == 0) {
                    if (blockID == Block.field_72067_ar.field_71990_ca) {
                        this.field_70331_k.func_94575_c(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n, 0);
                    }
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
            }
        }
    }

    public long getRequiredBoilWaterEnergy(int volume) {
        return (long)ThermalPhysics.getRequiredBoilWaterEnergy((World)this.field_70331_k, (int)this.field_70329_l, (int)this.field_70327_n, (int)volume);
    }

    public long getMeltIronEnergy(float volume) {
        float temperatureChange = 1811.0f - ThermalPhysics.getTemperatureForCoordinate((World)this.field_70331_k, (int)this.field_70329_l, (int)this.field_70327_n);
        float mass = ThermalPhysics.getMass((float)volume, (float)7.9f);
        return (long)(ThermalPhysics.getEnergyForTemperatureChange((float)mass, (double)450.0, (float)temperatureChange) + ThermalPhysics.getEnergyForStateChange((float)mass, (double)272000.0));
    }

    public boolean canConnect(ForgeDirection direction, Object obj) {
        return this.isElectrical() && super.canConnect(direction, obj);
    }

    public boolean isElectrical() {
        return this.func_70322_n() == 1;
    }

    public boolean canBurn(ItemStack stack) {
        return TileEntityFurnace.func_70398_a((ItemStack)stack) > 0;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i == 0 && this.canBurn(itemStack);
    }

    public Packet func_70319_e() {
        return ResonantInduction.PACKET_ANNOTATION.getPacket((Object)this);
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.burnTime = nbt.func_74762_e("burnTime");
        this.tank.readFromNBT(nbt);
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("burnTime", this.burnTime);
        this.tank.writeToNBT(nbt);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || resource.getFluid() == FluidRegistry.LAVA) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.LAVA;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

