/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.firebox;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.IPacketSender;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.tile.TileExternalInventory;
import resonantinduction.archaic.firebox.TileFirebox;
import resonantinduction.core.ResonantInduction;

public class TileHotPlate
extends TileExternalInventory
implements IPacketSender,
IPacketReceiver {
    private final int POWER = 50000;
    public final int[] smeltTime = new int[]{0, 0, 0, 0};
    public final int[] stackSizeCache = new int[]{0, 0, 0, 0};
    public static final int MAX_SMELT_TIME = 200;

    public TileHotPlate() {
        this.maxSlots = 4;
    }

    public void func_70316_g() {
        if (this.canRun()) {
            boolean didSmelt = false;
            for (int i = 0; i < this.maxSlots; ++i) {
                if (this.canSmelt(this.func_70301_a(i))) {
                    if (this.smeltTime[i] <= 0) {
                        this.stackSizeCache[i] = this.func_70301_a((int)i).field_77994_a;
                        this.smeltTime[i] = 200 * this.stackSizeCache[i];
                        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                    } else if (this.smeltTime[i] > 0) {
                        int n = i;
                        this.smeltTime[n] = this.smeltTime[n] - 1;
                        if (this.smeltTime[n] == 0 && !this.field_70331_k.field_72995_K) {
                            ItemStack outputStack = FurnaceRecipes.func_77602_a().getSmeltingResult(this.func_70301_a(i)).func_77946_l();
                            outputStack.field_77994_a = this.stackSizeCache[i];
                            this.func_70299_a(i, outputStack);
                            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                        }
                    }
                    didSmelt = true;
                    continue;
                }
                this.smeltTime[i] = 0;
            }
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        for (int i = 0; i < this.maxSlots; ++i) {
            if (this.func_70301_a(i) != null) {
                if (this.stackSizeCache[i] == this.func_70301_a((int)i).field_77994_a) continue;
                if (this.smeltTime[i] > 0) {
                    int n = i;
                    this.smeltTime[n] = this.smeltTime[n] + (this.func_70301_a((int)i).field_77994_a - this.stackSizeCache[i]) * 200;
                }
                this.stackSizeCache[i] = this.func_70301_a((int)i).field_77994_a;
                continue;
            }
            this.stackSizeCache[i] = 0;
        }
        if (this.field_70331_k != null) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public boolean canRun() {
        TileEntity tileEntity = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        return tileEntity instanceof TileFirebox && ((TileFirebox)tileEntity).isBurning();
    }

    public boolean canSmelt(ItemStack stack) {
        return FurnaceRecipes.func_77602_a().getSmeltingResult(stack) != null;
    }

    public boolean isSmelting() {
        for (int i = 0; i < this.maxSlots; ++i) {
            if (this.getSmeltTime(i) <= 0) continue;
            return true;
        }
        return false;
    }

    public int getSmeltTime(int i) {
        return this.smeltTime[i];
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i < this.maxSlots && this.canSmelt(itemStack);
    }

    public Packet func_70319_e() {
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, this.getPacketData(0).toArray());
    }

    public List getPacketData(int type) {
        ArrayList<NBTTagCompound> list = new ArrayList<NBTTagCompound>();
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        list.add(nbt);
        return list;
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            this.func_70307_a(PacketHandler.readNBTTagCompound((DataInput)data));
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        for (int i = 0; i < this.maxSlots; ++i) {
            this.smeltTime[i] = nbt.func_74762_e("smeltTime" + i);
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        for (int i = 0; i < this.maxSlots; ++i) {
            nbt.func_74768_a("smeltTime" + i, this.smeltTime[i]);
        }
    }
}

