/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.fluid.tank;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import resonant.lib.utility.LanguageUtility;
import resonantinduction.core.grid.fluid.TileFluidDistribution;
import universalelectricity.api.energy.UnitDisplay;

public class ItemBlockTank
extends ItemBlock
implements IFluidContainerItem {
    public ItemBlockTank(int id) {
        super(id);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        FluidStack fluid;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("fluid") && (fluid = this.getFluid(stack)) != null) {
            list.add("Fluid: " + fluid.getFluid().getLocalizedName());
            list.add("Volume: " + UnitDisplay.getDisplay((double)fluid.amount, (UnitDisplay.Unit)UnitDisplay.Unit.LITER, (UnitDisplay.UnitPrefix)UnitDisplay.UnitPrefix.MILLI));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("fluid")) {
            return 1;
        }
        return this.field_77777_bU;
    }

    public String func_77667_c(ItemStack itemStack) {
        String translation = LanguageUtility.getLocal((String)(Block.field_71973_m[this.func_77883_f()].func_71917_a() + "." + itemStack.func_77960_j()));
        if (translation == null || translation.isEmpty()) {
            return Block.field_71973_m[this.func_77883_f()].func_71917_a();
        }
        return Block.field_71973_m[this.func_77883_f()].func_71917_a() + "." + itemStack.func_77960_j();
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            TileEntity tile = world.func_72796_p(x, y, z);
            if (tile instanceof TileFluidDistribution) {
                ((TileFluidDistribution)tile).setSubID(stack.func_77960_j());
                ((TileFluidDistribution)tile).getInternalTank().fill(this.getFluid(stack), true);
            }
            return true;
        }
        return false;
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("fluid"));
    }

    public int getCapacity(ItemStack container) {
        return 16;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("fluid")) {
                return Math.min(this.getCapacity(container), resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("fluid"));
            if (stack == null) {
                return Math.min(this.getCapacity(container), resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.getCapacity(container) - stack.amount, resource.amount);
        }
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        if (!container.field_77990_d.func_74764_b("fluid")) {
            NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
            if (this.getCapacity(container) < resource.amount) {
                fluidTag.func_74768_a("Amount", this.getCapacity(container));
                container.field_77990_d.func_74782_a("fluid", (NBTBase)fluidTag);
                return this.getCapacity(container);
            }
            container.field_77990_d.func_74782_a("fluid", (NBTBase)fluidTag);
            return resource.amount;
        }
        NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.getCapacity(container) - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = this.getCapacity(container);
        }
        container.field_77990_d.func_74782_a("fluid", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("fluid") || maxDrain == 0) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("fluid"));
        if (stack == null) {
            return null;
        }
        int drained = Math.min(stack.amount, maxDrain);
        if (doDrain) {
            if (maxDrain >= stack.amount) {
                container.field_77990_d.func_82580_o("fluid");
                if (container.field_77990_d.func_82582_d()) {
                    container.field_77990_d = null;
                }
                return stack;
            }
            NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("fluid");
            fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - maxDrain);
            container.field_77990_d.func_74782_a("fluid", (NBTBase)fluidTag);
        }
        stack.amount = drained;
        return stack;
    }
}

