/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.fluid.tank;

import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import resonantinduction.core.grid.fluid.FluidDistributionetwork;
import resonantinduction.core.grid.fluid.IFluidDistribution;

public class TankNetwork
extends FluidDistributionetwork {
    public TankNetwork() {
        this.needsUpdate = true;
    }

    public void update() {
        int totalFluid;
        FluidStack networkTankFluid = this.getTank().getFluid();
        int lowestY = 255;
        int highestY = 0;
        int connectorCount = 0;
        int n = totalFluid = networkTankFluid != null ? networkTankFluid.amount : 0;
        if (this.getConnectors().size() > 0) {
            IFluidDistribution tank = (IFluidDistribution)this.getConnectors().toArray()[0];
            if (this.getConnectors().size() == 1) {
                tank.getInternalTank().setFluid(networkTankFluid);
                tank.onFluidChanged();
                this.needsUpdate = false;
                return;
            }
            if (networkTankFluid != null) {
                if (networkTankFluid.getFluid().isGaseous()) {
                    connectorCount = this.getConnectors().size();
                    for (IFluidDistribution connector : this.getConnectors()) {
                        FluidStack input = networkTankFluid.copy();
                        input.amount = totalFluid / connectorCount + totalFluid % connectorCount;
                        connector.getInternalTank().setFluid(null);
                        totalFluid -= connector.getInternalTank().fill(input, true);
                        connector.onFluidChanged();
                        if (connectorCount <= 0) continue;
                        --connectorCount;
                    }
                } else {
                    HashMap<Integer, LinkedList> heightMap = new HashMap<Integer, LinkedList>();
                    for (IFluidDistribution connector : this.getConnectors()) {
                        if (!(connector instanceof TileEntity)) continue;
                        LinkedList list = new LinkedList();
                        int yCoord = ((TileEntity)connector).field_70330_m;
                        if (yCoord < lowestY) {
                            lowestY = yCoord;
                        }
                        if (yCoord > highestY) {
                            highestY = yCoord;
                        }
                        if (heightMap.containsKey(yCoord)) {
                            list = (LinkedList)heightMap.get(yCoord);
                        }
                        list.add(connector);
                        heightMap.put(yCoord, list);
                    }
                    for (int yLevel = lowestY; yLevel <= highestY; ++yLevel) {
                        if (!heightMap.containsKey(yLevel) || (connectorCount = ((LinkedList)heightMap.get(yLevel)).size()) <= 0) continue;
                        for (IFluidDistribution connector : (LinkedList)heightMap.get(yLevel)) {
                            if (totalFluid <= 0) {
                                connector.getInternalTank().setFluid(null);
                                connector.onFluidChanged();
                                continue;
                            }
                            FluidStack input = networkTankFluid.copy();
                            input.amount = totalFluid / connectorCount + totalFluid % connectorCount;
                            connector.getInternalTank().setFluid(null);
                            totalFluid -= connector.getInternalTank().fill(input, true);
                            connector.onFluidChanged();
                            if (connectorCount <= 1) continue;
                            --connectorCount;
                        }
                    }
                }
            } else {
                for (IFluidDistribution connector : this.getConnectors()) {
                    connector.getInternalTank().setFluid(null);
                    connector.onFluidChanged();
                }
            }
        }
        this.needsUpdate = false;
    }

    public TankNetwork newInstance() {
        return new TankNetwork();
    }
}

