/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.fluid.tank;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;
import resonant.api.IRemovable;
import resonant.lib.content.module.TileBlock;
import resonant.lib.content.module.TileRender;
import resonant.lib.render.FluidRenderUtility;
import resonant.lib.render.RenderUtility;
import resonant.lib.utility.FluidUtility;
import resonant.lib.utility.WorldUtility;
import resonant.lib.utility.render.RenderBlockUtility;
import resonantinduction.archaic.Archaic;
import resonantinduction.archaic.fluid.tank.ItemBlockTank;
import resonantinduction.archaic.fluid.tank.TankNetwork;
import resonantinduction.core.grid.fluid.FluidDistributionetwork;
import resonantinduction.core.grid.fluid.IFluidDistribution;
import resonantinduction.core.grid.fluid.TileFluidDistribution;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.net.INodeNetwork;
import universalelectricity.api.vector.Vector3;

public class TileTank
extends TileFluidDistribution
implements TileBlock.IComparatorInputOverride,
IRemovable.ISneakPickup {
    public static final int VOLUME = 16;

    public TileTank() {
        super(UniversalElectricity.machine, 16000);
        this.isOpaqueCube = false;
        this.normalRender = false;
        this.itemBlock = ItemBlockTank.class;
    }

    public boolean shouldSideBeRendered(IBlockAccess access, int x, int y, int z, int side) {
        return access != null && this.block != null && access.func_72798_a(x, y, z) != this.block.field_71990_ca;
    }

    protected boolean use(EntityPlayer player, int side, Vector3 vector3) {
        if (!this.world().field_72995_K) {
            return FluidUtility.playerActivatedFluidItem((World)this.world(), (int)this.x(), (int)this.y(), (int)this.z(), (EntityPlayer)player, (int)side);
        }
        return true;
    }

    public int getComparatorInputOverride(int side) {
        if (this.getNetwork().getTank().getFluid() != null) {
            return (int)(15.0 * ((double)this.getNetwork().getTank().getFluidAmount() / (double)this.getNetwork().getTank().getCapacity()));
        }
        return 0;
    }

    public int getLightValue(IBlockAccess access) {
        if (this.getInternalTank().getFluid() != null) {
            return this.getInternalTank().getFluid().getFluid().getLuminosity();
        }
        return super.getLightValue(access);
    }

    public FluidDistributionetwork getNetwork() {
        if (this.network == null) {
            this.network = new TankNetwork();
            this.network.addConnector((IFluidDistribution)this);
        }
        return this.network;
    }

    public void setNetwork(FluidDistributionetwork network) {
        if (network instanceof TankNetwork) {
            this.network = network;
        }
    }

    public void validateConnectionSide(TileEntity tileEntity, ForgeDirection side) {
        if (!this.field_70331_k.field_72995_K && tileEntity instanceof TileTank) {
            this.getNetwork().merge((INodeNetwork)((IFluidDistribution)tileEntity).getNetwork());
            this.renderSides = WorldUtility.setEnableSide((byte)this.renderSides, (ForgeDirection)side, (boolean)true);
            this.connectedBlocks[side.ordinal()] = tileEntity;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected TileRender newRenderer() {
        return new TileRender(){

            public boolean renderStatic(RenderBlocks renderer, Vector3 position) {
                RenderBlockUtility.tessellateBlockWithConnectedTextures((byte)TileTank.this.renderSides, (IBlockAccess)TileTank.this.world(), (int)TileTank.this.x(), (int)TileTank.this.y(), (int)TileTank.this.z(), (Block)Archaic.blockTank, null, (Icon)RenderUtility.getIcon((String)"resonantinduction:tankEdge"));
                return true;
            }

            public void renderTank(TileEntity tileEntity, double x, double y, double z, FluidStack fluid) {
                if (tileEntity.field_70331_k != null && tileEntity instanceof TileTank) {
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
                    if (fluid != null) {
                        GL11.glPushMatrix();
                        if (!fluid.getFluid().isGaseous()) {
                            GL11.glScaled((double)0.99, (double)0.99, (double)0.99);
                            FluidTank tank = ((TileTank)tileEntity).getInternalTank();
                            double percentageFilled = (double)tank.getFluidAmount() / (double)tank.getCapacity();
                            double ySouthEast = FluidUtility.getAveragePercentageFilledForSides(TileTank.class, (double)percentageFilled, (World)tileEntity.field_70331_k, (Vector3)new Vector3(tileEntity), (ForgeDirection[])new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.EAST});
                            double yNorthEast = FluidUtility.getAveragePercentageFilledForSides(TileTank.class, (double)percentageFilled, (World)tileEntity.field_70331_k, (Vector3)new Vector3(tileEntity), (ForgeDirection[])new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST});
                            double ySouthWest = FluidUtility.getAveragePercentageFilledForSides(TileTank.class, (double)percentageFilled, (World)tileEntity.field_70331_k, (Vector3)new Vector3(tileEntity), (ForgeDirection[])new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST});
                            double yNorthWest = FluidUtility.getAveragePercentageFilledForSides(TileTank.class, (double)percentageFilled, (World)tileEntity.field_70331_k, (Vector3)new Vector3(tileEntity), (ForgeDirection[])new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.WEST});
                            FluidRenderUtility.renderFluidTesselation((IFluidTank)tank, (double)ySouthEast, (double)yNorthEast, (double)ySouthWest, (double)yNorthWest);
                        } else {
                            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                            GL11.glScaled((double)0.99, (double)0.99, (double)0.99);
                            int capacity = tileEntity instanceof TileTank ? ((TileTank)tileEntity).getInternalTank().getCapacity() : fluid.amount;
                            double filledPercentage = (double)fluid.amount / (double)capacity;
                            double renderPercentage = fluid.getFluid().isGaseous() ? 1.0 : filledPercentage;
                            int[] displayList = FluidRenderUtility.getFluidDisplayLists((FluidStack)fluid, (World)tileEntity.field_70331_k, (boolean)false);
                            GL11.glPushAttrib((int)8192);
                            GL11.glEnable((int)2884);
                            GL11.glDisable((int)2896);
                            GL11.glEnable((int)3042);
                            GL11.glBlendFunc((int)770, (int)771);
                            Color color = new Color(fluid.getFluid().getColor());
                            RenderUtility.enableBlending();
                            GL11.glColor4d((double)((float)color.getRed() / 255.0f), (double)((float)color.getGreen() / 255.0f), (double)((float)color.getBlue() / 255.0f), (double)(fluid.getFluid().isGaseous() ? filledPercentage : 1.0));
                            RenderUtility.bind((ResourceLocation)FluidRenderUtility.getFluidSheet((FluidStack)fluid));
                            GL11.glCallList((int)displayList[(int)(renderPercentage * 99.0)]);
                            RenderUtility.disableBlending();
                            GL11.glPopAttrib();
                        }
                        GL11.glPopMatrix();
                    }
                    GL11.glPopMatrix();
                }
            }

            public boolean renderDynamic(Vector3 position, boolean isItem, float frame) {
                this.renderTank((TileEntity)TileTank.this, position.x, position.y, position.z, TileTank.this.getInternalTank().getFluid());
                return false;
            }

            public boolean renderItem(ItemStack itemStack) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
                RenderBlockUtility.tessellateBlockWithConnectedTextures((int)itemStack.func_77960_j(), (Block)Archaic.blockTank, null, (Icon)RenderUtility.getIcon((String)"resonantinduction:tankEdge"));
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)-0.1, (double)0.0);
                FluidStack fluid = null;
                if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("fluid")) {
                    fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.func_77978_p().func_74775_l("fluid"));
                }
                this.renderTank((TileEntity)TileTank.this, 0.0, 0.0, 0.0, fluid);
                GL11.glPopMatrix();
                return true;
            }
        };
    }

    public List<ItemStack> getRemovedItems(EntityPlayer entity) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = new ItemStack(Archaic.blockTank, 1, 0);
        if (itemStack != null) {
            FluidStack stack;
            if (this.getInternalTank() != null && this.getInternalTank().getFluid() != null && (stack = this.getInternalTank().getFluid()) != null) {
                if (itemStack.func_77978_p() == null) {
                    itemStack.func_77982_d(new NBTTagCompound());
                }
                this.drain(ForgeDirection.UNKNOWN, stack.amount, false);
                itemStack.func_77978_p().func_74766_a("fluid", stack.writeToNBT(new NBTTagCompound()));
            }
            drops.add(itemStack);
        }
        return drops;
    }
}

