/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.process;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataInput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import resonant.api.recipe.MachineRecipes;
import resonant.api.recipe.RecipeResource;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.tile.TileExternalInventory;
import resonant.lib.utility.FluidUtility;
import resonantinduction.core.ResonantInduction;
import universalelectricity.api.vector.Vector3;

public class TileCastingMold
extends TileExternalInventory
implements IFluidHandler,
IPacketReceiver {
    protected FluidTank tank = new FluidTank(1000);
    private final int amountPerIngot = 100;

    public boolean canUpdate() {
        return false;
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{nbt});
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            this.func_70307_a(PacketHandler.readNBTTagCompound((DataInput)data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_70296_d() {
        if (this.field_70331_k != null) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public void func_70316_g() {
        Vector3 checkPos = new Vector3((TileEntity)this).translate(0.0, 1.0, 0.0);
        FluidStack drainStack = FluidUtility.drainBlock((World)this.field_70331_k, (Vector3)checkPos, (boolean)false);
        if (MachineRecipes.INSTANCE.getOutput(ResonantInduction.RecipeType.SMELTER.name(), new Object[]{drainStack}).length > 0 && drainStack.amount == this.tank.fill(drainStack, false)) {
            this.tank.fill(FluidUtility.drainBlock((World)this.field_70331_k, (Vector3)checkPos, (boolean)true), true);
        }
        while (this.tank.getFluidAmount() >= 100 && (this.func_70301_a(0) == null || this.func_70301_a((int)0).field_77994_a < this.func_70301_a(0).func_77976_d())) {
            RecipeResource[] outputs;
            for (RecipeResource output : outputs = MachineRecipes.INSTANCE.getOutput(ResonantInduction.RecipeType.SMELTER.name(), new Object[]{this.tank.getFluid()})) {
                this.incrStackSize(0, output.getItemStack());
            }
            this.tank.drain(100, true);
        }
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.tank.writeToNBT(tag);
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.tank.readFromNBT(tag);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int fill = this.tank.fill(resource, doFill);
        this.func_70316_g();
        return fill;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid != null && fluid.getName().contains("molten");
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

