/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core;

import net.minecraft.nbt.NBTTagCompound;
import resonant.lib.utility.nbt.ISaveObj;
import resonant.lib.utility.nbt.NBTUtility;

public class ArgumentData
implements ISaveObj {
    protected String name;
    protected Object currentValue;
    protected final Object defaultValue;

    public ArgumentData(String name, Object defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
    }

    public boolean setData(Object object) {
        if (this.isValid(object)) {
            this.currentValue = object;
            return true;
        }
        return false;
    }

    public Object getData() {
        return this.currentValue;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValid(Object object) {
        return object != null;
    }

    public boolean isValid() {
        return true;
    }

    public String warning() {
        return "";
    }

    public void save(NBTTagCompound nbt) {
        NBTUtility.saveObject((NBTTagCompound)nbt, (String)"ObjectData", (Object)this.currentValue);
    }

    public void load(NBTTagCompound nbt) {
        this.currentValue = NBTUtility.loadObject((NBTTagCompound)nbt, (String)"ObjectData");
    }
}

