/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public class MultipartUtility {
    public static TileMultipart getMultipartTile(IBlockAccess access, BlockCoord pos) {
        TileEntity te = access.func_72796_p(pos.x, pos.y, pos.z);
        return te instanceof TileMultipart ? (TileMultipart)te : null;
    }

    public static TMultiPart getMultipart(World world, Vector3 vector, int partMap) {
        return MultipartUtility.getMultipart(new VectorWorld(world, (IVector3)vector), partMap);
    }

    public static TMultiPart getMultipart(VectorWorld vector, int partMap) {
        return MultipartUtility.getMultipart(vector.world, vector.intX(), vector.intY(), vector.intZ(), partMap);
    }

    public static TMultiPart getMultipart(World world, int x, int y, int z, int partMap) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileMultipart) {
            return ((TileMultipart)tile).partMap(partMap);
        }
        return null;
    }

    public static boolean canPlaceWireOnSide(World w, int x, int y, int z, ForgeDirection side, boolean _default) {
        if (!w.func_72899_e(x, y, z)) {
            return _default;
        }
        Block b = Block.field_71973_m[w.func_72798_a(x, y, z)];
        if (b == null) {
            return false;
        }
        if (b == Block.field_72014_bd || b == Block.field_71963_Z || b == Block.field_71956_V || b == Block.field_72095_ac) {
            return true;
        }
        return b.isBlockSolidOnSide(w, x, y, z, side);
    }

    public static int isDye(ItemStack is) {
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        for (int i = 0; i < dyes.length; ++i) {
            if (OreDictionary.getOreID((ItemStack)is) == -1 || !OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)is)).equals(dyes[i])) continue;
            return i;
        }
        return -1;
    }
}

