/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.modstats.ModstatInfo;
import org.modstats.Modstats;
import resonant.api.recipe.MachineRecipes;
import resonant.lib.config.ConfigHandler;
import resonant.lib.content.ContentRegistry;
import resonant.lib.network.PacketAnnotation;
import resonant.lib.network.PacketHandler;
import resonant.lib.network.PacketTile;
import resonant.lib.prefab.item.ItemBlockMetadata;
import resonant.lib.utility.LanguageUtility;
import resonantinduction.core.CommandMachine;
import resonantinduction.core.CommonProxy;
import resonantinduction.core.Reference;
import resonantinduction.core.Settings;
import resonantinduction.core.TabRI;
import resonantinduction.core.blocks.BlockIndustrialStone;
import resonantinduction.core.blocks.IndustrialStoneBlocksRecipes;
import resonantinduction.core.handler.TextureHookHandler;
import resonantinduction.core.items.ItemDevStaff;
import resonantinduction.core.items.ItemFlour;
import resonantinduction.core.prefab.part.PacketMultiPart;
import resonantinduction.core.resource.BlockDust;
import resonantinduction.core.resource.ItemBiomass;
import resonantinduction.core.resource.ItemOreResource;
import resonantinduction.core.resource.ResourceGenerator;
import resonantinduction.core.resource.TileDust;
import resonantinduction.core.resource.fluid.ItemOreResourceBucket;
import resonantinduction.core.resource.fluid.TileFluidMixture;

@Mod(modid="ResonantInduction|Core", name="Resonant Induction", version="0.3.1", dependencies="required-after:ForgeMultipart@[1.0.0.244,);required-after:ResonantEngine;before:ThermalExpansion;before:Mekanism")
@NetworkMod(channels={"resonindc"}, clientSideRequired=true, serverSideRequired=false, packetHandler=PacketHandler.class)
@ModstatInfo(prefix="resonantin")
public class ResonantInduction {
    public static final String ID = "ResonantInduction|Core";
    public static final String NAME = "Resonant Induction";
    public static final Logger LOGGER = Logger.getLogger("Resonant Induction");
    public static final PacketTile PACKET_TILE = new PacketTile("resonindc");
    public static final PacketMultiPart PACKET_MULTIPART = new PacketMultiPart("resonindc");
    public static final PacketAnnotation PACKET_ANNOTATION = new PacketAnnotation("resonindc");
    public static final HashMap<Integer, BlockFluidFinite> blockMixtureFluids = new HashMap();
    public static final HashMap<Integer, BlockFluidFinite> blockMoltenFluid = new HashMap();
    public static final ContentRegistry contentRegistry = new ContentRegistry(Settings.CONFIGURATION, Settings.idManager, "ResonantInduction|Core").setPrefix("resonantinduction:").setTab((CreativeTabs)TabRI.CORE);
    @Mod.Instance(value="ResonantInduction|Core")
    public static ResonantInduction INSTANCE;
    @SidedProxy(clientSide="resonantinduction.core.ClientProxy", serverSide="resonantinduction.core.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Metadata(value="ResonantInduction|Core")
    public static ModMetadata metadata;
    public static Block blockOre;
    public static ItemOreResource itemRubble;
    public static ItemOreResource itemDust;
    public static ItemOreResource itemRefinedDust;
    public static ItemOreResourceBucket itemBucketMixture;
    public static ItemOreResourceBucket itemBucketMolten;
    public static Item itemBiomass;
    public static Item itemDevStaff;
    public static Item itemFlour;
    public static Item itemBakingTrayWithBread;
    public static Block blockDust;
    public static Block blockRefinedDust;
    public static Block blockIndustrialStone;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        LOGGER.setParent(FMLLog.getLogger());
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        Modstats.instance().getReporter().registerMod((Object)this);
        Settings.CONFIGURATION.load();
        MinecraftForge.EVENT_BUS.register((Object)ResourceGenerator.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new TextureHookHandler());
        blockIndustrialStone = contentRegistry.createBlock(BlockIndustrialStone.class, ItemBlockMetadata.class);
        blockDust = contentRegistry.createBlock("dust", BlockDust.class, null, TileDust.class).func_71849_a(null);
        blockRefinedDust = contentRegistry.createBlock("refinedDust", BlockDust.class, null, TileDust.class).func_71849_a(null);
        itemRubble = new ItemOreResource(Settings.getNextItemID("oreRubble"), "oreRubble");
        itemDust = new ItemOreResource(Settings.getNextItemID("oreDust"), "oreDust");
        itemRefinedDust = new ItemOreResource(Settings.getNextItemID("oreRefinedDust"), "oreRefinedDust");
        itemBucketMixture = new ItemOreResourceBucket(Settings.getNextItemID("bucketMixture"), "bucketMixture", false);
        itemBucketMolten = new ItemOreResourceBucket(Settings.getNextItemID("bucketMolten"), "bucketMolten", true);
        itemBiomass = contentRegistry.createItem(ItemBiomass.class);
        itemDevStaff = contentRegistry.createItem(ItemDevStaff.class);
        itemFlour = contentRegistry.createItem(ItemFlour.class);
        GameRegistry.registerItem((Item)itemRubble, (String)itemRubble.func_77658_a());
        GameRegistry.registerItem((Item)itemDust, (String)itemDust.func_77658_a());
        GameRegistry.registerItem((Item)itemRefinedDust, (String)itemRefinedDust.func_77658_a());
        GameRegistry.registerItem((Item)itemBucketMixture, (String)itemBucketMixture.func_77658_a());
        GameRegistry.registerItem((Item)itemBucketMolten, (String)itemBucketMolten.func_77658_a());
        GameRegistry.registerTileEntity(TileFluidMixture.class, (String)"ri_fluid_mixture");
        proxy.preInit();
        TabRI.ITEMSTACK = new ItemStack(blockIndustrialStone);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        LOGGER.fine("Languages Loaded:" + LanguageUtility.loadLanguages((String)"/assets/resonantinduction/languages/", (String[])Reference.LANGUAGES));
        Settings.setModMetadata(metadata, ID, NAME);
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        ConfigHandler.configure((Configuration)Settings.CONFIGURATION, (String)"resonantinduction");
        ResourceGenerator.generateOreResources();
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(itemFlour, new Object[]{Item.field_77685_T, Item.field_77685_T}));
        FurnaceRecipes.func_77602_a().addSmelting(ResonantInduction.itemFlour.field_77779_bT, 1, new ItemStack(Item.field_77684_U), 50.0f);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemFlour, 1, 1), new Object[]{itemFlour, Item.field_77786_ax}));
        MachineRecipes.INSTANCE.addRecipe(RecipeType.GRINDER.name(), (Object)Item.field_77685_T, new Object[]{itemFlour});
        proxy.postInit();
        Settings.CONFIGURATION.save();
        IndustrialStoneBlocksRecipes.init();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        CommandMachine commandSentry = new CommandMachine();
        MinecraftForge.EVENT_BUS.register((Object)commandSentry);
        ICommandManager commandManager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
        ServerCommandManager serverCommandManager = (ServerCommandManager)commandManager;
        serverCommandManager.func_71560_a((ICommand)commandSentry);
    }

    public static enum RecipeType {
        CRUSHER,
        GRINDER,
        MIXER,
        SMELTER,
        SAWMILL;

    }
}

