/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModMetadata;
import java.io.File;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.Configuration;
import resonant.api.recipe.QuantumAssemblerRecipes;
import resonant.lib.config.Config;
import resonant.lib.content.IDManager;
import resonant.lib.prefab.poison.PotionRadiation;
import resonant.lib.utility.LanguageUtility;

public class Settings {
    public static final Configuration CONFIGURATION = new Configuration(new File(Loader.instance().getConfigDir(), "Resonant Induction.cfg"));
    public static final String DOMAIN = "resonantinduction";
    public static final IDManager idManager;
    @Config(key="Engineering Table Autocraft")
    public static boolean ALLOW_ENGINEERING_AUTOCRAFT;
    @Config(key="Tesla Sound FXs")
    public static boolean SOUND_FXS;
    @Config(key="Shiny silver Wires")
    public static boolean SHINY_SILVER;
    @Config(key="Max EM Contractor Path")
    public static int MAX_LEVITATOR_DISTANCE;
    @Config(category="general", key="Levitator Max Reach")
    public static int LEVITATOR_MAX_REACH;
    @Config(category="general", key="Levitator Push Delay")
    public static int LEVITATOR_PUSH_DELAY;
    @Config(category="general", key="Levitator Max Speed")
    public static double LEVITATOR_MAX_SPEED;
    @Config(category="general", key="Levitator Acceleration")
    public static double LEVITATOR_ACCELERATION;
    @Config(category="Power", key="Wind_tubine_Ratio")
    public static int WIND_POWER_RATIO;
    @Config(category="Power", key="Water_tubine_Ratio")
    public static int WATER_POWER_RATIO;
    @Config(category="Power", key="Solor_Panel")
    public static int SOLAR_ENERGY;
    @Config
    public static double fulminationOutputMultiplier;
    @Config
    public static double turbineOutputMultiplier;
    @Config
    public static double fissionBoilVolumeMultiplier;
    @Config
    public static boolean allowTurbineStacking;
    @Config
    public static boolean allowToxicWaste;
    @Config
    public static boolean allowRadioactiveOres;
    @Config
    public static boolean allowOreDictionaryCompatibility;
    @Config
    public static boolean allowAlternateRecipes;
    @Config
    public static boolean allowIC2UraniumCompression;
    @Config(comment="0 = Do not generate, 1 = Generate items only, 2 = Generate all")
    public static int quantumAssemblerGenerateMode;
    @Config
    public static int uraniumHexaflourideRatio;
    @Config
    public static int waterPerDeutermium;
    @Config
    public static int deutermiumPerTritium;
    @Config(comment="Put a list of block/item IDs to be used by the Quantum Assembler. Separate by commas, no space.")
    public static int[] quantumAssemblerRecipes;
    @Config
    public static double darkMatterSpawnChance;

    public static void load() {
        for (int recipeID : quantumAssemblerRecipes) {
            try {
                QuantumAssemblerRecipes.addRecipe((ItemStack)new ItemStack(recipeID, 1, 0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        PotionRadiation.INSTANCE.func_76396_c();
    }

    public static int getNextBlockID() {
        return idManager.getNextBlockID();
    }

    public static int getNextBlockID(String key) {
        int id = idManager.getNextBlockID();
        return CONFIGURATION.get("block", key, id).getInt(id);
    }

    public static int getNextItemID() {
        return idManager.getNextItemID();
    }

    public static int getNextItemID(String key) {
        int id = idManager.getNextItemID();
        return CONFIGURATION.get("item", key, id).getInt(id);
    }

    public static void setModMetadata(ModMetadata metadata, String id, String name) {
        Settings.setModMetadata(metadata, id, name, "");
    }

    public static void setModMetadata(ModMetadata metadata, String id, String name, String parent) {
        metadata.modId = id;
        metadata.name = name;
        metadata.description = LanguageUtility.getLocal((String)"meta.resonantinduction.description");
        metadata.url = "http://calclavia.com/resonant-induction";
        metadata.logoFile = "ri_logo.png";
        metadata.version = "0.3.1.259";
        metadata.authorList = Arrays.asList("Calclavia", "DarkCow", "Maxwolf Goodliffe");
        metadata.credits = LanguageUtility.getLocal((String)"meta.resonantinduction.credits");
        metadata.parent = parent;
        metadata.autogenerated = false;
    }

    public static boolean isOp(String username) {
        MinecraftServer theServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (theServer != null) {
            return theServer.func_71203_ab().func_72376_i().contains(username.trim().toLowerCase());
        }
        return false;
    }

    static {
        CONFIGURATION.load();
        idManager = new IDManager(CONFIGURATION.get("general", "BlockIDPrefix", 1200).getInt(1200), CONFIGURATION.get("general", "ItemIDPrefix", 20150).getInt(20150));
        CONFIGURATION.save();
        ALLOW_ENGINEERING_AUTOCRAFT = true;
        SOUND_FXS = true;
        SHINY_SILVER = true;
        MAX_LEVITATOR_DISTANCE = 200;
        LEVITATOR_MAX_REACH = 40;
        LEVITATOR_PUSH_DELAY = 5;
        LEVITATOR_MAX_SPEED = 0.2;
        LEVITATOR_ACCELERATION = 0.02;
        WIND_POWER_RATIO = 1;
        WATER_POWER_RATIO = 1;
        SOLAR_ENERGY = 50;
        fulminationOutputMultiplier = 1.0;
        turbineOutputMultiplier = 1.0;
        fissionBoilVolumeMultiplier = 1.0;
        allowTurbineStacking = true;
        allowToxicWaste = true;
        allowRadioactiveOres = true;
        allowOreDictionaryCompatibility = true;
        allowAlternateRecipes = true;
        allowIC2UraniumCompression = true;
        quantumAssemblerGenerateMode = 1;
        uraniumHexaflourideRatio = 200;
        waterPerDeutermium = 4;
        deutermiumPerTritium = 4;
        quantumAssemblerRecipes = new int[0];
        darkMatterSpawnChance = 0.2;
    }
}

