/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.grid.fluid;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataInput;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import resonant.lib.content.module.TileBase;
import resonant.lib.network.IPacketReceiverWithID;
import resonant.lib.network.PacketHandler;
import resonant.lib.utility.FluidUtility;
import resonantinduction.core.ResonantInduction;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public abstract class TileFluidNode
extends TileBase
implements IPacketReceiverWithID {
    protected int pressure;
    protected FluidTank tank;
    protected int colorID = 0;
    protected FluidStack prevStack = null;
    public static final int PACKET_DESCRIPTION = 0;
    public static final int PACKET_RENDER = 1;
    public static final int PACKET_TANK = 2;
    public byte renderSides = 0;
    protected boolean markTankUpdate;
    protected final int tankSize;

    public TileFluidNode(Material material, int tankSize) {
        super(material);
        this.tankSize = tankSize;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.markTankUpdate) {
            this.sendTankUpdate();
            this.markTankUpdate = false;
        }
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.colorID = nbt.func_74762_e("colorID");
        this.getInternalTank().readFromNBT(nbt.func_74775_l("FluidTank"));
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("colorID", this.colorID);
        nbt.func_74766_a("FluidTank", this.getInternalTank().writeToNBT(new NBTTagCompound()));
    }

    public boolean onReceivePacket(int id, ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            if (this.field_70331_k.field_72995_K) {
                if (id == 0) {
                    this.colorID = data.readInt();
                    this.renderSides = data.readByte();
                    this.tank = new FluidTank(data.readInt());
                    this.getInternalTank().readFromNBT(PacketHandler.readNBTTagCompound((DataInput)data));
                    return true;
                }
                if (id == 1) {
                    this.colorID = data.readInt();
                    this.renderSides = data.readByte();
                    this.markRender();
                    return true;
                }
                if (id == 2) {
                    this.tank = new FluidTank(data.readInt()).readFromNBT(PacketHandler.readNBTTagCompound((DataInput)data));
                    this.pressure = data.readInt();
                    this.updateLight();
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }

    public Packet func_70319_e() {
        if (this.getInternalTank().getFluid() == null || this.getInternalTank().getFluid() != null && this.getInternalTank().getFluid().getFluid().getName() != null) {
            return ResonantInduction.PACKET_TILE.getPacketWithID(0, (TileEntity)this, new Object[]{this.colorID, this.renderSides, this.getInternalTank().getCapacity(), this.getInternalTank().writeToNBT(new NBTTagCompound())});
        }
        return null;
    }

    public void sendRenderUpdate() {
        if (!this.field_70331_k.field_72995_K) {
            PacketHandler.sendPacketToClients((Packet)ResonantInduction.PACKET_TILE.getPacketWithID(1, (TileEntity)this, new Object[]{this.colorID, this.renderSides}));
        }
    }

    public void sendTankUpdate() {
        if (!this.field_70331_k.field_72995_K) {
            PacketHandler.sendPacketToClients((Packet)ResonantInduction.PACKET_TILE.getPacketWithID(2, (TileEntity)this, new Object[]{this.getInternalTank().getCapacity(), this.getInternalTank().writeToNBT(new NBTTagCompound()), this.pressure}), (World)this.field_70331_k, (IVector3)new Vector3((TileEntity)this), (double)60.0);
        }
    }

    public void onFluidChanged() {
        if (!this.field_70331_k.field_72995_K && !FluidUtility.matchExact((FluidStack)this.prevStack, (FluidStack)this.getInternalTank().getFluid())) {
            this.markTankUpdate = true;
            this.prevStack = this.tank.getFluid() != null ? this.tank.getFluid().copy() : null;
        }
    }

    public FluidTank getInternalTank() {
        if (this.tank == null) {
            this.tank = new FluidTank(this.tankSize);
        }
        return this.tank;
    }
}

