/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.grid.fluid;

import net.minecraft.block.material.Material;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import resonant.api.grid.INode;
import resonant.lib.network.IPacketReceiverWithID;
import resonantinduction.core.grid.fluid.FluidPressureNode;
import resonantinduction.core.grid.fluid.IPressureNodeProvider;
import resonantinduction.core.grid.fluid.TileFluidNode;

public abstract class TilePressureNode
extends TileFluidNode
implements IPressureNodeProvider,
IPacketReceiverWithID {
    protected FluidPressureNode node;

    public TilePressureNode(Material material) {
        super(material, 1000);
    }

    public void initiate() {
        super.initiate();
        this.node.reconstruct();
    }

    public void func_70313_j() {
        this.node.deconstruct();
        super.func_70313_j();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int fill = this.getInternalTank().fill(resource, doFill);
        this.onFluidChanged();
        return fill;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack drain = this.getInternalTank().drain(maxDrain, doDrain);
        this.onFluidChanged();
        return drain;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getInternalTank().getInfo()};
    }

    public int getSubID() {
        return this.colorID;
    }

    public void setSubID(int id) {
        this.colorID = id;
    }

    @Override
    public FluidTank getInternalTank() {
        if (this.tank == null) {
            this.tank = new FluidTank(1000);
        }
        return this.tank;
    }

    @Override
    public FluidTank getPressureTank() {
        return this.getInternalTank();
    }

    public INode getNode(Class<? extends INode> nodeType, ForgeDirection from) {
        if (nodeType.isAssignableFrom(((Object)((Object)this.node)).getClass())) {
            return this.node;
        }
        return null;
    }
}

