/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.prefab.imprint;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import resonant.lib.utility.LanguageUtility;
import resonant.lib.utility.nbt.NBTUtility;
import resonantinduction.core.Settings;
import resonantinduction.core.TabRI;

public class ItemImprint
extends Item {
    public ItemImprint(int id) {
        super(Settings.CONFIGURATION.getItem("imprint", id).getInt());
        this.func_77655_b("resonantinduction:imprint");
        this.func_111206_d("resonantinduction:imprint");
        this.func_77637_a(TabRI.DEFAULT);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity != null && !(entity instanceof IProjectile) && !(entity instanceof EntityPlayer)) {
            String stringName = EntityList.func_75621_b((Entity)entity);
            return true;
        }
        return false;
    }

    public boolean itemInteractionForEntity(ItemStack par1ItemStack, EntityLivingBase par2EntityLiving) {
        return false;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        HashSet<ItemStack> filterItems = ItemImprint.getFilters(itemStack);
        if (filterItems.size() > 0) {
            for (ItemStack filterItem : filterItems) {
                list.add(filterItem.func_82833_r());
            }
        } else {
            list.add(LanguageUtility.getLocal((String)"tooltip.noImprint"));
        }
    }

    public static void setFilters(ItemStack itemStack, Set<ItemStack> filterStacks) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList nbt = new NBTTagList();
        for (ItemStack filterStack : filterStacks) {
            NBTTagCompound newCompound = new NBTTagCompound();
            filterStack.func_77955_b(newCompound);
            nbt.func_74742_a((NBTBase)newCompound);
        }
        itemStack.func_77978_p().func_74782_a("Items", (NBTBase)nbt);
    }

    public static boolean isFiltering(ItemStack filter, ItemStack itemStack) {
        HashSet<ItemStack> checkStacks;
        if (filter != null && itemStack != null && (checkStacks = ItemImprint.getFilters(filter)) != null) {
            for (ItemStack stack : checkStacks) {
                if (!stack.func_77969_a(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static HashSet<ItemStack> getFilters(ItemStack itemStack) {
        HashSet<ItemStack> filterStacks = new HashSet<ItemStack>();
        NBTTagCompound nbt = NBTUtility.getNBTTagCompound((ItemStack)itemStack);
        NBTTagList tagList = nbt.func_74761_m("Items");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound var4 = (NBTTagCompound)tagList.func_74743_b(i);
            filterStacks.add(ItemStack.func_77949_a((NBTTagCompound)var4));
        }
        return filterStacks;
    }

    public static List<ItemStack> getFilterList(ItemStack itemStack) {
        ArrayList<ItemStack> filterStacks = new ArrayList<ItemStack>();
        NBTTagCompound nbt = NBTUtility.getNBTTagCompound((ItemStack)itemStack);
        NBTTagList tagList = nbt.func_74761_m("Items");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound var4 = (NBTTagCompound)tagList.func_74743_b(i);
            filterStacks.add(ItemStack.func_77949_a((NBTTagCompound)var4));
        }
        return filterStacks;
    }
}

