/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.prefab.part;

import codechicken.multipart.IRedstonePart;
import codechicken.multipart.TMultiPart;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public abstract class PartAdvanced
extends TMultiPart {
    protected long ticks = 0L;

    public void update() {
        if (this.ticks == 0L) {
            this.initiate();
        }
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 1L;
        }
        ++this.ticks;
    }

    public void initiate() {
    }

    public World getWorld() {
        return this.world();
    }

    protected abstract ItemStack getItem();

    public Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(this.getItem());
        return drops;
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItem();
    }

    protected boolean checkRedstone(int side) {
        if (this.world().func_72864_z(this.x(), this.y(), this.z())) {
            return true;
        }
        for (TMultiPart tp : this.tile().jPartList()) {
            IRedstonePart rp;
            if (!(tp instanceof IRedstonePart) || Math.max((rp = (IRedstonePart)tp).strongPowerLevel(side), rp.weakPowerLevel(side)) << 4 <= 0) continue;
            return true;
        }
        return false;
    }
}

