/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.prefab.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.FaceMicroClass;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TMultiPart;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.ForgeDirection;

public abstract class PartFace
extends JCuboidPart
implements JNormalOcclusion,
TFacePart {
    public static Cuboid6[][] bounds = new Cuboid6[6][2];
    public ForgeDirection placementSide;
    public byte facing = 0;
    protected int ticks;

    public void preparePlacement(int side, int facing) {
        this.placementSide = ForgeDirection.getOrientation((int)side);
        this.facing = (byte)(facing - 2);
    }

    public void initiate() {
    }

    public void update() {
        super.update();
        if (this.ticks++ == 0) {
            this.initiate();
        }
    }

    public void readDesc(MCDataInput packet) {
        this.placementSide = ForgeDirection.getOrientation((int)packet.readByte());
        this.facing = packet.readByte();
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte(this.placementSide.ordinal());
        packet.writeByte((int)this.facing);
    }

    public int getSlotMask() {
        return 1 << this.placementSide.ordinal();
    }

    public Cuboid6 getBounds() {
        return FaceMicroClass.aBounds()[0x10 | this.placementSide.ordinal()];
    }

    public int redstoneConductionMap() {
        return 0;
    }

    public boolean solid(int arg0) {
        return true;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(bounds[this.placementSide.ordinal()]);
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(this.getItem());
        return drops;
    }

    protected abstract ItemStack getItem();

    public ItemStack pickItem(MovingObjectPosition hit) {
        return this.getItem();
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.placementSide = ForgeDirection.getOrientation((int)nbt.func_74771_c("side"));
        this.facing = nbt.func_74771_c("facing");
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74774_a("side", (byte)this.placementSide.ordinal());
        nbt.func_74774_a("facing", this.facing);
    }

    public ForgeDirection getFacing() {
        return ForgeDirection.getOrientation((int)(this.facing + 2));
    }

    public ForgeDirection getAbsoluteFacing() {
        int s = 0;
        switch (this.facing) {
            case 0: {
                s = 2;
                break;
            }
            case 1: {
                s = 0;
                break;
            }
            case 2: {
                s = 1;
                break;
            }
            case 3: {
                s = 3;
            }
        }
        int absDir = Rotation.rotateSide((int)this.placementSide.ordinal(), (int)s);
        return ForgeDirection.getOrientation((int)absDir);
    }

    static {
        PartFace.bounds[0][0] = new Cuboid6(0.125, 0.0, 0.0, 0.875, 0.125, 1.0);
        PartFace.bounds[0][1] = new Cuboid6(0.0, 0.0, 0.125, 1.0, 0.125, 0.875);
        for (int s = 1; s < 6; ++s) {
            Transformation t = Rotation.sideRotations[s].at(Vector3.center);
            PartFace.bounds[s][0] = bounds[0][0].copy().apply(t);
            PartFace.bounds[s][1] = bounds[0][1].copy().apply(t);
        }
    }
}

