/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.prefab.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.microblock.IHollowConnect;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.PartMap;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonantinduction.core.prefab.part.PartColorableMaterial;
import universalelectricity.api.net.IConnector;
import universalelectricity.api.net.INetwork;
import universalelectricity.api.net.INodeNetwork;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorHelper;

public abstract class PartFramedConnection<M extends Enum, C extends IConnector<N>, N extends INodeNetwork>
extends PartColorableMaterial<M>
implements IConnector<N>,
TSlottedPart,
JNormalOcclusion,
IHollowConnect {
    public static IndexedCuboid6[] sides = new IndexedCuboid6[7];
    public static IndexedCuboid6[] insulatedSides = new IndexedCuboid6[7];
    protected Object[] connections = new Object[6];
    protected N network;
    public byte currentWireConnections = 0;
    public byte currentAcceptorConnections = 0;
    private ForgeDirection testingSide;
    @SideOnly(value=Side.CLIENT)
    protected Icon breakIcon;

    public PartFramedConnection(Item insulationType) {
        super(insulationType);
    }

    public void preparePlacement(int meta) {
        this.setMaterial(meta);
    }

    public boolean occlusionTest(TMultiPart other) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)other);
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        IndexedCuboid6[] currentSides;
        HashSet<IndexedCuboid6> subParts = new HashSet<IndexedCuboid6>();
        IndexedCuboid6[] indexedCuboid6Array = currentSides = this.isInsulated() ? insulatedSides : sides;
        if (this.tile() != null) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                int ord = side.ordinal();
                if (!PartFramedConnection.connectionMapContainsSide(this.getAllCurrentConnections(), side) && side != this.testingSide) continue;
                subParts.add(currentSides[ord]);
            }
        }
        subParts.add(currentSides[6]);
        return subParts;
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        HashSet<Cuboid6> collisionBoxes = new HashSet<Cuboid6>();
        collisionBoxes.addAll((Collection)this.getSubParts());
        return collisionBoxes;
    }

    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return 10.0f;
    }

    public void drawBreaking(RenderBlocks renderBlocks) {
        if (this.breakIcon != null) {
            CCRenderState.reset();
            RenderUtils.renderBlock((Cuboid6)sides[6], (int)0, (Transformation)new Translation((double)this.x(), (double)this.y(), (double)this.z()), (IUVTransformation)new IconTransformation(this.breakIcon), null);
        }
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return this.getCollisionBoxes();
    }

    public int getSlotMask() {
        return PartMap.CENTER.mask;
    }

    public int getHollowSize() {
        return this.isInsulated ? 8 : 6;
    }

    public boolean isBlockedOnSide(ForgeDirection side) {
        TMultiPart blocker = this.tile().partMap(side.ordinal());
        this.testingSide = side;
        boolean expandable = NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)blocker);
        this.testingSide = null;
        return !expandable;
    }

    public byte getAllCurrentConnections() {
        return (byte)(this.currentWireConnections | this.currentAcceptorConnections);
    }

    public static boolean connectionMapContainsSide(byte connections, ForgeDirection side) {
        byte tester = (byte)(1 << side.ordinal());
        return (connections & tester) > 0;
    }

    public void bind(TileMultipart t) {
        if (this.getNetwork() != null) {
            ((INodeNetwork)this.getNetwork()).getConnectors().remove((Object)this);
            super.bind(t);
            ((INodeNetwork)this.getNetwork()).getConnectors().add(this);
        } else {
            super.bind(t);
        }
    }

    protected abstract boolean canConnectTo(TileEntity var1, ForgeDirection var2);

    protected abstract C getConnector(TileEntity var1);

    public boolean canConnectBothSides(TileEntity tile, ForgeDirection side) {
        boolean notPrevented;
        boolean bl = notPrevented = !this.isConnectionPrevented(tile, side);
        if (this.getConnector(tile) != null) {
            notPrevented &= this.getConnector(tile).canConnect(side.getOpposite(), (Object)this);
        }
        return notPrevented;
    }

    public boolean isConnectionPrevented(TileEntity tile, ForgeDirection side) {
        return !this.canConnectTo(tile, side) || this.isBlockedOnSide(side);
    }

    public byte getPossibleWireConnections() {
        byte connections = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = VectorHelper.getTileEntityFromSide((World)this.world(), (Vector3)new Vector3((TileEntity)this.tile()), (ForgeDirection)side);
            if (this.getConnector(tileEntity) == null || !this.canConnectBothSides(tileEntity, side)) continue;
            connections = (byte)(connections | 1 << side.ordinal());
        }
        return connections;
    }

    public byte getPossibleAcceptorConnections() {
        byte connections = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = VectorHelper.getTileEntityFromSide((World)this.world(), (Vector3)new Vector3((TileEntity)this.tile()), (ForgeDirection)side);
            if (!this.canConnectTo(tileEntity, side) || !this.canConnectBothSides(tileEntity, side)) continue;
            connections = (byte)(connections | 1 << side.ordinal());
        }
        return connections;
    }

    public void refresh() {
        if (!this.world().field_72995_K) {
            byte possibleWireConnections = this.getPossibleWireConnections();
            byte possibleAcceptorConnections = this.getPossibleAcceptorConnections();
            if (possibleWireConnections != this.currentWireConnections) {
                byte or = (byte)(possibleWireConnections | this.currentWireConnections);
                if (or != possibleWireConnections) {
                    ((INodeNetwork)this.getNetwork()).removeConnector((IConnector)this);
                    ((INodeNetwork)this.getNetwork()).split((IConnector)this);
                    this.setNetwork((N)null);
                }
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tileEntity;
                    if (!PartFramedConnection.connectionMapContainsSide(possibleWireConnections, side) || this.getConnector(tileEntity = VectorHelper.getConnectorFromSide((World)this.world(), (Vector3)new Vector3((TileEntity)this.tile()), (ForgeDirection)side, (Object)((Object)this))) == null) continue;
                    ((INodeNetwork)this.getNetwork()).merge((INetwork)this.getConnector(tileEntity).getNetwork());
                }
                this.currentWireConnections = possibleWireConnections;
            }
            this.currentAcceptorConnections = possibleAcceptorConnections;
            ((INodeNetwork)this.getNetwork()).reconstruct();
            this.sendConnectionUpdate();
        }
        this.tile().markRender();
    }

    public TileEntity[] getConnections() {
        TileEntity[] connections = new TileEntity[6];
        if (this.world() != null) {
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                ForgeDirection side = ForgeDirection.getOrientation((int)i);
                TileEntity tileEntity = VectorHelper.getTileEntityFromSide((World)this.world(), (Vector3)new Vector3((TileEntity)this.tile()), (ForgeDirection)side);
                if (!this.isCurrentlyConnected(side)) continue;
                connections[i] = tileEntity;
            }
        }
        return connections;
    }

    public boolean isCurrentlyConnected(ForgeDirection side) {
        return PartFramedConnection.connectionMapContainsSide(this.getAllCurrentConnections(), side);
    }

    public boolean canConnect(ForgeDirection direction, Object source) {
        Vector3 connectPos = new Vector3((TileEntity)this.tile()).translate(direction);
        TileEntity connectTile = connectPos.getTileEntity((IBlockAccess)this.world());
        return !this.isConnectionPrevented(connectTile, direction);
    }

    public void onAdded() {
        super.onAdded();
        this.refresh();
    }

    public void onWorldJoin() {
        this.refresh();
    }

    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.refresh();
    }

    public void onPartChanged(TMultiPart part) {
        this.refresh();
    }

    public void copyFrom(PartFramedConnection<M, C, N> other) {
        this.isInsulated = other.isInsulated;
        this.color = other.color;
        this.connections = other.connections;
        this.material = other.material;
        this.currentWireConnections = other.currentWireConnections;
        this.currentAcceptorConnections = other.currentAcceptorConnections;
        this.setNetwork((N)((INodeNetwork)other.getNetwork()));
    }

    public void sendConnectionUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(0).writeByte((int)this.currentWireConnections).writeByte((int)this.currentAcceptorConnections);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.currentWireConnections = packet.readByte();
        this.currentAcceptorConnections = packet.readByte();
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.currentWireConnections);
        packet.writeByte((int)this.currentAcceptorConnections);
    }

    public void read(MCDataInput packet) {
        this.read(packet, packet.readUByte());
    }

    @Override
    public void read(MCDataInput packet, int packetID) {
        if (packetID == 0) {
            this.currentWireConnections = packet.readByte();
            this.currentAcceptorConnections = packet.readByte();
            this.tile().markRender();
        } else {
            super.read(packet, packetID);
        }
    }

    public void setNetwork(N network) {
        this.network = network;
    }

    public IConnector<N> getInstance(ForgeDirection dir) {
        return this;
    }

    public String toString() {
        return "[PartFramedConnection]" + this.x() + "x " + this.y() + "y " + this.z() + "z " + this.getSlotMask() + "s ";
    }

    static {
        PartFramedConnection.sides[0] = new IndexedCuboid6((Object)0, new Cuboid6(0.36, 0.0, 0.36, 0.64, 0.36, 0.64));
        PartFramedConnection.sides[1] = new IndexedCuboid6((Object)1, new Cuboid6(0.36, 0.64, 0.36, 0.64, 1.0, 0.64));
        PartFramedConnection.sides[2] = new IndexedCuboid6((Object)2, new Cuboid6(0.36, 0.36, 0.0, 0.64, 0.64, 0.36));
        PartFramedConnection.sides[3] = new IndexedCuboid6((Object)3, new Cuboid6(0.36, 0.36, 0.64, 0.64, 0.64, 1.0));
        PartFramedConnection.sides[4] = new IndexedCuboid6((Object)4, new Cuboid6(0.0, 0.36, 0.36, 0.36, 0.64, 0.64));
        PartFramedConnection.sides[5] = new IndexedCuboid6((Object)5, new Cuboid6(0.64, 0.36, 0.36, 1.0, 0.64, 0.64));
        PartFramedConnection.sides[6] = new IndexedCuboid6((Object)6, new Cuboid6(0.36, 0.36, 0.36, 0.64, 0.64, 0.64));
        PartFramedConnection.insulatedSides[0] = new IndexedCuboid6((Object)0, new Cuboid6(0.3, 0.0, 0.3, 0.7, 0.3, 0.7));
        PartFramedConnection.insulatedSides[1] = new IndexedCuboid6((Object)1, new Cuboid6(0.3, 0.7, 0.3, 0.7, 1.0, 0.7));
        PartFramedConnection.insulatedSides[2] = new IndexedCuboid6((Object)2, new Cuboid6(0.3, 0.3, 0.0, 0.7, 0.7, 0.3));
        PartFramedConnection.insulatedSides[3] = new IndexedCuboid6((Object)3, new Cuboid6(0.3, 0.3, 0.7, 0.7, 0.7, 1.0));
        PartFramedConnection.insulatedSides[4] = new IndexedCuboid6((Object)4, new Cuboid6(0.0, 0.3, 0.3, 0.3, 0.7, 0.7));
        PartFramedConnection.insulatedSides[5] = new IndexedCuboid6((Object)5, new Cuboid6(0.7, 0.3, 0.3, 1.0, 0.7, 0.7));
        PartFramedConnection.insulatedSides[6] = new IndexedCuboid6((Object)6, new Cuboid6(0.3, 0.3, 0.3, 0.7, 0.7, 0.7));
    }
}

