/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.resource;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import resonant.lib.utility.LanguageUtility;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.TabRI;
import resonantinduction.core.resource.ResourceGenerator;
import resonantinduction.core.resource.TileMaterial;

public class ItemOreResource
extends Item {
    private int blockID;

    public ItemOreResource(int id, String name) {
        super(id);
        this.blockID = ResonantInduction.blockRefinedDust.field_71990_ca;
        this.func_77655_b("resonantinduction:" + name);
        this.func_111206_d("resonantinduction:" + name);
        this.func_77637_a(TabRI.CORE);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public static String getMaterialFromStack(ItemStack itemStack) {
        return ResourceGenerator.getName(itemStack.func_77960_j());
    }

    public String func_77628_j(ItemStack is) {
        ArrayList list;
        String material = ItemOreResource.getMaterialFromStack(is);
        if (material != null && (list = OreDictionary.getOres((String)("ingot" + material.substring(0, 1).toUpperCase() + material.substring(1)))).size() > 0) {
            ItemStack type = (ItemStack)list.get(0);
            String name = type.func_82833_r().replace(LanguageUtility.getLocal((String)"misc.resonantinduction.ingot"), "").replaceAll("^ ", "").replaceAll(" $", "");
            return LanguageUtility.getLocal((String)(this.func_77658_a() + ".name")).replace("%v", name).replace("  ", " ");
        }
        return "";
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (itemStack.func_77973_b() == ResonantInduction.itemDust || itemStack.func_77973_b() == ResonantInduction.itemRefinedDust) {
            int k1;
            int j1;
            Block block;
            int n = this.blockID = itemStack.func_77973_b() == ResonantInduction.itemRefinedDust ? ResonantInduction.blockRefinedDust.field_71990_ca : ResonantInduction.blockDust.field_71990_ca;
            if (itemStack.field_77994_a == 0) {
                return false;
            }
            if (!player.func_82247_a(x, y, z, side, itemStack)) {
                return false;
            }
            TileEntity tile = world.func_72796_p(x, y, z);
            if (world.func_72798_a(x, y, z) == this.blockID && tile instanceof TileMaterial && ItemOreResource.getMaterialFromStack(itemStack).equals(((TileMaterial)tile).name)) {
                block = Block.field_71973_m[this.blockID];
                j1 = world.func_72805_g(x, y, z);
                k1 = j1 & 7;
                if (k1 <= 6 && world.func_72855_b(block.func_71872_e(world, x, y, z)) && world.func_72921_c(x, y, z, k1 + 1 | j1 & 0xFFFFFFF8, 2)) {
                    world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.field_72020_cn.func_82593_b(), (block.field_72020_cn.func_72677_b() + 1.0f) / 2.0f, block.field_72020_cn.func_72678_c() * 0.8f);
                    --itemStack.field_77994_a;
                    return true;
                }
            }
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
            if (world.func_72931_a(this.blockID, x, y, z, false, side, (Entity)player, itemStack)) {
                block = Block.field_71973_m[this.blockID];
                j1 = this.func_77647_b(itemStack.func_77960_j());
                k1 = Block.field_71973_m[this.blockID].func_85104_a(world, x, y, z, side, hitX, hitY, hitZ, j1);
                if (this.placeBlockAt(itemStack, player, world, x, y, z, side, hitX, hitY, hitZ, k1)) {
                    world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.field_72020_cn.func_82593_b(), (block.field_72020_cn.func_72677_b() + 1.0f) / 2.0f, block.field_72020_cn.func_72678_c() * 0.8f);
                    --itemStack.field_77994_a;
                }
                return true;
            }
        }
        return false;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        int n = this.blockID = stack.func_77973_b() == ResonantInduction.itemRefinedDust ? ResonantInduction.blockRefinedDust.field_71990_ca : ResonantInduction.blockDust.field_71990_ca;
        if (!world.func_72832_d(x, y, z, this.blockID, metadata, 3)) {
            return false;
        }
        if (world.func_72798_a(x, y, z) == this.blockID) {
            Block.field_71973_m[this.blockID].func_71860_a(world, x, y, z, (EntityLivingBase)player, stack);
            Block.field_71973_m[this.blockID].func_85105_g(world, x, y, z, metadata);
        }
        return true;
    }

    public ItemStack getStackFromMaterial(String name) {
        ItemStack itemStack = new ItemStack((Item)this);
        itemStack.func_77964_b(ResourceGenerator.getID(name));
        return itemStack;
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (String materialName : ResourceGenerator.materials.keySet()) {
            par3List.add(this.getStackFromMaterial(materialName));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int par2) {
        String name = ItemOreResource.getMaterialFromStack(itemStack);
        if (ResourceGenerator.materialColorCache.containsKey(name)) {
            return ResourceGenerator.materialColorCache.get(name);
        }
        return 0xFFFFFF;
    }
}

