/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.core.resource.fluid;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.FluidRegistry;
import resonant.lib.utility.LanguageUtility;
import resonantinduction.core.TabRI;
import resonantinduction.core.resource.ItemOreResource;
import resonantinduction.core.resource.ResourceGenerator;

public class ItemOreResourceBucket
extends Item {
    final boolean isMolten;

    public ItemOreResourceBucket(int id, String name, boolean isMolten) {
        super(id);
        this.isMolten = isMolten;
        this.func_77625_d(1);
        this.func_77655_b("resonantinduction:" + name);
        this.func_111206_d("resonantinduction:" + name);
        this.func_77637_a(TabRI.CORE);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public String func_77628_j(ItemStack is) {
        String material = ItemOreResourceBucket.getMaterialFromStack(is);
        if (material != null) {
            String fluidID;
            String string = fluidID = this.isMolten ? ResourceGenerator.materialNameToMolten(material) : ResourceGenerator.materialNameToMixture(material);
            if (fluidID != null && FluidRegistry.getFluid((String)fluidID) != null) {
                String fluidName = FluidRegistry.getFluid((String)fluidID).getLocalizedName();
                return LanguageUtility.getLocal((String)(this.func_77658_a() + ".name")).replace("%v", fluidName).replace("  ", " ");
            }
            return material;
        }
        return null;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        String materialName = ResourceGenerator.getName(itemStack.func_77960_j());
        if (materialName != null) {
            int fluidID;
            BlockFluidFinite molten_block = ResourceGenerator.getMolten(materialName);
            BlockFluidFinite mix_block = ResourceGenerator.getMixture(materialName);
            int n = this.isMolten ? (molten_block != null ? molten_block.field_71990_ca : 0) : (fluidID = mix_block != null ? mix_block.field_71990_ca : 0);
            if (fluidID > 0) {
                MovingObjectPosition movingobjectposition = this.func_77621_a(world, entityPlayer, false);
                if (movingobjectposition == null) {
                    return itemStack;
                }
                FillBucketEvent event = new FillBucketEvent(entityPlayer, itemStack, world, movingobjectposition);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return itemStack;
                }
                if (event.getResult() == Event.Result.ALLOW) {
                    if (entityPlayer.field_71075_bZ.field_75098_d) {
                        return itemStack;
                    }
                    if (--itemStack.field_77994_a <= 0) {
                        return event.result;
                    }
                    if (!entityPlayer.field_71071_by.func_70441_a(event.result)) {
                        entityPlayer.func_71021_b(event.result);
                    }
                    return itemStack;
                }
                if (movingobjectposition.field_72313_a == EnumMovingObjectType.TILE) {
                    int i = movingobjectposition.field_72311_b;
                    int j = movingobjectposition.field_72312_c;
                    int k = movingobjectposition.field_72309_d;
                    if (!world.func_72962_a(entityPlayer, i, j, k)) {
                        return itemStack;
                    }
                    if (fluidID == 0) {
                        if (!entityPlayer.func_82247_a(i, j, k, movingobjectposition.field_72310_e, itemStack)) {
                            return itemStack;
                        }
                        if (world.func_72803_f(i, j, k) == Material.field_76244_g && world.func_72805_g(i, j, k) == 0) {
                            world.func_94571_i(i, j, k);
                            if (entityPlayer.field_71075_bZ.field_75098_d) {
                                return itemStack;
                            }
                            if (--itemStack.field_77994_a <= 0) {
                                return new ItemStack(Item.field_77786_ax);
                            }
                            if (!entityPlayer.field_71071_by.func_70441_a(new ItemStack(Item.field_77786_ax))) {
                                entityPlayer.func_71021_b(new ItemStack(Item.field_77786_ax.field_77779_bT, 1, 0));
                            }
                            return itemStack;
                        }
                        if (world.func_72803_f(i, j, k) == Material.field_76256_h && world.func_72805_g(i, j, k) == 0) {
                            world.func_94571_i(i, j, k);
                            if (entityPlayer.field_71075_bZ.field_75098_d) {
                                return itemStack;
                            }
                            if (--itemStack.field_77994_a <= 0) {
                                return new ItemStack(Item.field_77775_ay);
                            }
                            if (!entityPlayer.field_71071_by.func_70441_a(new ItemStack(Item.field_77775_ay))) {
                                entityPlayer.func_71021_b(new ItemStack(Item.field_77775_ay.field_77779_bT, 1, 0));
                            }
                            return itemStack;
                        }
                    } else {
                        if (fluidID < 0) {
                            return new ItemStack(Item.field_77788_aw);
                        }
                        if (movingobjectposition.field_72310_e == 0) {
                            --j;
                        }
                        if (movingobjectposition.field_72310_e == 1) {
                            ++j;
                        }
                        if (movingobjectposition.field_72310_e == 2) {
                            --k;
                        }
                        if (movingobjectposition.field_72310_e == 3) {
                            ++k;
                        }
                        if (movingobjectposition.field_72310_e == 4) {
                            --i;
                        }
                        if (movingobjectposition.field_72310_e == 5) {
                            ++i;
                        }
                        if (!entityPlayer.func_82247_a(i, j, k, movingobjectposition.field_72310_e, itemStack)) {
                            return itemStack;
                        }
                        if (this.tryPlaceContainedLiquid(world, i, j, k, fluidID) && !entityPlayer.field_71075_bZ.field_75098_d) {
                            return new ItemStack(Item.field_77788_aw);
                        }
                    }
                }
            }
        }
        return itemStack;
    }

    public boolean tryPlaceContainedLiquid(World world, int x, int y, int z, int fluidID) {
        boolean flag;
        if (fluidID <= 0) {
            return false;
        }
        Material material = world.func_72803_f(x, y, z);
        boolean bl = flag = !material.func_76220_a();
        if (!world.func_72799_c(x, y, z) && !flag) {
            return false;
        }
        if (!world.field_72995_K && flag && !material.func_76224_d()) {
            world.func_94578_a(x, y, z, true);
        }
        world.func_72832_d(x, y, z, fluidID, 8, 3);
        return true;
    }

    public ItemStack getStackFromMaterial(String name) {
        ItemStack itemStack = new ItemStack((Item)this);
        itemStack.func_77964_b(ResourceGenerator.getID(name));
        return itemStack;
    }

    public static String getMaterialFromStack(ItemStack itemStack) {
        return ResourceGenerator.getName(itemStack.func_77960_j());
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (String materialName : ResourceGenerator.materials.keySet()) {
            par3List.add(this.getStackFromMaterial(materialName));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int par2) {
        String name = ItemOreResource.getMaterialFromStack(itemStack);
        return ResourceGenerator.getColor(name);
    }
}

