/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission;

public class ElectricityDisplay {
    public static String getDisplay(float value, ElectricUnit unit, int decimalPlaces, boolean isShort) {
        return ElectricityDisplay.getDisplay(value, unit, decimalPlaces, isShort, 1000.0f);
    }

    public static String getDisplay(float value, ElectricUnit unit, int decimalPlaces, boolean isShort, float multiplier) {
        String unitName = unit.name;
        String prefix = "";
        if (value < 0.0f) {
            value = Math.abs(value);
            prefix = "-";
        }
        value *= multiplier;
        if (isShort) {
            unitName = unit.symbol;
        } else if (value > 1.0f) {
            unitName = unit.getPlural();
        }
        if (value == 0.0f) {
            return value + " " + unitName;
        }
        for (int i = 0; i < MeasurementUnit.values().length; ++i) {
            MeasurementUnit lowerMeasure = MeasurementUnit.values()[i];
            if (lowerMeasure.isBellow(value) && lowerMeasure.ordinal() == 0) {
                return prefix + ElectricityDisplay.roundDecimals(lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.getName(isShort) + unitName;
            }
            if (lowerMeasure.ordinal() + 1 >= MeasurementUnit.values().length) {
                return prefix + ElectricityDisplay.roundDecimals(lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.getName(isShort) + unitName;
            }
            MeasurementUnit upperMeasure = MeasurementUnit.values()[i + 1];
            if ((!lowerMeasure.isAbove(value) || !upperMeasure.isBellow(value)) && lowerMeasure.value != value) continue;
            return prefix + ElectricityDisplay.roundDecimals(lowerMeasure.process(value), decimalPlaces) + " " + lowerMeasure.getName(isShort) + unitName;
        }
        return prefix + ElectricityDisplay.roundDecimals(value, decimalPlaces) + " " + unitName;
    }

    public static String getDisplay(float value, ElectricUnit unit) {
        return ElectricityDisplay.getDisplay(value, unit, 2, false);
    }

    public static String getDisplayShort(float value, ElectricUnit unit) {
        return ElectricityDisplay.getDisplay(value, unit, 2, true);
    }

    public static String getDisplayShort(float value, ElectricUnit unit, int decimalPlaces) {
        return ElectricityDisplay.getDisplay(value, unit, decimalPlaces, true);
    }

    public static String getDisplaySimple(float value, ElectricUnit unit, int decimalPlaces) {
        if (value > 1.0f) {
            if (decimalPlaces < 1) {
                return (int)value + " " + unit.getPlural();
            }
            return ElectricityDisplay.roundDecimals(value, decimalPlaces) + " " + unit.getPlural();
        }
        if (decimalPlaces < 1) {
            return (int)value + " " + unit.name;
        }
        return ElectricityDisplay.roundDecimals(value, decimalPlaces) + " " + unit.name;
    }

    public static double roundDecimals(double d, int decimalPlaces) {
        int j = (int)(d * Math.pow(10.0, decimalPlaces));
        return (double)j / Math.pow(10.0, decimalPlaces);
    }

    public static double roundDecimals(double d) {
        return ElectricityDisplay.roundDecimals(d, 2);
    }

    public static enum MeasurementUnit {
        MICRO("Micro", "u", 1.0E-6f),
        MILLI("Milli", "m", 0.001f),
        BASE("", "", 1.0f),
        KILO("Kilo", "k", 1000.0f),
        MEGA("Mega", "M", 1000000.0f),
        GIGA("Giga", "G", 1.0E9f),
        TERA("Tera", "T", 1.0E12f),
        PETA("Peta", "P", 1.0E15f),
        EXA("Exa", "E", 1.0E18f),
        ZETTA("Zetta", "Z", 1.0E21f),
        YOTTA("Yotta", "Y", 1.0E24f);

        public String name;
        public String symbol;
        public float value;

        private MeasurementUnit(String name, String symbol, float value) {
            this.name = name;
            this.symbol = symbol;
            this.value = value;
        }

        public String getName(boolean getShort) {
            if (getShort) {
                return this.symbol;
            }
            return this.name;
        }

        public double process(double value) {
            return value / (double)this.value;
        }

        public boolean isAbove(float value) {
            return value > this.value;
        }

        public boolean isBellow(float value) {
            return value < this.value;
        }
    }

    public static enum ElectricUnit {
        AMPERE("Amp", "I"),
        AMP_HOUR("Amp Hour", "Ah"),
        VOLTAGE("Volt", "V"),
        WATT("Watt", "W"),
        WATT_HOUR("Watt Hour", "Wh"),
        RESISTANCE("Ohm", "R"),
        CONDUCTANCE("Siemen", "S"),
        JOULES("Joule", "J");

        public String name;
        public String symbol;

        private ElectricUnit(String name, String symbol) {
            this.name = name;
            this.symbol = symbol;
        }

        public String getPlural() {
            return this.name + "s";
        }
    }
}

