/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission.compatibility;

import cpw.mods.fml.common.Loader;
import java.io.File;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import net.minecraftforge.common.Configuration;

public class NetworkConfigHandler {
    private static Configuration config;
    public static float BC3_RATIO;
    public static float TE_RATIO;
    public static float IC2_RATIO;
    public static float MEKANISM_RATIO;
    public static float TO_BC_RATIO;
    public static float TO_TE_RATIO;
    public static float TO_IC2_RATIO;
    public static float TO_MEKANISM_RATIO;
    public static boolean ALLOW_UNSAFE_IC2;
    public static Object gasOxygen;
    private static Boolean mekanismOldClassFound;

    public static void setDefaultValues(File file) {
        if (config == null) {
            config = new Configuration(file);
        }
        config.load();
        IC2_RATIO = (float)config.get("Compatiblity", "IndustrialCraft Conversion Ratio", (double)IC2_RATIO).getDouble((double)IC2_RATIO);
        TE_RATIO = (float)config.get("Compatiblity", "Thermal Expansion Conversion Ratio", (double)TE_RATIO).getDouble((double)TE_RATIO);
        BC3_RATIO = (float)config.get("Compatiblity", "BuildCraft Conversion Ratio", (double)BC3_RATIO).getDouble((double)BC3_RATIO);
        MEKANISM_RATIO = (float)config.get("Compatiblity", "Mekanism Conversion Ratio", (double)MEKANISM_RATIO).getDouble((double)MEKANISM_RATIO);
        ALLOW_UNSAFE_IC2 = config.get("Compatiblity", "IC2 machines can be given more than a safe amount of energy from aluminium wire? [caution: if true, they may explode]", false).getBoolean(false);
        TO_IC2_RATIO = 1.0f / IC2_RATIO;
        TO_BC_RATIO = 1.0f / BC3_RATIO;
        TO_TE_RATIO = 1.0f / TE_RATIO;
        TO_MEKANISM_RATIO = 1.0f / MEKANISM_RATIO;
        config.save();
    }

    public static void initGas() {
        if (NetworkConfigHandler.isMekanismLoaded()) {
            Gas oxygen = GasRegistry.getGas((String)"oxygen");
            gasOxygen = oxygen == null ? GasRegistry.register((Gas)new Gas("oxygen")).registerFluid() : oxygen;
        }
    }

    public static boolean isIndustrialCraft2Loaded() {
        return Loader.isModLoaded((String)"IC2");
    }

    public static boolean isBuildcraftLoaded() {
        return Loader.isModLoaded((String)"BuildCraft|Energy");
    }

    public static boolean isThermalExpansionLoaded() {
        return Loader.isModLoaded((String)"ThermalExpansion");
    }

    public static boolean isMekanismLoaded() {
        return Loader.isModLoaded((String)"Mekanism");
    }

    public static boolean isMekanismV6Loaded() {
        if (!NetworkConfigHandler.isMekanismLoaded()) {
            return false;
        }
        if (mekanismOldClassFound != null) {
            return mekanismOldClassFound == false;
        }
        try {
            Class.forName("mekanism.api.gas.IGasAcceptor");
        }
        catch (ClassNotFoundException e) {
            mekanismOldClassFound = false;
            return true;
        }
        mekanismOldClassFound = true;
        return false;
    }

    static {
        BC3_RATIO = 0.39f;
        TE_RATIO = BC3_RATIO / 10.0f;
        IC2_RATIO = 0.16f;
        MEKANISM_RATIO = 0.0016f;
        TO_BC_RATIO = 1.0f / BC3_RATIO;
        TO_TE_RATIO = 1.0f / TE_RATIO;
        TO_IC2_RATIO = 1.0f / IC2_RATIO;
        TO_MEKANISM_RATIO = 1.0f / MEKANISM_RATIO;
        ALLOW_UNSAFE_IC2 = false;
        gasOxygen = null;
    }
}

