/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission.compatibility;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.FMLLog;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySink;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.energy.IStrictEnergyAcceptor;
import micdoodle8.mods.galacticraft.api.transmission.ElectricalEvent;
import micdoodle8.mods.galacticraft.api.transmission.ElectricityPack;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.ElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.core.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.core.path.PathfinderChecker;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkConnection;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class UniversalNetwork
extends ElectricityNetwork {
    public static int tickCount = 0;
    private int tickDone = -1;
    private float totalRequested = 0.0f;
    private float totalStorageExcess = 0.0f;
    private float totalEnergy = 0.0f;
    private float totalSent = 0.0f;
    private boolean doneScheduled = false;
    private boolean spamstop = false;
    private boolean loopPrevention = false;
    private List<TileEntity> connectedAcceptors = new LinkedList<TileEntity>();
    private List<ForgeDirection> connectedDirections = new LinkedList<ForgeDirection>();
    private Set<TileEntity> availableAcceptors = new HashSet<TileEntity>();
    private Map<TileEntity, ForgeDirection> availableconnectedDirections = new HashMap<TileEntity, ForgeDirection>();
    private Map<TileEntity, Float> energyRequests = new HashMap<TileEntity, Float>();
    private List<TileEntity> ignoreAcceptors = new LinkedList<TileEntity>();
    private static final float ENERGYSTORAGELEVEL = 0.6f;

    @Override
    public ElectricityPack getRequest(TileEntity ... ignoreTiles) {
        if (tickCount != this.tickDone) {
            this.tickDone = tickCount;
            this.ignoreAcceptors.clear();
            this.ignoreAcceptors.addAll(Arrays.asList(ignoreTiles));
            this.doTickStartCalc();
            if (NetworkConfigHandler.isBuildcraftLoaded()) {
                try {
                    Class<?> clazz = Class.forName("micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityUniversalConductor");
                    for (IConductor wire : this.getTransmitters()) {
                        if (!clazz.isInstance(wire)) continue;
                        clazz.getMethod("reconfigureBC", new Class[0]).invoke((Object)wire, new Object[0]);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ElectricityPack.getFromWatts(this.totalRequested - this.totalEnergy - this.totalSent, 120.0f);
    }

    @Override
    public float produce(ElectricityPack electricity, boolean doReceive, TileEntity ... ignoreTiles) {
        float energyToProduce = electricity.getWatts();
        if (this.loopPrevention) {
            return energyToProduce;
        }
        if (energyToProduce > 0.0f) {
            ElectricalEvent.ElectricityProductionEvent evt = new ElectricalEvent.ElectricityProductionEvent(this, electricity, ignoreTiles);
            MinecraftForge.EVENT_BUS.post((Event)evt);
            if (!evt.isCanceled()) {
                if (tickCount != this.tickDone) {
                    this.tickDone = tickCount;
                    this.ignoreAcceptors.clear();
                    this.ignoreAcceptors.addAll(Arrays.asList(ignoreTiles));
                    this.doTickStartCalc();
                } else {
                    this.ignoreAcceptors.addAll(Arrays.asList(ignoreTiles));
                }
                if (!this.doneScheduled && this.totalRequested > 0.0f) {
                    try {
                        Class<?> clazz = Class.forName("micdoodle8.mods.galacticraft.core.tick.GCCoreTickHandlerServer");
                        clazz.getMethod("scheduleNetworkTick", this.getClass()).invoke(null, this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.doneScheduled = true;
                }
                float totalEnergyLast = this.totalEnergy;
                if (doReceive) {
                    this.totalEnergy += Math.min(energyToProduce, this.totalRequested - totalEnergyLast);
                }
                if (this.totalRequested >= totalEnergyLast + energyToProduce) {
                    return 0.0f;
                }
                if (totalEnergyLast >= this.totalRequested) {
                    return energyToProduce;
                }
                return totalEnergyLast + energyToProduce - this.totalRequested;
            }
        }
        return energyToProduce;
    }

    public void tickEnd() {
        this.doneScheduled = false;
        this.loopPrevention = true;
        if (this.totalEnergy > 0.0f) {
            this.doTickStartCalc();
            if (this.totalRequested > 0.0f) {
                this.totalSent = this.doProduce();
                this.totalEnergy = this.totalSent < this.totalEnergy ? (this.totalEnergy -= this.totalSent) : 0.0f;
            }
        } else {
            this.totalEnergy = 0.0f;
        }
        this.loopPrevention = false;
    }

    private void doTickStartCalc() {
        this.totalSent = 0.0f;
        this.refreshAcceptors();
        if (this.getTransmitters().size() == 0) {
            return;
        }
        this.loopPrevention = true;
        this.availableAcceptors.clear();
        this.availableconnectedDirections.clear();
        this.energyRequests.clear();
        this.totalRequested = 0.0f;
        this.totalStorageExcess = 0.0f;
        boolean isTELoaded = NetworkConfigHandler.isThermalExpansionLoaded();
        boolean isIC2Loaded = NetworkConfigHandler.isIndustrialCraft2Loaded();
        boolean isBCLoaded = NetworkConfigHandler.isBuildcraftLoaded();
        boolean isMekLoaded = NetworkConfigHandler.isMekanismLoaded();
        if (!this.connectedAcceptors.isEmpty()) {
            Iterator<ForgeDirection> acceptorDirection = this.connectedDirections.iterator();
            for (TileEntity acceptor : this.connectedAcceptors) {
                ForgeDirection sideFrom = acceptorDirection.next();
                if (this.ignoreAcceptors.contains(acceptor) || this.availableAcceptors.contains(acceptor)) continue;
                float e = 0.0f;
                if (acceptor instanceof IElectrical) {
                    e = ((IElectrical)acceptor).getRequest(sideFrom);
                } else if (isMekLoaded && acceptor instanceof IStrictEnergyAcceptor) {
                    e = (float)((((IStrictEnergyAcceptor)acceptor).getMaxEnergy() - ((IStrictEnergyAcceptor)acceptor).getEnergy()) * (double)NetworkConfigHandler.MEKANISM_RATIO);
                } else if (isTELoaded && acceptor instanceof IEnergyHandler) {
                    e = (float)((IEnergyHandler)acceptor).receiveEnergy(sideFrom, Integer.MAX_VALUE, true) * NetworkConfigHandler.TE_RATIO;
                } else if (isIC2Loaded && acceptor instanceof IEnergySink) {
                    e = NetworkConfigHandler.IC2_RATIO * (NetworkConfigHandler.ALLOW_UNSAFE_IC2 ? (float)((IEnergySink)acceptor).demandedEnergyUnits() : Math.min((float)((IEnergySink)acceptor).demandedEnergyUnits(), (float)((IEnergySink)acceptor).getMaxSafeInput()));
                } else if (isBCLoaded && acceptor instanceof IPowerReceptor) {
                    e = ((IPowerReceptor)acceptor).getPowerReceiver(sideFrom).powerRequest() * NetworkConfigHandler.BC3_RATIO;
                }
                if (!(e > 0.0f)) continue;
                this.availableAcceptors.add(acceptor);
                this.availableconnectedDirections.put(acceptor, sideFrom);
                this.energyRequests.put(acceptor, Float.valueOf(e));
                this.totalRequested += e;
                if (!(e > 0.6f)) continue;
                this.totalStorageExcess += e - 0.6f;
            }
        }
        ElectricityPack mergedPack = new ElectricityPack(this.totalRequested, 1.0f);
        TileEntity[] ignoretiles = new TileEntity[this.ignoreAcceptors.size()];
        ElectricalEvent.ElectricityRequestEvent evt = new ElectricalEvent.ElectricityRequestEvent(this, mergedPack, this.ignoreAcceptors.toArray(ignoretiles));
        MinecraftForge.EVENT_BUS.post((Event)evt);
        this.totalRequested = mergedPack.getWatts();
        this.loopPrevention = false;
    }

    private float doProduce() {
        float returnvalue;
        float sent = 0.0f;
        if (!this.availableAcceptors.isEmpty()) {
            boolean isTELoaded = NetworkConfigHandler.isThermalExpansionLoaded();
            boolean isIC2Loaded = NetworkConfigHandler.isIndustrialCraft2Loaded();
            boolean isBCLoaded = NetworkConfigHandler.isBuildcraftLoaded();
            boolean isMekLoaded = NetworkConfigHandler.isMekanismLoaded();
            float energyNeeded = this.totalRequested;
            float energyAvailable = this.totalEnergy;
            float reducor = 1.0f;
            float energyStorageReducor = 1.0f;
            if (energyNeeded > energyAvailable) {
                if ((energyNeeded -= this.totalStorageExcess) > energyAvailable) {
                    energyStorageReducor = 0.0f;
                    reducor = energyAvailable / energyNeeded;
                } else {
                    energyStorageReducor = (energyAvailable - energyNeeded) / this.totalStorageExcess;
                }
            }
            for (TileEntity tileEntity : this.availableAcceptors) {
                IStrictEnergyAcceptor receiver;
                float sentToAcceptor;
                if (sent >= energyAvailable) break;
                float currentSending = this.energyRequests.get(tileEntity).floatValue();
                if (currentSending > 0.6f) {
                    currentSending = 0.6f + (currentSending - 0.6f) * energyStorageReducor;
                }
                if ((currentSending *= reducor) > energyAvailable - sent) {
                    currentSending = energyAvailable - sent;
                }
                ForgeDirection sideFrom = this.availableconnectedDirections.get(tileEntity);
                if (tileEntity instanceof IElectrical) {
                    ElectricityPack electricityToSend = ElectricityPack.getFromWatts(currentSending, 120.0f);
                    sentToAcceptor = ((IElectrical)tileEntity).receiveElectricity(sideFrom, electricityToSend, true);
                } else if (isMekLoaded && tileEntity instanceof IStrictEnergyAcceptor) {
                    receiver = (IStrictEnergyAcceptor)tileEntity;
                    double mekToSend = currentSending * NetworkConfigHandler.TO_MEKANISM_RATIO;
                    sentToAcceptor = (float)receiver.transferEnergyToAcceptor(sideFrom, mekToSend);
                } else if (isTELoaded && tileEntity instanceof IEnergyHandler) {
                    IEnergyHandler handler = (IEnergyHandler)tileEntity;
                    int currentSendinginRF = currentSending >= 2.1474836E9f / NetworkConfigHandler.TO_TE_RATIO ? Integer.MAX_VALUE : (int)(currentSending * NetworkConfigHandler.TO_TE_RATIO);
                    sentToAcceptor = (float)handler.receiveEnergy(sideFrom, currentSendinginRF, false) * NetworkConfigHandler.TE_RATIO;
                } else if (isIC2Loaded && tileEntity instanceof IEnergySink) {
                    IEnergySink electricalTile = (IEnergySink)tileEntity;
                    double toSendIC2 = NetworkConfigHandler.IC2_RATIO * (NetworkConfigHandler.ALLOW_UNSAFE_IC2 ? currentSending : Math.min(currentSending, (float)electricalTile.getMaxSafeInput()));
                    toSendIC2 = Math.min(toSendIC2, electricalTile.demandedEnergyUnits());
                    sentToAcceptor = (float)(toSendIC2 - electricalTile.injectEnergyUnits(sideFrom, toSendIC2)) * NetworkConfigHandler.IC2_RATIO;
                } else if (isBCLoaded && tileEntity instanceof IPowerReceptor) {
                    receiver = ((IPowerReceptor)tileEntity).getPowerReceiver(sideFrom);
                    if (receiver != null) {
                        float req = receiver.powerRequest();
                        float bcToSend = currentSending * NetworkConfigHandler.TO_BC_RATIO;
                        sentToAcceptor = receiver.receiveEnergy(PowerHandler.Type.PIPE, Math.min(req, bcToSend), sideFrom) * NetworkConfigHandler.BC3_RATIO;
                    } else {
                        sentToAcceptor = 0.0f;
                    }
                } else {
                    sentToAcceptor = 0.0f;
                }
                if (sentToAcceptor / currentSending > 1.002f && sentToAcceptor > 0.001f) {
                    if (!this.spamstop) {
                        FMLLog.info((String)("Energy network: acceptor took too much energy, offered " + currentSending + ", took " + sentToAcceptor + ". " + tileEntity.toString()), (Object[])new Object[0]);
                        this.spamstop = true;
                    }
                    sentToAcceptor = currentSending;
                }
                sent += sentToAcceptor;
            }
        }
        if (tickCount % 200 == 0) {
            this.spamstop = false;
        }
        if ((returnvalue = sent) > this.totalEnergy) {
            returnvalue = this.totalEnergy;
        }
        if (returnvalue < 0.0f) {
            returnvalue = 0.0f;
        }
        return returnvalue;
    }

    @Override
    public void refresh() {
        Iterator<IConductor> it = this.getTransmitters().iterator();
        while (it.hasNext()) {
            IConductor conductor = it.next();
            if (conductor == null) {
                it.remove();
                continue;
            }
            TileEntity tile = (TileEntity)conductor;
            World world = tile.func_70314_l();
            if (tile.func_70320_p() || world == null || !world.func_72899_e(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n)) {
                it.remove();
                continue;
            }
            if (conductor != world.func_72796_p(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n)) {
                it.remove();
                continue;
            }
            if (conductor.getNetwork() == this) continue;
            conductor.setNetwork(this);
            conductor.onNetworkChanged();
        }
    }

    private void refreshAcceptors() {
        this.connectedAcceptors.clear();
        this.connectedDirections.clear();
        this.refresh();
        try {
            boolean isTELoaded = NetworkConfigHandler.isThermalExpansionLoaded();
            boolean isIC2Loaded = NetworkConfigHandler.isIndustrialCraft2Loaded();
            boolean isBCLoaded = NetworkConfigHandler.isBuildcraftLoaded();
            boolean isMekLoaded = NetworkConfigHandler.isMekanismLoaded();
            LinkedList<IConductor> conductors = new LinkedList<IConductor>();
            conductors.addAll(this.getTransmitters());
            for (IConductor conductor : conductors) {
                TileEntity[] adjacentConnections = conductor.getAdjacentConnections();
                for (int i = 0; i < adjacentConnections.length; ++i) {
                    TileEntity acceptor = adjacentConnections[i];
                    if (acceptor == null || acceptor instanceof IConductor || acceptor.func_70320_p()) continue;
                    ForgeDirection sideFrom = ForgeDirection.getOrientation((int)i).getOpposite();
                    if (acceptor instanceof IElectrical) {
                        if (!((IElectrical)acceptor).canConnect(sideFrom, NetworkType.POWER)) continue;
                        this.connectedAcceptors.add(acceptor);
                        this.connectedDirections.add(sideFrom);
                        continue;
                    }
                    if (isMekLoaded && acceptor instanceof IStrictEnergyAcceptor) {
                        if (!((IStrictEnergyAcceptor)acceptor).canReceiveEnergy(sideFrom)) continue;
                        this.connectedAcceptors.add(acceptor);
                        this.connectedDirections.add(sideFrom);
                        continue;
                    }
                    if (isTELoaded && acceptor instanceof IEnergyHandler) {
                        if (!((IEnergyHandler)acceptor).canInterface(sideFrom)) continue;
                        this.connectedAcceptors.add(acceptor);
                        this.connectedDirections.add(sideFrom);
                        continue;
                    }
                    if (isIC2Loaded && acceptor instanceof IEnergyAcceptor) {
                        if (!((IEnergyAcceptor)acceptor).acceptsEnergyFrom((TileEntity)conductor, sideFrom)) continue;
                        this.connectedAcceptors.add(acceptor);
                        this.connectedDirections.add(sideFrom);
                        continue;
                    }
                    if (!isBCLoaded || !(acceptor instanceof IPowerReceptor) || ((IPowerReceptor)acceptor).getPowerReceiver(sideFrom) == null) continue;
                    this.connectedAcceptors.add(acceptor);
                    this.connectedDirections.add(sideFrom);
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Energy Network: Error when trying to refresh list of power acceptors.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public IElectricityNetwork merge(IElectricityNetwork network) {
        if (network != null && network != this) {
            Set<IConductor> thisNetwork = this.getTransmitters();
            Set thatNetwork = network.getTransmitters();
            if (thisNetwork.size() >= thatNetwork.size()) {
                thisNetwork.addAll(thatNetwork);
                this.refresh();
                if (network instanceof UniversalNetwork) {
                    ((UniversalNetwork)network).destroy();
                }
                return this;
            }
            thatNetwork.addAll(thisNetwork);
            network.refresh();
            this.destroy();
            return network;
        }
        return this;
    }

    private void destroy() {
        this.getTransmitters().clear();
        this.connectedAcceptors.clear();
        this.availableAcceptors.clear();
        this.totalEnergy = 0.0f;
        this.totalRequested = 0.0f;
        try {
            Class<?> clazz = Class.forName("micdoodle8.mods.galacticraft.core.tick.GCCoreTickHandlerServer");
            clazz.getMethod("removeNetworkTick", this.getClass()).invoke(null, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void split(IConductor splitPoint) {
        if (splitPoint instanceof TileEntity) {
            TileEntity[] connectedBlocks;
            this.getTransmitters().remove(splitPoint);
            for (TileEntity connectedBlockA : connectedBlocks = splitPoint.getAdjacentConnections()) {
                if (!(connectedBlockA instanceof INetworkConnection)) continue;
                for (TileEntity connectedBlockB : connectedBlocks) {
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof INetworkConnection)) continue;
                    PathfinderChecker finder = new PathfinderChecker(((TileEntity)splitPoint).field_70331_k, (INetworkConnection)connectedBlockB, NetworkType.POWER, splitPoint);
                    finder.init(new Vector3(connectedBlockA));
                    if (finder.results.size() > 0) {
                        for (Vector3 node : finder.closedSet) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                            if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                            ((INetworkProvider)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    UniversalNetwork newNetwork = new UniversalNetwork();
                    for (Vector3 node : finder.closedSet) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                        if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                        newNetwork.getTransmitters().add((IConductor)nodeTile);
                    }
                    newNetwork.refresh();
                }
            }
        }
    }

    public String toString() {
        return "EnergyNetwork[" + this.hashCode() + "|Wires:" + this.getTransmitters().size() + "|Acceptors:" + this.connectedAcceptors.size() + "]";
    }
}

