/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityControllable;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketControllableEntity;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketEntityUpdate;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.tick.GCCoreKeyHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityBuggyFueler;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.input.Keyboard;

public class GCCoreEntityBuggy
extends GCCoreEntityControllable
implements IInventory,
IPacketReceiver,
IDockable {
    private final int tankCapacity = 1000;
    public FluidTank buggyFuelTank = new FluidTank(this.tankCapacity);
    protected long ticks = 0L;
    public int buggyType;
    public int fuel;
    public int currentDamage;
    public int timeSinceHit;
    public int rockDirection;
    public double speed;
    public float wheelRotationZ;
    public float wheelRotationX;
    float maxSpeed = 0.5f;
    float accel = 0.2f;
    float turnFactor = 3.0f;
    public String texture;
    ItemStack[] cargoItems = new ItemStack[60];
    public float turnProgress = 0.0f;
    public float rotationYawBuggy;
    public double boatX;
    public double boatY;
    public double boatZ;
    public double boatYaw;
    public double boatPitch;
    public int boatPosRotationIncrements;
    private IFuelDock landingPad;
    public Vector3 radarDishRotation = new Vector3();

    public GCCoreEntityBuggy(World var1) {
        super(var1);
        this.func_70105_a(0.98f, 1.7f);
        this.field_70129_M = 2.5f;
        this.fuel = 0;
        this.currentDamage = 18;
        this.timeSinceHit = 19;
        this.rockDirection = 20;
        this.speed = 0.0;
        this.field_70156_m = true;
        this.field_70180_af.func_75682_a(this.currentDamage, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(this.timeSinceHit, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(this.rockDirection, (Object)new Integer(1));
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    public GCCoreEntityBuggy(World var1, double var2, double var4, double var6, int type) {
        this(var1);
        this.func_70107_b(var2, var4 + (double)this.field_70129_M, var6);
        this.setBuggyType(type);
        this.cargoItems = new ItemStack[this.buggyType * 18];
    }

    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.buggyFuelTank.getFluid() == null ? 0.0 : (double)this.buggyFuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    public ModelBase getModel() {
        return null;
    }

    public int getType() {
        return this.buggyType;
    }

    protected void func_70088_a() {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O - 3.0;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void setBuggyType(int par1) {
        this.buggyType = par1;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double var1 = Math.cos((double)this.field_70177_z * Math.PI / 180.0 + 114.8) * -0.5;
            double var3 = Math.sin((double)this.field_70177_z * Math.PI / 180.0 + 114.8) * -0.5;
            this.field_70153_n.func_70107_b(this.field_70165_t + var1, this.field_70163_u - 2.0 + this.field_70153_n.func_70033_W(), this.field_70161_v + var3);
        }
    }

    @Override
    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, double motX, double motY, double motZ, boolean onGround) {
        if (this.field_70170_p.field_72995_K) {
            this.boatX = x;
            this.boatY = y;
            this.boatZ = z;
            this.boatYaw = yaw;
            this.boatPitch = pitch;
            this.field_70159_w = motX;
            this.field_70181_x = motY;
            this.field_70179_y = motZ;
            this.boatPosRotationIncrements = 5;
        } else {
            this.func_70107_b(x, y, z);
            this.func_70101_b(yaw, pitch);
            this.field_70159_w = motX;
            this.field_70181_x = motY;
            this.field_70179_y = motZ;
        }
    }

    public void func_70057_ab() {
        this.field_70180_af.func_75692_b(this.rockDirection, (Object)(-this.field_70180_af.func_75679_c(this.rockDirection)));
        this.field_70180_af.func_75692_b(this.timeSinceHit, (Object)10);
        this.field_70180_af.func_75692_b(this.currentDamage, (Object)(this.field_70180_af.func_75679_c(this.currentDamage) * 5));
    }

    public boolean func_70097_a(DamageSource var1, float var2) {
        if (this.field_70128_L || var1.equals(DamageSource.field_76367_g)) {
            return true;
        }
        this.field_70180_af.func_75692_b(this.rockDirection, (Object)(-this.field_70180_af.func_75679_c(this.rockDirection)));
        this.field_70180_af.func_75692_b(this.timeSinceHit, (Object)10);
        this.field_70180_af.func_75692_b(this.currentDamage, (Object)((int)((float)this.field_70180_af.func_75679_c(this.currentDamage) + var2 * 10.0f)));
        this.func_70018_K();
        if (var1.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)var1.func_76346_g()).field_71075_bZ.field_75098_d) {
            this.field_70180_af.func_75692_b(this.currentDamage, (Object)100);
        }
        if (this.field_70180_af.func_75679_c(this.currentDamage) > 2) {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                this.dropBuggyAsItem();
            }
            this.func_70106_y();
        }
        return true;
    }

    public void dropBuggyAsItem() {
        if (this.getItemsDropped() == null) {
            return;
        }
        for (ItemStack item : this.getItemsDropped()) {
            this.func_70099_a(item, 0.0f);
        }
    }

    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack(GCCoreItems.buggy, 1, this.buggyType));
        for (ItemStack item : this.cargoItems) {
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public void func_70056_a(double d, double d1, double d2, float f, float f1, int i) {
        if (!(this.field_70153_n == null || this.field_70153_n instanceof EntityPlayer && FMLClientHandler.instance().getClient().field_71439_g.equals((Object)this.field_70153_n))) {
            this.boatPosRotationIncrements = i + 5;
            this.boatX = d;
            this.boatY = d1 + (double)(this.field_70153_n == null ? 1 : 0);
            this.boatZ = d2;
            this.boatYaw = f;
            this.boatPitch = f1;
        }
    }

    public void func_70071_h_() {
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 1L;
        }
        ++this.ticks;
        super.func_70071_h_();
        if (!(!this.field_70170_p.field_72995_K || this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && FMLClientHandler.instance().getClient().field_71439_g.equals((Object)this.field_70153_n))) {
            if (this.boatPosRotationIncrements > 0) {
                double x = this.field_70165_t + (this.boatX - this.field_70165_t) / (double)this.boatPosRotationIncrements;
                double y = this.field_70163_u + (this.boatY - this.field_70163_u) / (double)this.boatPosRotationIncrements;
                double z = this.field_70161_v + (this.boatZ - this.field_70161_v) / (double)this.boatPosRotationIncrements;
                double var12 = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + var12 / (double)this.boatPosRotationIncrements);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.boatPitch - (double)this.field_70125_A) / (double)this.boatPosRotationIncrements);
                --this.boatPosRotationIncrements;
                this.func_70107_b(x, y, z);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                double x = this.field_70165_t + this.field_70159_w;
                double y = this.field_70163_u + this.field_70181_x;
                double z = this.field_70161_v + this.field_70179_y;
                if (this.field_70153_n != null) {
                    this.func_70107_b(x, y, z);
                }
                if (this.field_70122_E) {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                }
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
            return;
        }
        if (this.field_70180_af.func_75679_c(this.timeSinceHit) > 0) {
            this.field_70180_af.func_75692_b(this.timeSinceHit, (Object)(this.field_70180_af.func_75679_c(this.timeSinceHit) - 1));
        }
        if (this.field_70180_af.func_75679_c(this.currentDamage) > 0) {
            this.field_70180_af.func_75692_b(this.currentDamage, (Object)(this.field_70180_af.func_75679_c(this.currentDamage) - 1));
        }
        int var20 = 5;
        double var2 = 0.0;
        for (int var4 = 0; var4 < 5; ++var4) {
        }
        this.field_70181_x -= 0.04;
        if (this.field_70153_n == null) {
            this.field_70129_M = 5.0f;
        }
        if (this.field_70171_ac && this.speed > 0.2) {
            this.field_70170_p.func_72908_a((double)((float)this.field_70165_t), (double)((float)this.field_70163_u), (double)((float)this.field_70161_v), "random.fizz", 0.5f, 2.6f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
        }
        this.speed *= 0.98;
        if (this.speed > (double)this.maxSpeed) {
            this.speed = this.maxSpeed;
        }
        if (this.field_70123_F) {
            this.speed *= 0.9;
            this.field_70181_x = 0.1;
        }
        if (this.field_70170_p.field_72995_K && this.buggyFuelTank.getFluid() != null && this.buggyFuelTank.getFluid().amount > 0) {
            this.field_70159_w = -(this.speed * Math.cos((double)(this.field_70177_z - 90.0f) * Math.PI / 180.0));
            this.field_70179_y = -(this.speed * Math.sin((double)(this.field_70177_z - 90.0f) * Math.PI / 180.0));
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.wheelRotationX = (float)((double)this.wheelRotationX + (this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) * 250.0 * (double)(this.speed < 0.0 ? 1 : -1));
            this.wheelRotationZ = Math.max(-30.0f, Math.min(30.0f, this.wheelRotationZ * 0.9f));
            this.radarDishRotation.x = Math.sin((double)this.ticks * 0.05) * 50.0;
            this.radarDishRotation.z = Math.cos((double)this.ticks * 0.1) * 50.0;
        }
        if (!this.field_70170_p.field_72995_K && Math.abs(this.field_70159_w * this.field_70179_y) > 1.0E-6) {
            int speedMod;
            double d = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y;
            if (d == 0.0) {
                d += (double)1.0E-4f;
            }
            if ((speedMod = MathHelper.func_76128_c((double)(2.0 / d))) == 0 || this.ticks % (long)speedMod == 0L) {
                this.removeFuel(1);
            }
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendPacketToServer((Packet)GCCorePacketEntityUpdate.buildUpdatePacket(this));
        }
        if (!this.field_70170_p.field_72995_K && this.ticks % 5L == 0L) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)50.0, (int)this.field_71093_bK, (Packet)GCCorePacketEntityUpdate.buildUpdatePacket(this));
        }
        if (!this.field_70170_p.field_72995_K && this.ticks % 5L == 0L) {
            GCCorePacketManager.sendPacketToClients(this.getDescriptionPacket(), this.field_70170_p, new Vector3(this), 50.0);
        }
    }

    public Packet getDescriptionPacket() {
        return GCCorePacketManager.getPacket("GCCoreEntities", (Entity)this, this.buggyType, this.buggyFuelTank.getFluid() != null ? this.buggyFuelTank.getFluid().amount : 0);
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        try {
            if (this.field_70170_p.field_72995_K) {
                this.buggyType = dataStream.readInt();
                this.buggyFuelTank.setFluid(new FluidStack(GalacticraftCore.fluidFuel, dataStream.readInt()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_70037_a(NBTTagCompound var1) {
        this.fuel = var1.func_74762_e("Fuel");
        this.buggyType = var1.func_74762_e("buggyType");
        NBTTagList var2 = var1.func_74761_m("Items");
        this.cargoItems = new ItemStack[this.func_70302_i_()];
        if (var1.func_74764_b("fuelTank")) {
            this.buggyFuelTank.readFromNBT(var1.func_74775_l("fuelTank"));
        }
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < 0 || var5 >= this.cargoItems.length) continue;
            this.cargoItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    protected void func_70014_b(NBTTagCompound var1) {
        var1.func_74768_a("fuel", this.fuel);
        var1.func_74768_a("buggyType", this.buggyType);
        NBTTagList var2 = new NBTTagList();
        if (this.buggyFuelTank.getFluid() != null) {
            var1.func_74782_a("fuelTank", (NBTBase)this.buggyFuelTank.writeToNBT(new NBTTagCompound()));
        }
        for (int var3 = 0; var3 < this.cargoItems.length; ++var3) {
            if (this.cargoItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.cargoItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        var1.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70302_i_() {
        return this.buggyType * 18;
    }

    public ItemStack func_70301_a(int var1) {
        return this.cargoItems[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        if (this.cargoItems[var1] != null) {
            if (this.cargoItems[var1].field_77994_a <= var2) {
                ItemStack var3 = this.cargoItems[var1];
                this.cargoItems[var1] = null;
                return var3;
            }
            ItemStack var3 = this.cargoItems[var1].func_77979_a(var2);
            if (this.cargoItems[var1].field_77994_a == 0) {
                this.cargoItems[var1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        if (this.cargoItems[var1] != null) {
            ItemStack var2 = this.cargoItems[var1];
            this.cargoItems[var1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.cargoItems[var1] = var2;
        if (var2 != null && var2.field_77994_a > this.func_70297_j_()) {
            var2.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return "Buggy";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_70128_L ? false : var1.func_70068_e((Entity)this) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_130002_c(EntityPlayer var1) {
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70153_n == null) {
                var1.func_70006_a(ChatMessageComponent.func_111066_d((String)(Keyboard.getKeyName((int)GCCoreKeyHandlerClient.leftKey.field_74512_d) + " / " + Keyboard.getKeyName((int)GCCoreKeyHandlerClient.rightKey.field_74512_d) + "  - " + StatCollector.func_74838_a((String)"gui.buggy.turn.name"))));
                var1.func_70006_a(ChatMessageComponent.func_111066_d((String)(Keyboard.getKeyName((int)GCCoreKeyHandlerClient.accelerateKey.field_74512_d) + "       - " + StatCollector.func_74838_a((String)"gui.buggy.accel.name"))));
                var1.func_70006_a(ChatMessageComponent.func_111066_d((String)(Keyboard.getKeyName((int)GCCoreKeyHandlerClient.decelerateKey.field_74512_d) + "       - " + StatCollector.func_74838_a((String)"gui.buggy.decel.name"))));
                var1.func_70006_a(ChatMessageComponent.func_111066_d((String)(Keyboard.getKeyName((int)GCCoreKeyHandlerClient.openSpaceshipInv.field_74512_d) + "       - " + StatCollector.func_74838_a((String)"gui.buggy.inv.name"))));
            }
            return true;
        }
        if (this.field_70153_n != null) {
            var1.func_70078_a(null);
            return true;
        }
        var1.func_70078_a((Entity)this);
        return true;
    }

    @Override
    public boolean pressKey(int key) {
        if (this.field_70170_p.field_72995_K && (key == 6 || key == 8 || key == 9)) {
            PacketDispatcher.sendPacketToServer((Packet)GCCorePacketControllableEntity.buildKeyPacket(key));
            return true;
        }
        switch (key) {
            case 0: {
                this.speed += (double)this.accel / 20.0;
                return true;
            }
            case 1: {
                this.speed -= (double)this.accel / 20.0;
                return true;
            }
            case 2: {
                this.field_70177_z -= 0.5f * this.turnFactor;
                this.wheelRotationZ = Math.max(-30.0f, Math.min(30.0f, this.wheelRotationZ + 0.5f));
                return true;
            }
            case 3: {
                this.field_70177_z += 0.5f * this.turnFactor;
                this.wheelRotationZ = Math.max(-30.0f, Math.min(30.0f, this.wheelRotationZ - 0.5f));
                return true;
            }
        }
        return false;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public int addFuel(FluidStack liquid, boolean doDrain) {
        FluidStack liquidInTank = this.buggyFuelTank.getFluid();
        if (liquid != null && FluidRegistry.getFluidName((FluidStack)liquid).equalsIgnoreCase("Fuel") && this.landingPad != null && (liquidInTank == null || liquidInTank.amount + liquid.amount <= this.buggyFuelTank.getCapacity())) {
            return this.buggyFuelTank.fill(liquid, doDrain);
        }
        return 0;
    }

    @Override
    public FluidStack removeFuel(int amount) {
        return this.buggyFuelTank.drain(amount, true);
    }

    @Override
    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        ItemStack stackAt;
        if (this.buggyType == 0) {
            return ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
        }
        int count = 0;
        for (count = 0; count < this.cargoItems.length; ++count) {
            stackAt = this.cargoItems[count];
            if (stackAt == null || stackAt.field_77993_c != stack.field_77993_c || stackAt.func_77960_j() != stack.func_77960_j() || stackAt.field_77994_a >= stackAt.func_77976_d()) continue;
            if (doAdd) {
                this.cargoItems[count].field_77994_a += stack.field_77994_a;
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        for (count = 0; count < this.cargoItems.length; ++count) {
            stackAt = this.cargoItems[count];
            if (stackAt != null) continue;
            if (doAdd) {
                this.cargoItems[count] = stack;
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    @Override
    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        for (int i = 0; i < this.cargoItems.length; ++i) {
            ItemStack stackAt = this.cargoItems[i];
            if (stackAt == null) continue;
            if (doRemove && --this.cargoItems[i].field_77994_a <= 0) {
                this.cargoItems[i] = null;
            }
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, new ItemStack(stackAt.field_77993_c, 1, stackAt.func_77960_j()));
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, null);
    }

    @Override
    public void setPad(IFuelDock pad) {
        this.landingPad = pad;
    }

    @Override
    public IFuelDock getLandingPad() {
        return this.landingPad;
    }

    @Override
    public void onPadDestroyed() {
    }

    @Override
    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof GCCoreTileEntityBuggyFueler;
    }
}

