/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.event.oxygen.GCCoreOxygenSuffocationEvent;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GCCoreDamageSource;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCCoreBlocks;
import micdoodle8.mods.galacticraft.core.command.GCCoreCommandGCInv;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityLander;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityParaChest;
import micdoodle8.mods.galacticraft.core.event.GCCoreEventWakePlayer;
import micdoodle8.mods.galacticraft.core.inventory.GCCoreInventoryExtended;
import micdoodle8.mods.galacticraft.core.items.GCCoreItems;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerClient;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketSchematicList;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.moon.dimension.GCMoonWorldProvider;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.EnumStatus;
import net.minecraft.item.Item;
import net.minecraft.item.ItemInWorldManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class GCCorePlayerMP
extends EntityPlayerMP {
    private GCCoreInventoryExtended extendedInventory = new GCCoreInventoryExtended();
    private int airRemaining;
    private int airRemaining2;
    private long tick;
    private int damageCounter;
    private int spaceshipTier = 1;
    private ItemStack[] rocketStacks = new ItemStack[9];
    private int rocketType;
    private int fuelLevel;
    private Item rocketItem;
    private ItemStack launchpadStack;
    private boolean usingParachute;
    private ItemStack parachuteInSlot;
    private ItemStack lastParachuteInSlot;
    private ItemStack frequencyModuleInSlot;
    private ItemStack lastFrequencyModuleInSlot;
    private ItemStack maskInSlot;
    private ItemStack lastMaskInSlot;
    private ItemStack gearInSlot;
    private ItemStack lastGearInSlot;
    private ItemStack tankInSlot1;
    private ItemStack lastTankInSlot1;
    private ItemStack tankInSlot2;
    private ItemStack lastTankInSlot2;
    private int launchAttempts = 0;
    private boolean usingPlanetSelectionGui;
    private int openPlanetSelectionGuiCooldown;
    private boolean hasOpenedPlanetSelectionGui = false;
    private int chestSpawnCooldown;
    private Vector3 chestSpawnVector;
    private int teleportCooldown;
    private int chatCooldown;
    private int lastStep;
    private double coordsTeleportedFromX;
    private double coordsTeleportedFromZ;
    private int spaceStationDimensionID = -1;
    private boolean oxygenSetupValid;
    private boolean lastOxygenSetupValid;
    private boolean touchedGround;
    private boolean lastOnGround;
    private ArrayList<ISchematicPage> unlockedSchematics = new ArrayList();
    private ArrayList<ISchematicPage> lastUnlockedSchematics = new ArrayList();
    private int cryogenicChamberCooldown;
    private boolean receivedSoundWarning;

    public GCCorePlayerMP(MinecraftServer server, World world, String username, ItemInWorldManager itemInWorldManager) {
        super(server, world, username, itemInWorldManager);
        if (!GalacticraftCore.playersServer.containsKey(this.field_71092_bJ)) {
            GalacticraftCore.playersServer.put(this.field_71092_bJ, this);
        }
    }

    public void func_70645_a(DamageSource damageSource) {
        GalacticraftCore.playersServer.remove((Object)this);
        super.func_70645_a(damageSource);
    }

    public void func_71049_a(EntityPlayer par1EntityPlayer, boolean keepInv) {
        super.func_71049_a(par1EntityPlayer, keepInv);
        if (par1EntityPlayer instanceof GCCorePlayerMP) {
            if (keepInv) {
                this.getExtendedInventory().copyInventory(((GCCorePlayerMP)par1EntityPlayer).extendedInventory);
            } else if (this.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                this.getExtendedInventory().copyInventory(((GCCorePlayerMP)par1EntityPlayer).extendedInventory);
            }
            this.setSpaceStationDimensionID(((GCCorePlayerMP)par1EntityPlayer).getSpaceStationDimensionID());
            this.unlockedSchematics = ((GCCorePlayerMP)par1EntityPlayer).getUnlockedSchematics();
        }
    }

    protected void func_70069_a(float par1) {
        if (this.field_70154_o instanceof EntityAutoRocket || this.field_70154_o instanceof GCCoreEntityLander) {
            return;
        }
        super.func_70069_a(par1);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!GalacticraftCore.playersServer.containsKey(this.field_71092_bJ) || this.tick % 360L == 0L) {
            GalacticraftCore.playersServer.put(this.field_71092_bJ, this);
        }
        if (this.tick >= Long.MAX_VALUE) {
            this.tick = 0L;
        }
        ++this.tick;
        if (this.cryogenicChamberCooldown > 0) {
            --this.cryogenicChamberCooldown;
        }
        if (!this.field_70122_E && this.lastOnGround) {
            this.setTouchedGround(true);
        }
        this.updateStep();
        if (this.getTeleportCooldown() > 0) {
            this.setTeleportCooldown(this.getTeleportCooldown() - 1);
        }
        if (this.getChatCooldown() > 0) {
            this.setChatCooldown(this.getChatCooldown() - 1);
        }
        if (this.openPlanetSelectionGuiCooldown > 0) {
            --this.openPlanetSelectionGuiCooldown;
        }
        this.checkCurrentItem();
        if (!this.hasOpenedPlanetSelectionGui && this.openPlanetSelectionGuiCooldown == 1) {
            this.sendPlanetList();
            this.setUsingPlanetGui();
            this.hasOpenedPlanetSelectionGui = true;
        }
        if (this.usingPlanetSelectionGui) {
            this.sendPlanetList();
        }
        if (this.damageCounter > 0) {
            --this.damageCounter;
        }
        if (this.tick % 30L == 0L && this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            this.sendAirRemainingPacket();
        }
        if (this.usingParachute) {
            if (this.lastParachuteInSlot != null) {
                this.field_70143_R = 0.0f;
            }
            if (this.field_70122_E) {
                this.setUsingParachute(false);
            }
        }
        this.checkGear();
        if (this.getChestSpawnCooldown() > 0) {
            this.setChestSpawnCooldown(this.getChestSpawnCooldown() - 1);
        }
        if (this.getChestSpawnCooldown() == 180 && this.getChestSpawnVector() != null) {
            GCCoreEntityParaChest chest = new GCCoreEntityParaChest(this.field_70170_p, this.getRocketStacks(), this.getFuelLevel());
            chest.func_70107_b(this.getChestSpawnVector().x, this.getChestSpawnVector().y, this.getChestSpawnVector().z);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)chest);
            }
        }
        if (this.getLaunchAttempts() > 0 && this.field_70154_o == null) {
            this.setLaunchAttempts(0);
        }
        this.checkOxygen();
        if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (this.oxygenSetupValid != this.lastOxygenSetupValid || this.tick % 100L == 0L)) {
            this.field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.UPDATE_OXYGEN_VALIDITY, new Object[]{this.oxygenSetupValid}));
        }
        this.throwMeteors();
        if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider || this.usingPlanetSelectionGui) {
            this.field_71135_a.field_72572_g = 0;
        }
        this.updateSchematics();
        if (this.frequencyModuleInSlot == null && !this.receivedSoundWarning && this.tick > 0L && this.tick % 250L == 0L && this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && this.field_70122_E) {
            this.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.YELLOW) + "I'll probably need a " + (Object)((Object)EnumColor.AQUA) + GCCoreItems.basicItem.func_77653_i(new ItemStack(GCCoreItems.basicItem, 1, 19)) + (Object)((Object)EnumColor.YELLOW) + " if I want to hear properly here.")));
            this.receivedSoundWarning = true;
        }
        this.lastOxygenSetupValid = this.oxygenSetupValid;
        this.lastUnlockedSchematics = this.getUnlockedSchematics();
        this.lastOnGround = this.field_70122_E;
    }

    private void updateStep() {
        if (this.field_70170_p != null && this.field_70170_p.field_73011_w instanceof GCMoonWorldProvider && !this.field_70160_al && this.field_70154_o == null && this.field_70170_p.func_72798_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v)) == GCCoreBlocks.blockMoon.field_71990_ca && this.field_70170_p.func_72805_g(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v)) == 5) {
            int meta = -1;
            int i = 1 + MathHelper.func_76128_c((double)((double)(this.field_70177_z * 8.0f / 360.0f) + 0.5)) & 7;
            switch (this.lastStep) {
                case 1: {
                    switch (i) {
                        case 0: {
                            meta = 2;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 1: {
                            meta = 4;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 2: {
                            meta = 2;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 3: {
                            meta = 2;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 4: {
                            meta = 2;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 5: {
                            meta = 2;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 6: {
                            meta = 2;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 7: {
                            meta = 2;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                        }
                    }
                    this.lastStep = 2;
                    break;
                }
                case 2: {
                    switch (i) {
                        case 0: {
                            meta = 1;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 1: {
                            meta = 1;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 2: {
                            meta = 4;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 3: {
                            meta = 4;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 4: {
                            meta = 1;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 5: {
                            meta = 3;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 6: {
                            meta = 2;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                            break;
                        }
                        case 7: {
                            meta = 4;
                            this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                        }
                    }
                    this.lastStep = 1;
                    this.field_70170_p.func_72921_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), meta + 5, 3);
                    break;
                }
                default: {
                    this.lastStep = 1;
                }
            }
        }
    }

    private void checkCurrentItem() {
        ItemStack theCurrentItem = this.field_71071_by.func_70448_g();
        if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && theCurrentItem != null) {
            int var1 = theCurrentItem.field_77994_a;
            int var2 = theCurrentItem.func_77960_j();
            if (theCurrentItem.func_77973_b().field_77779_bT == Block.field_72069_aq.field_71990_ca) {
                ItemStack stack;
                this.field_71071_by.field_70462_a[this.field_71071_by.field_70461_c] = stack = new ItemStack(GCCoreBlocks.unlitTorch, var1, 0);
            } else if (theCurrentItem.func_77973_b().field_77779_bT == Item.field_77707_k.field_77779_bT) {
                NBTTagCompound nbttagcompound;
                Hashtable<Enchantment, Integer> enchants = new Hashtable<Enchantment, Integer>();
                NBTTagList list = theCurrentItem.func_77986_q();
                if (list != null) {
                    for (int var7 = 0; var7 < list.func_74745_c(); ++var7) {
                        int enchID = ((NBTTagCompound)list.func_74743_b(var7)).func_74765_d("id");
                        int enchLvl = ((NBTTagCompound)list.func_74743_b(var7)).func_74765_d("lvl");
                        Enchantment e = Enchantment.field_77331_b[enchID];
                        enchants.put(e, enchLvl);
                    }
                }
                ItemStack stack = new ItemStack(GCCoreItems.bowGravity, var1, var2);
                for (Map.Entry entry : enchants.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    stack.func_77966_a((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue());
                }
                if (theCurrentItem.field_77990_d != null && theCurrentItem.field_77990_d.func_74764_b("display") && (nbttagcompound = theCurrentItem.field_77990_d.func_74775_l("display")).func_74764_b("Name")) {
                    stack.func_82834_c(nbttagcompound.func_74779_i("Name"));
                }
                this.field_71071_by.field_70462_a[this.field_71071_by.field_70461_c] = stack;
            }
        } else if (!(this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) && theCurrentItem != null) {
            int var1 = theCurrentItem.field_77994_a;
            int var2 = theCurrentItem.func_77960_j();
            if (theCurrentItem.func_77973_b().field_77779_bT == GCCoreBlocks.unlitTorch.field_71990_ca) {
                ItemStack stack;
                this.field_71071_by.field_70462_a[this.field_71071_by.field_70461_c] = stack = new ItemStack(Block.field_72069_aq, var1, 0);
            } else if (theCurrentItem.func_77973_b().field_77779_bT == GCCoreItems.bowGravity.field_77779_bT) {
                NBTTagCompound nbttagcompound;
                Hashtable<Enchantment, Integer> enchants = new Hashtable<Enchantment, Integer>();
                NBTTagList list = theCurrentItem.func_77986_q();
                if (list != null) {
                    for (int var7 = 0; var7 < list.func_74745_c(); ++var7) {
                        int enchID = ((NBTTagCompound)list.func_74743_b(var7)).func_74765_d("id");
                        int enchLvl = ((NBTTagCompound)list.func_74743_b(var7)).func_74765_d("lvl");
                        Enchantment e = Enchantment.field_77331_b[enchID];
                        enchants.put(e, enchLvl);
                    }
                }
                ItemStack stack = new ItemStack((Item)Item.field_77707_k, var1, var2);
                for (Map.Entry entry : enchants.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    stack.func_77966_a((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue());
                }
                if (theCurrentItem.field_77990_d != null && theCurrentItem.field_77990_d.func_74764_b("display") && (nbttagcompound = theCurrentItem.field_77990_d.func_74775_l("display")).func_74764_b("Name")) {
                    stack.func_82834_c(nbttagcompound.func_74779_i("Name"));
                }
                this.field_71071_by.field_70462_a[this.field_71071_by.field_70461_c] = stack;
            }
        }
    }

    private void sendPlanetList() {
        HashMap<String, Integer> map = WorldUtil.getArrayOfPossibleDimensions(WorldUtil.getPossibleDimensionsForSpaceshipTier(this.getSpaceshipTier()), this);
        String temp = "";
        int count = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            temp = temp.concat(entry.getKey() + (count < map.entrySet().size() - 1 ? "." : ""));
            ++count;
        }
        this.field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.UPDATE_DIMENSION_LIST, new Object[]{this.field_71092_bJ, temp}));
    }

    private void checkGear() {
        this.maskInSlot = this.getExtendedInventory().func_70301_a(0);
        this.gearInSlot = this.getExtendedInventory().func_70301_a(1);
        this.tankInSlot1 = this.getExtendedInventory().func_70301_a(2);
        this.tankInSlot2 = this.getExtendedInventory().func_70301_a(3);
        this.parachuteInSlot = this.getExtendedInventory().func_70301_a(4);
        this.frequencyModuleInSlot = this.getExtendedInventory().func_70301_a(5);
        if (this.frequencyModuleInSlot != null && this.lastFrequencyModuleInSlot == null && this.frequencyModuleInSlot.func_77973_b().field_77779_bT == GCCoreItems.basicItem.field_77779_bT && this.frequencyModuleInSlot.func_77960_j() == 19) {
            this.sendGearUpdatePacket(EnumModelPacket.ADD_FREQUENCY_MODULE.getIndex());
        }
        if (this.frequencyModuleInSlot == null && this.lastFrequencyModuleInSlot != null) {
            this.sendGearUpdatePacket(EnumModelPacket.REMOVE_FREQUENCY_MODULE.getIndex());
        }
        if (this.maskInSlot != null && this.lastMaskInSlot == null && this.maskInSlot.func_77973_b().field_77779_bT == GCCoreItems.oxMask.field_77779_bT) {
            this.sendGearUpdatePacket(EnumModelPacket.ADDMASK.getIndex());
        }
        if (this.maskInSlot == null && this.lastMaskInSlot != null) {
            this.sendGearUpdatePacket(EnumModelPacket.REMOVEMASK.getIndex());
        }
        if (this.gearInSlot != null && this.lastGearInSlot == null && this.gearInSlot.func_77973_b().field_77779_bT == GCCoreItems.oxygenGear.field_77779_bT) {
            this.sendGearUpdatePacket(EnumModelPacket.ADDGEAR.getIndex());
        }
        if (this.gearInSlot == null && this.lastGearInSlot != null) {
            this.sendGearUpdatePacket(EnumModelPacket.REMOVEGEAR.getIndex());
        }
        if (this.tankInSlot1 != null && this.lastTankInSlot1 == null) {
            if (this.tankInSlot1.func_77973_b().field_77779_bT == GCCoreItems.oxTankLight.field_77779_bT) {
                this.sendGearUpdatePacket(EnumModelPacket.ADDLEFTGREENTANK.getIndex());
            } else if (this.tankInSlot1.func_77973_b().field_77779_bT == GCCoreItems.oxTankMedium.field_77779_bT) {
                this.sendGearUpdatePacket(EnumModelPacket.ADDLEFTORANGETANK.getIndex());
            } else if (this.tankInSlot1.func_77973_b().field_77779_bT == GCCoreItems.oxTankHeavy.field_77779_bT) {
                this.sendGearUpdatePacket(EnumModelPacket.ADDLEFTREDTANK.getIndex());
            }
        }
        if (this.tankInSlot1 == null && this.lastTankInSlot1 != null) {
            this.sendGearUpdatePacket(EnumModelPacket.REMOVE_LEFT_TANK.getIndex());
        }
        if (this.tankInSlot1 != null && this.lastTankInSlot1 != null && this.tankInSlot1.func_77973_b().field_77779_bT != this.lastTankInSlot1.func_77973_b().field_77779_bT) {
            if (this.tankInSlot1.func_77973_b().field_77779_bT == GCCoreItems.oxTankLight.field_77779_bT) {
                this.sendGearUpdatePacket(EnumModelPacket.ADDLEFTGREENTANK.getIndex());
            } else if (this.tankInSlot1.func_77973_b().field_77779_bT == GCCoreItems.oxTankMedium.field_77779_bT) {
                this.sendGearUpdatePacket(EnumModelPacket.ADDLEFTORANGETANK.getIndex());
            } else if (this.tankInSlot1.func_77973_b().field_77779_bT == GCCoreItems.oxTankHeavy.field_77779_bT) {
                this.sendGearUpdatePacket(EnumModelPacket.ADDLEFTREDTANK.getIndex());
            }
        }
        if (this.tankInSlot2 != null && this.lastTankInSlot2 == null) {
            if (this.tankInSlot2.func_77973_b().field_77779_bT == GCCoreItems.oxTankLight.field_77779_bT) {
                this.sendGearUpdatePacket(EnumModelPacket.ADDRIGHTGREENTANK.getIndex());
            } else if (this.tankInSlot2.func_77973_b().field_77779_bT == GCCoreItems.oxTankMedium.field_77779_bT) {
                this.sendGearUpdatePacket(EnumModelPacket.ADDRIGHTORANGETANK.getIndex());
            } else if (this.tankInSlot2.func_77973_b().field_77779_bT == GCCoreItems.oxTankHeavy.field_77779_bT) {
                this.sendGearUpdatePacket(EnumModelPacket.ADDRIGHTREDTANK.getIndex());
            }
        }
        if (this.tankInSlot2 == null && this.lastTankInSlot2 != null) {
            this.sendGearUpdatePacket(EnumModelPacket.REMOVE_RIGHT_TANK.getIndex());
        }
        if (this.tankInSlot2 != null && this.lastTankInSlot2 != null && this.tankInSlot2.func_77973_b().field_77779_bT != this.lastTankInSlot2.func_77973_b().field_77779_bT) {
            if (this.tankInSlot2.func_77973_b().field_77779_bT == GCCoreItems.oxTankLight.field_77779_bT) {
                this.sendGearUpdatePacket(EnumModelPacket.ADDRIGHTGREENTANK.getIndex());
            } else if (this.tankInSlot2.func_77973_b().field_77779_bT == GCCoreItems.oxTankMedium.field_77779_bT) {
                this.sendGearUpdatePacket(EnumModelPacket.ADDRIGHTORANGETANK.getIndex());
            } else if (this.tankInSlot2.func_77973_b().field_77779_bT == GCCoreItems.oxTankHeavy.field_77779_bT) {
                this.sendGearUpdatePacket(EnumModelPacket.ADDRIGHTREDTANK.getIndex());
            }
        }
        if (this.usingParachute && this.parachuteInSlot == null && this.lastParachuteInSlot != null) {
            this.sendGearUpdatePacket(EnumModelPacket.REMOVE_PARACHUTE.getIndex());
        }
        if (this.usingParachute && this.parachuteInSlot != null && this.lastParachuteInSlot == null) {
            this.sendGearUpdatePacket(EnumModelPacket.ADD_PARACHUTE.getIndex());
        }
        if (this.parachuteInSlot != null && this.lastParachuteInSlot != null && this.parachuteInSlot.func_77960_j() != this.lastParachuteInSlot.func_77960_j()) {
            this.sendGearUpdatePacket(EnumModelPacket.ADD_PARACHUTE.getIndex());
        }
        this.lastMaskInSlot = this.maskInSlot;
        this.lastGearInSlot = this.gearInSlot;
        this.lastTankInSlot1 = this.tankInSlot1;
        this.lastTankInSlot2 = this.tankInSlot2;
        this.lastParachuteInSlot = this.parachuteInSlot;
        this.lastFrequencyModuleInSlot = this.frequencyModuleInSlot;
    }

    private void checkOxygen() {
        ItemStack tankInSlot = this.getExtendedInventory().func_70301_a(2);
        ItemStack tankInSlot2 = this.getExtendedInventory().func_70301_a(3);
        int drainSpacing = OxygenUtil.getDrainSpacing(tankInSlot, tankInSlot2);
        if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && !this.field_71075_bZ.field_75098_d) {
            boolean airEmpty;
            if (tankInSlot == null) {
                this.airRemaining = 0;
            }
            if (tankInSlot2 == null) {
                this.airRemaining2 = 0;
            }
            if (drainSpacing > 0) {
                if (this.tick % (long)drainSpacing == 0L && !OxygenUtil.isAABBInBreathableAirBlock((Entity)this) && !this.usingPlanetSelectionGui) {
                    if (tankInSlot != null && tankInSlot.func_77958_k() - tankInSlot.func_77960_j() > 0) {
                        tankInSlot.func_77972_a(1, (EntityLivingBase)this);
                    }
                    if (tankInSlot2 != null && tankInSlot2.func_77958_k() - tankInSlot2.func_77960_j() > 0) {
                        tankInSlot2.func_77972_a(1, (EntityLivingBase)this);
                    }
                }
                if (tankInSlot != null) {
                    this.airRemaining = tankInSlot.func_77958_k() - tankInSlot.func_77960_j();
                }
                if (tankInSlot2 != null) {
                    this.airRemaining2 = tankInSlot2.func_77958_k() - tankInSlot2.func_77960_j();
                }
            } else if (this.tick % 60L == 0L) {
                if (OxygenUtil.isAABBInBreathableAirBlock((Entity)this)) {
                    if (this.airRemaining < 90 && tankInSlot != null) {
                        this.airRemaining = Math.min(this.airRemaining + 1, tankInSlot.func_77958_k() - tankInSlot.func_77960_j());
                    }
                    if (this.airRemaining2 < 90 && tankInSlot2 != null) {
                        this.airRemaining2 = Math.min(this.airRemaining2 + 1, tankInSlot2.func_77958_k() - tankInSlot2.func_77960_j());
                    }
                } else {
                    if (this.airRemaining > 0) {
                        this.airRemaining = Math.max(this.airRemaining - 1, 0);
                    }
                    if (this.airRemaining2 > 0) {
                        this.airRemaining2 = Math.max(this.airRemaining2 - 1, 0);
                    }
                }
            }
            boolean bl = airEmpty = this.airRemaining <= 0 && this.airRemaining2 <= 0;
            this.oxygenSetupValid = this.func_70617_f_() ? this.lastOxygenSetupValid : OxygenUtil.hasValidOxygenSetup(this) && !airEmpty || OxygenUtil.isAABBInBreathableAirBlock((Entity)this);
            if (!this.oxygenSetupValid && !this.field_70170_p.field_72995_K && this.func_70089_S() && this.damageCounter == 0) {
                this.damageCounter = GCCoreConfigManager.suffocationCooldown;
                GCCoreOxygenSuffocationEvent.Pre suffocationEvent = new GCCoreOxygenSuffocationEvent.Pre((EntityLivingBase)this);
                MinecraftForge.EVENT_BUS.post((Event)suffocationEvent);
                if (!suffocationEvent.isCanceled()) {
                    this.func_70097_a(GCCoreDamageSource.oxygenSuffocation, GCCoreConfigManager.suffocationDamage);
                    GCCoreOxygenSuffocationEvent.Post suffocationEventPost = new GCCoreOxygenSuffocationEvent.Post((EntityLivingBase)this);
                    MinecraftForge.EVENT_BUS.post((Event)suffocationEventPost);
                }
            }
        } else if (this.tick % 20L == 0L && !this.field_71075_bZ.field_75098_d && this.airRemaining < 90) {
            ++this.airRemaining;
            ++this.airRemaining2;
        } else if (this.field_71075_bZ.field_75098_d) {
            this.airRemaining = 90;
            this.airRemaining2 = 90;
        } else {
            this.oxygenSetupValid = true;
        }
    }

    private void throwMeteors() {
        if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT && ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getMeteorFrequency() > 0.0) {
            GCCoreEntityMeteor meteor;
            double motZ;
            double motX;
            int z;
            int y;
            int x;
            EntityPlayer closestPlayer;
            double f = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getMeteorFrequency();
            if (this.field_70170_p.field_73012_v.nextInt(MathHelper.func_76128_c((double)(f * 1000.0))) == 0 && ((closestPlayer = this.field_70170_p.func_72890_a((Entity)this, 100.0)) == null || closestPlayer.field_70157_k <= this.field_70157_k)) {
                x = this.field_70170_p.field_73012_v.nextInt(20) - 10;
                y = this.field_70170_p.field_73012_v.nextInt(20) + 200;
                z = this.field_70170_p.field_73012_v.nextInt(20) - 10;
                motX = this.field_70170_p.field_73012_v.nextDouble() * 5.0;
                motZ = this.field_70170_p.field_73012_v.nextDouble() * 5.0;
                meteor = new GCCoreEntityMeteor(this.field_70170_p, this.field_70165_t + (double)x, this.field_70163_u + (double)y, this.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 1);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)meteor);
                }
            }
            if (this.field_70170_p.field_73012_v.nextInt(MathHelper.func_76128_c((double)(f * 3000.0))) == 0 && ((closestPlayer = this.field_70170_p.func_72890_a((Entity)this, 100.0)) == null || closestPlayer.field_70157_k <= this.field_70157_k)) {
                x = this.field_70170_p.field_73012_v.nextInt(20) - 10;
                y = this.field_70170_p.field_73012_v.nextInt(20) + 200;
                z = this.field_70170_p.field_73012_v.nextInt(20) - 10;
                motX = this.field_70170_p.field_73012_v.nextDouble() * 5.0;
                motZ = this.field_70170_p.field_73012_v.nextDouble() * 5.0;
                meteor = new GCCoreEntityMeteor(this.field_70170_p, this.field_70165_t + (double)x, this.field_70163_u + (double)y, this.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 6);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)meteor);
                }
            }
        }
    }

    private void updateSchematics() {
        SchematicRegistry.addUnlockedPage(this, SchematicRegistry.getMatchingRecipeForID(0));
        SchematicRegistry.addUnlockedPage(this, SchematicRegistry.getMatchingRecipeForID(Integer.MAX_VALUE));
        Collections.sort(this.getUnlockedSchematics());
        if (this.field_71135_a != null && (this.getUnlockedSchematics().size() != this.lastUnlockedSchematics.size() || this.tick % 100L == 0L)) {
            this.field_71135_a.func_72567_b(GCCorePacketSchematicList.buildSchematicListPacket(this.getUnlockedSchematics()));
        }
    }

    public void setUsingPlanetGui() {
        this.usingPlanetSelectionGui = true;
    }

    public void setNotUsingPlanetGui() {
        this.usingPlanetSelectionGui = false;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        ItemStack[] saveinv;
        this.airRemaining = nbt.func_74762_e("playerAirRemaining");
        this.damageCounter = nbt.func_74762_e("damageCounter");
        this.oxygenSetupValid = this.lastOxygenSetupValid = nbt.func_74767_n("OxygenSetupValid");
        NBTTagList nbttaglist = nbt.func_74761_m("Inventory");
        this.getExtendedInventory().readFromNBTOld(nbttaglist);
        if (nbt.func_74764_b("ExtendedInventoryGC")) {
            this.getExtendedInventory().readFromNBT(nbt.func_74761_m("ExtendedInventoryGC"));
        }
        if ((saveinv = GCCoreCommandGCInv.getSaveData(this.field_71092_bJ.toLowerCase())) != null) {
            GCCoreCommandGCInv.doLoad(this);
        }
        if (nbt.func_74764_b("SpaceshipTier")) {
            this.setSpaceshipTier(nbt.func_74762_e("SpaceshipTier"));
        }
        this.setUsingParachute(nbt.func_74767_n("usingParachute2"));
        this.usingPlanetSelectionGui = nbt.func_74767_n("usingPlanetSelectionGui");
        this.setTeleportCooldown(nbt.func_74762_e("teleportCooldown"));
        this.coordsTeleportedFromX = nbt.func_74769_h("coordsTeleportedFromX");
        this.coordsTeleportedFromZ = nbt.func_74769_h("coordsTeleportedFromZ");
        this.setSpaceStationDimensionID(nbt.func_74762_e("spaceStationDimensionID"));
        if (nbt.func_74767_n("usingPlanetSelectionGui")) {
            this.openPlanetSelectionGuiCooldown = 20;
        }
        NBTTagList var23 = nbt.func_74761_m("RocketItems");
        int length = nbt.func_74762_e("rocketStacksLength");
        boolean oldInventory = false;
        if (length % 9 == 3) {
            oldInventory = true;
            --length;
        }
        this.setRocketStacks(new ItemStack[length]);
        for (int var3 = 0; var3 < var23.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var23.func_74743_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= 0 && var5 < this.getRocketStacks().length) {
                this.getRocketStacks()[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
            }
            if (!oldInventory) continue;
            if (var5 == this.getRocketStacks().length - 1) {
                this.rocketStacks[var5] = null;
            }
            if (var5 != this.getRocketStacks().length) continue;
            this.rocketStacks[var5 - 1] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.unlockedSchematics = new ArrayList();
        for (int i = 0; i < nbt.func_74761_m("Schematics").func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)nbt.func_74761_m("Schematics").func_74743_b(i);
            int j = nbttagcompound.func_74762_e("UnlockedPage");
            SchematicRegistry.addUnlockedPage(this, SchematicRegistry.getMatchingRecipeForID(j));
        }
        Collections.sort(this.getUnlockedSchematics());
        this.cryogenicChamberCooldown = nbt.func_74762_e("CryogenicChamberCooldown");
        if (nbt.func_74764_b("ReceivedSoundWarning")) {
            this.receivedSoundWarning = nbt.func_74767_n("ReceivedSoundWarning");
        }
        if (nbt.func_74764_b("LaunchpadStack")) {
            this.launchpadStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("LaunchpadStack"));
            if (this.launchpadStack != null && this.launchpadStack.field_77994_a == 0) {
                this.launchpadStack = null;
            }
        } else {
            this.launchpadStack = new ItemStack(GCCoreBlocks.landingPad, 9, 0);
        }
        super.func_70037_a(nbt);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74782_a("ExtendedInventoryGC", (NBTBase)this.getExtendedInventory().writeToNBT(new NBTTagList()));
        nbt.func_74768_a("playerAirRemaining", this.airRemaining);
        nbt.func_74768_a("damageCounter", this.damageCounter);
        nbt.func_74757_a("OxygenSetupValid", this.oxygenSetupValid);
        nbt.func_74757_a("usingParachute2", this.getParachute());
        nbt.func_74757_a("usingPlanetSelectionGui", this.usingPlanetSelectionGui);
        nbt.func_74768_a("teleportCooldown", this.getTeleportCooldown());
        nbt.func_74780_a("coordsTeleportedFromX", this.getCoordsTeleportedFromX());
        nbt.func_74780_a("coordsTeleportedFromZ", this.getCoordsTeleportedFromZ());
        nbt.func_74768_a("spaceStationDimensionID", this.getSpaceStationDimensionID());
        Collections.sort(this.getUnlockedSchematics());
        NBTTagList tagList = new NBTTagList();
        for (ISchematicPage page : this.getUnlockedSchematics()) {
            if (page == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("UnlockedPage", page.getPageID());
            tagList.func_74742_a((NBTBase)nbttagcompound);
        }
        nbt.func_74782_a("Schematics", (NBTBase)tagList);
        nbt.func_74768_a("rocketStacksLength", this.getRocketStacks().length);
        nbt.func_74768_a("SpaceshipTier", this.getSpaceshipTier());
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.getRocketStacks().length; ++var3) {
            if (this.getRocketStacks()[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.getRocketStacks()[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("RocketItems", (NBTBase)var2);
        NBTTagCompound var4 = new NBTTagCompound();
        if (this.launchpadStack != null) {
            nbt.func_74782_a("LaunchpadStack", (NBTBase)this.launchpadStack.func_77955_b(var4));
        } else {
            nbt.func_74782_a("LaunchpadStack", (NBTBase)var4);
        }
        nbt.func_74768_a("CryogenicChamberCooldown", this.cryogenicChamberCooldown);
        nbt.func_74757_a("ReceivedSoundWarning", this.receivedSoundWarning);
        super.func_70014_b(nbt);
    }

    private void sendAirRemainingPacket() {
        float f1 = Float.valueOf(this.tankInSlot1 == null ? 0.0f : (float)this.tankInSlot1.func_77958_k() / 90.0f).floatValue();
        float f2 = Float.valueOf(this.tankInSlot2 == null ? 0.0f : (float)this.tankInSlot2.func_77958_k() / 90.0f).floatValue();
        Object[] toSend = new Object[]{MathHelper.func_76141_d((float)((float)this.airRemaining / f1)), MathHelper.func_76141_d((float)((float)this.airRemaining2 / f2)), this.field_71092_bJ};
        this.field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.AIR_REMAINING, toSend));
    }

    private void sendGearUpdatePacket(int gearType) {
        this.sendGearUpdatePacket(gearType, -1);
    }

    private void sendGearUpdatePacket(int gearType, int subtype) {
        Object[] toSend = new Object[]{this.field_71092_bJ, gearType, subtype};
        if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_72361_f(this.field_71092_bJ) != null) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)50.0, (int)this.field_70170_p.field_73011_w.field_76574_g, (Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.UPDATE_GEAR_SLOT, toSend));
        }
    }

    public void func_70999_a(boolean par1, boolean par2, boolean par3) {
        this.wakeUpPlayer(par1, par2, par3, false);
    }

    public void wakeUpPlayer(boolean par1, boolean par2, boolean par3, boolean bypass) {
        ChunkCoordinates c = this.field_71081_bT;
        if (c != null) {
            GCCoreEventWakePlayer event = new GCCoreEventWakePlayer((EntityPlayer)this, c.field_71574_a, c.field_71572_b, c.field_71573_c, par1, par2, par3, bypass);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (bypass || event.result == null || event.result == EnumStatus.OK) {
                super.func_70999_a(par1, par2, par3);
            }
        }
    }

    public void setUsingParachute(boolean tf) {
        this.usingParachute = tf;
        if (tf) {
            int subtype = -1;
            if (this.parachuteInSlot != null) {
                subtype = this.parachuteInSlot.func_77960_j();
            }
            this.sendGearUpdatePacket(EnumModelPacket.ADD_PARACHUTE.getIndex(), subtype);
        } else {
            this.sendGearUpdatePacket(EnumModelPacket.REMOVE_PARACHUTE.getIndex());
        }
    }

    private boolean getParachute() {
        return this.usingParachute;
    }

    public double getCoordsTeleportedFromX() {
        return this.coordsTeleportedFromX;
    }

    public double getCoordsTeleportedFromZ() {
        return this.coordsTeleportedFromZ;
    }

    public void setCoordsTeleportedFromX(double coords) {
        this.coordsTeleportedFromX = coords;
    }

    public void setCoordsTeleportedFromZ(double coords) {
        this.coordsTeleportedFromZ = coords;
    }

    public ArrayList<ISchematicPage> getUnlockedSchematics() {
        return this.unlockedSchematics;
    }

    public int getSpaceStationDimensionID() {
        return this.spaceStationDimensionID;
    }

    public void setSpaceStationDimensionID(int spaceStationDimensionID) {
        this.spaceStationDimensionID = spaceStationDimensionID;
    }

    public int getTeleportCooldown() {
        return this.teleportCooldown;
    }

    public void setTeleportCooldown(int teleportCooldown) {
        this.teleportCooldown = teleportCooldown;
    }

    public ItemStack[] getRocketStacks() {
        return this.rocketStacks;
    }

    public void setRocketStacks(ItemStack[] rocketStacks) {
        this.rocketStacks = rocketStacks;
    }

    public boolean isTouchedGround() {
        return this.touchedGround;
    }

    public void setTouchedGround(boolean touchedGround) {
        this.touchedGround = touchedGround;
    }

    public int getRocketType() {
        return this.rocketType;
    }

    public void setRocketType(int rocketType) {
        this.rocketType = rocketType;
    }

    public int getFuelLevel() {
        return this.fuelLevel;
    }

    public void setFuelLevel(int fuelDamage) {
        this.fuelLevel = fuelDamage;
    }

    public int getChestSpawnCooldown() {
        return this.chestSpawnCooldown;
    }

    public void setChestSpawnCooldown(int chestSpawnCooldown) {
        this.chestSpawnCooldown = chestSpawnCooldown;
    }

    public Vector3 getChestSpawnVector() {
        return this.chestSpawnVector;
    }

    public void setChestSpawnVector(Vector3 chestSpawnVector) {
        this.chestSpawnVector = chestSpawnVector;
    }

    public GCCoreInventoryExtended getExtendedInventory() {
        return this.extendedInventory;
    }

    public void setExtendedInventory(GCCoreInventoryExtended extendedInventory) {
        this.extendedInventory = extendedInventory;
    }

    public int getLaunchAttempts() {
        return this.launchAttempts;
    }

    public void setLaunchAttempts(int launchAttempts) {
        this.launchAttempts = launchAttempts;
    }

    public int getChatCooldown() {
        return this.chatCooldown;
    }

    public void setChatCooldown(int chatCooldown) {
        this.chatCooldown = chatCooldown;
    }

    public int getSpaceshipTier() {
        return this.spaceshipTier;
    }

    public void setSpaceshipTier(int spaceshipTier) {
        this.spaceshipTier = spaceshipTier;
    }

    public Item getRocketItem() {
        return this.rocketItem;
    }

    public void setRocketItem(Item rocketItem) {
        this.rocketItem = rocketItem;
    }

    public ItemStack getLaunchpadStack() {
        return this.launchpadStack;
    }

    public void setLaunchpadStack(ItemStack i) {
        this.launchpadStack = i;
    }

    public int getCryogenicChamberCooldown() {
        return this.cryogenicChamberCooldown;
    }

    public void setCryogenicChamberCooldown(int cryogenicChamberCooldown) {
        this.cryogenicChamberCooldown = cryogenicChamberCooldown;
    }

    public static enum EnumModelPacket {
        ADDMASK(0),
        REMOVEMASK(1),
        ADDGEAR(2),
        REMOVEGEAR(3),
        ADDLEFTREDTANK(4),
        ADDLEFTORANGETANK(5),
        ADDLEFTGREENTANK(6),
        REMOVE_LEFT_TANK(7),
        ADDRIGHTREDTANK(8),
        ADDRIGHTORANGETANK(9),
        ADDRIGHTGREENTANK(10),
        REMOVE_RIGHT_TANK(11),
        ADD_PARACHUTE(12),
        REMOVE_PARACHUTE(13),
        ADD_FREQUENCY_MODULE(14),
        REMOVE_FREQUENCY_MODULE(15);

        private int index;

        private EnumModelPacket(int index) {
            this.index = index;
        }

        private int getIndex() {
            return this.index;
        }
    }
}

