/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.GCLog;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.GCCoreSpaceStationData;
import micdoodle8.mods.galacticraft.core.entities.GCCoreEntityBuggy;
import micdoodle8.mods.galacticraft.core.entities.player.GCCorePlayerMP;
import micdoodle8.mods.galacticraft.core.inventory.GCCoreContainerSchematic;
import micdoodle8.mods.galacticraft.core.inventory.IInventorySettable;
import micdoodle8.mods.galacticraft.core.items.GCCoreItemParachute;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketControllableEntity;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketEntityUpdate;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketHandlerClient;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketLanderUpdate;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketParachestUpdate;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityAirLockController;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityParachest;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PacketUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.network.packet.Packet9Respawn;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;

public class GCCorePacketHandlerServer
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player p) {
        if (packet == null) {
            FMLLog.severe((String)"Packet received as null!", (Object[])new Object[0]);
            return;
        }
        if (packet.field_73629_c == null) {
            FMLLog.severe((String)("Packet data received as null! ID " + packet.func_73281_k()), (Object[])new Object[0]);
            return;
        }
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        int packetType = PacketUtil.readPacketID(data);
        EntityPlayerMP player = (EntityPlayerMP)p;
        GCCorePlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, false);
        Object[] packetReadout = null;
        EnumPacketServer packetInfo = EnumPacketServer.values()[packetType];
        if (packetInfo.getDecodeClasses() != null && packetInfo.getDecodeClasses().length > 0) {
            packetReadout = PacketUtil.readPacketData(data, packetInfo.getDecodeClasses());
        }
        block3 : switch (packetInfo) {
            case UNUSED_0: {
                break;
            }
            case RESPAWN_PLAYER: {
                player.field_71135_a.func_72567_b((Packet)new Packet9Respawn(player.field_71093_bK, (byte)player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_70170_p.func_72800_K(), player.field_71134_c.func_73081_b()));
                break;
            }
            case TELEPORT_ENTITY: {
                if (playerBase == null) break;
                try {
                    WorldProvider provider = WorldUtil.getProviderForName((String)packetReadout[0]);
                    Integer dim = provider.field_76574_g;
                    GCLog.info("Found matching world name for " + (String)packetReadout[0]);
                    if (playerBase.field_70170_p instanceof WorldServer) {
                        WorldServer world = (WorldServer)playerBase.field_70170_p;
                        if (provider instanceof IOrbitDimension) {
                            WorldUtil.transferEntityToDimension((Entity)playerBase, dim, world);
                        } else {
                            WorldUtil.transferEntityToDimension((Entity)playerBase, dim, world);
                        }
                    }
                    playerBase.setTeleportCooldown(300);
                    Object[] toSend = new Object[]{player.field_71092_bJ};
                    player.field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.CLOSE_GUI, toSend));
                }
                catch (Exception e) {
                    GCLog.severe("Error occurred when attempting to transfer entity to dimension: " + (String)packetReadout[0]);
                    e.printStackTrace();
                }
                break;
            }
            case IGNITE_ROCKET: {
                if (player.field_70170_p.field_72995_K || player.field_70128_L || player.field_70154_o == null || player.field_70154_o.field_70128_L || !(player.field_70154_o instanceof EntityTieredRocket)) break;
                EntityTieredRocket ship = (EntityTieredRocket)player.field_70154_o;
                if (ship.hasValidFuel()) {
                    ItemStack stack2 = null;
                    if (playerBase != null) {
                        stack2 = playerBase.getExtendedInventory().func_70301_a(4);
                    }
                    if (stack2 != null && stack2.func_77973_b() instanceof GCCoreItemParachute || playerBase != null && playerBase.getLaunchAttempts() > 0) {
                        ship.igniteCheckingCooldown();
                        playerBase.setLaunchAttempts(0);
                        break;
                    }
                    if (playerBase.getChatCooldown() != 0 || playerBase.getLaunchAttempts() != 0) break;
                    player.func_70006_a(ChatMessageComponent.func_111066_d((String)"I don't have a parachute! If I press launch again, there's no going back!"));
                    playerBase.setChatCooldown(250);
                    playerBase.setLaunchAttempts(1);
                    break;
                }
                if (playerBase.getChatCooldown() != 0) break;
                player.func_70006_a(ChatMessageComponent.func_111066_d((String)"I'll need to load in some rocket fuel first!"));
                playerBase.setChatCooldown(250);
                break;
            }
            case OPEN_SCHEMATIC_PAGE: {
                if (player == null) break;
                ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)packetReadout[0]);
                player.openGui((Object)GalacticraftCore.instance, page.getGuiID(), player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                break;
            }
            case UNUSED_1: {
                break;
            }
            case OPEN_SPACESHIP_INV: {
                player.openGui((Object)GalacticraftCore.instance, GCCoreConfigManager.idGuiSpaceshipInventory, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                break;
            }
            case UPDATE_SHIP_YAW: {
                EntitySpaceshipBase ship;
                if (!(player.field_70154_o instanceof EntitySpaceshipBase) || (ship = (EntitySpaceshipBase)player.field_70154_o) == null) break;
                ship.field_70177_z = ((Float)packetReadout[0]).floatValue();
                break;
            }
            case UPDATE_SHIP_PITCH: {
                EntitySpaceshipBase ship;
                if (!(player.field_70154_o instanceof EntitySpaceshipBase) || (ship = (EntitySpaceshipBase)player.field_70154_o) == null) break;
                ship.field_70125_A = ((Float)packetReadout[0]).floatValue();
                break;
            }
            case UNUSED_2: {
                break;
            }
            case SET_ENTITY_FIRE: {
                for (Object object : player.field_70170_p.field_72996_f) {
                    if (!(object instanceof EntityLiving)) continue;
                    EntityLiving entity = (EntityLiving)object;
                    if (entity.field_70157_k != (Integer)packetReadout[0] || entity.field_70154_o != null) continue;
                    entity.func_70015_d(3);
                }
                break;
            }
            case OPEN_REFINERY_GUI: {
                player.openGui((Object)GalacticraftCore.instance, -1, player.field_70170_p, ((Integer)packetReadout[0]).intValue(), ((Integer)packetReadout[1]).intValue(), ((Integer)packetReadout[2]).intValue());
                break;
            }
            case UPDATE_CONTROLLABLE_ENTITY: {
                try {
                    new GCCorePacketControllableEntity().handlePacket(data, new Object[]{player}, Side.SERVER);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case UNUSED_3: {
                break;
            }
            case UPDATE_ADVANCED_ENTITY: {
                try {
                    new GCCorePacketEntityUpdate().handlePacket(data, new Object[]{player}, Side.SERVER);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case BIND_SPACE_STATION_ID: {
                if (playerBase.getSpaceStationDimensionID() != -1 && playerBase.getSpaceStationDimensionID() != 0 || GCCoreConfigManager.disableSpaceStationCreation) break;
                WorldUtil.bindSpaceStationToNewDimension(playerBase.field_70170_p, playerBase);
                WorldUtil.getSpaceStationRecipe((Integer)packetReadout[0]).matches((EntityPlayer)playerBase, true);
                break;
            }
            case UNLOCK_NEW_SCHEMATIC: {
                ISchematicPage page;
                Container container = player.field_71070_bA;
                if (!(container instanceof GCCoreContainerSchematic)) break;
                GCCoreContainerSchematic schematicContainer = (GCCoreContainerSchematic)container;
                ItemStack stack = schematicContainer.craftMatrix.func_70301_a(0);
                if (stack == null || (page = SchematicRegistry.getMatchingRecipeForItemStack(stack)) == null) break;
                SchematicRegistry.unlockNewPage(playerBase, stack);
                if (--stack.field_77994_a <= 0) {
                    stack = null;
                }
                schematicContainer.craftMatrix.func_70299_a(0, stack);
                schematicContainer.craftMatrix.func_70296_d();
                player.field_71135_a.func_72567_b((Packet)PacketUtil.createPacket("GalacticraftCore", GCCorePacketHandlerClient.EnumPacketClient.ADD_NEW_SCHEMATIC, new Object[]{page.getPageID()}));
                break;
            }
            case UPDATE_DISABLEABLE_BUTTON: {
                TileEntity tileAt = player.field_70170_p.func_72796_p(((Integer)packetReadout[0]).intValue(), ((Integer)packetReadout[1]).intValue(), ((Integer)packetReadout[2]).intValue());
                if (!(tileAt instanceof IDisableableMachine)) break;
                IDisableableMachine machine = (IDisableableMachine)tileAt;
                machine.setDisabled((Integer)packetReadout[3], !machine.getDisabled((Integer)packetReadout[3]));
                break;
            }
            case ON_FAILED_CHEST_UNLOCK: {
                if (playerBase.getChatCooldown() != 0) break;
                player.func_70006_a(ChatMessageComponent.func_111066_d((String)("I'll probably need a Tier " + packetReadout[0] + " Dungeon key to unlock this!")));
                playerBase.setChatCooldown(100);
                break;
            }
            case RENAME_SPACE_STATION: {
                GCCoreSpaceStationData ssdata = GCCoreSpaceStationData.getStationData(playerBase.field_70170_p, (Integer)packetReadout[1], (EntityPlayer)playerBase);
                if (ssdata == null || !ssdata.getOwner().equalsIgnoreCase(player.field_71092_bJ)) break;
                ssdata.setSpaceStationName((String)packetReadout[0]);
                ssdata.func_76186_a(true);
                break;
            }
            case OPEN_BUGGY_INV: {
                if (!(player.field_70154_o instanceof GCCoreEntityBuggy)) break;
                GCCoreUtil.openBuggyInv(player, (GCCoreEntityBuggy)player.field_70154_o, ((GCCoreEntityBuggy)player.field_70154_o).getType());
                break;
            }
            case UPDATE_DYNAMIC_ENTITY_INV: {
                Entity e = player.field_70170_p.func_73045_a(((Integer)packetReadout[0]).intValue());
                if (e == null || !(e instanceof IInventorySettable)) break;
                player.field_71135_a.func_72567_b(GCCorePacketLanderUpdate.buildKeyPacket(e));
                break;
            }
            case UPDATE_DYNAMIC_TILE_INV: {
                TileEntity tile = player.field_70170_p.func_72796_p(((Integer)packetReadout[0]).intValue(), ((Integer)packetReadout[1]).intValue(), ((Integer)packetReadout[2]).intValue());
                if (tile == null || !(tile instanceof GCCoreTileEntityParachest)) break;
                new GCCorePacketParachestUpdate();
                player.field_71135_a.func_72567_b(GCCorePacketParachestUpdate.buildKeyPacket((GCCoreTileEntityParachest)tile));
                break;
            }
            case OPEN_EXTENDED_INVENTORY: {
                player.openGui((Object)GalacticraftCore.instance, GCCoreConfigManager.idGuiExtendedInventory, player.field_70170_p, 0, 0, 0);
                break;
            }
            case ON_ADVANCED_GUI_CLICKED_INT: {
                TileEntity tile1 = player.field_70170_p.func_72796_p(((Integer)packetReadout[1]).intValue(), ((Integer)packetReadout[2]).intValue(), ((Integer)packetReadout[3]).intValue());
                switch ((Integer)packetReadout[0]) {
                    case 0: {
                        if (!(tile1 instanceof GCCoreTileEntityAirLockController)) break block3;
                        GCCoreTileEntityAirLockController launchController = (GCCoreTileEntityAirLockController)tile1;
                        launchController.redstoneActivation = (Integer)packetReadout[4] == 1;
                        break block3;
                    }
                    case 1: {
                        if (!(tile1 instanceof GCCoreTileEntityAirLockController)) break block3;
                        GCCoreTileEntityAirLockController launchController = (GCCoreTileEntityAirLockController)tile1;
                        launchController.playerDistanceActivation = (Integer)packetReadout[4] == 1;
                        break block3;
                    }
                    case 2: {
                        if (!(tile1 instanceof GCCoreTileEntityAirLockController)) break block3;
                        GCCoreTileEntityAirLockController launchController = (GCCoreTileEntityAirLockController)tile1;
                        launchController.playerDistanceSelection = (Integer)packetReadout[4];
                        break block3;
                    }
                    case 3: {
                        if (!(tile1 instanceof GCCoreTileEntityAirLockController)) break block3;
                        GCCoreTileEntityAirLockController launchController = (GCCoreTileEntityAirLockController)tile1;
                        launchController.playerNameMatches = (Integer)packetReadout[4] == 1;
                        break block3;
                    }
                    case 4: {
                        if (!(tile1 instanceof GCCoreTileEntityAirLockController)) break block3;
                        GCCoreTileEntityAirLockController launchController = (GCCoreTileEntityAirLockController)tile1;
                        launchController.invertSelection = (Integer)packetReadout[4] == 1;
                        break block3;
                    }
                    case 5: {
                        if (!(tile1 instanceof GCCoreTileEntityAirLockController)) break block3;
                        GCCoreTileEntityAirLockController launchController = (GCCoreTileEntityAirLockController)tile1;
                        launchController.lastHorizontalModeEnabled = launchController.horizontalModeEnabled;
                        launchController.horizontalModeEnabled = (Integer)packetReadout[4] == 1;
                        break block3;
                    }
                }
                break;
            }
            case ON_ADVANCED_GUI_CLICKED_STRING: {
                TileEntity tile2 = player.field_70170_p.func_72796_p(((Integer)packetReadout[1]).intValue(), ((Integer)packetReadout[2]).intValue(), ((Integer)packetReadout[3]).intValue());
                switch ((Integer)packetReadout[0]) {
                    case 0: {
                        if (!(tile2 instanceof GCCoreTileEntityAirLockController)) break block3;
                        GCCoreTileEntityAirLockController launchController = (GCCoreTileEntityAirLockController)tile2;
                        launchController.playerToOpenFor = (String)packetReadout[4];
                        break block3;
                    }
                }
                break;
            }
            case UPDATE_SHIP_MOTION_Y: {
                int entityID = (Integer)packetReadout[0];
                boolean up = (Boolean)packetReadout[1];
                Entity entity = player.field_70170_p.func_73045_a(entityID);
                if (!(entity instanceof EntityAutoRocket)) break;
                EntityAutoRocket autoRocket = (EntityAutoRocket)entity;
                autoRocket.field_70181_x = autoRocket.field_70181_x + (up ? (double)0.02f : (double)-0.02f);
            }
        }
    }

    public static enum EnumPacketServer {
        UNUSED_0(0, new Class[0]),
        RESPAWN_PLAYER(1, String.class),
        TELEPORT_ENTITY(2, String.class),
        IGNITE_ROCKET(3, new Class[0]),
        OPEN_SCHEMATIC_PAGE(4, Integer.class),
        UNUSED_1(5, new Class[0]),
        OPEN_SPACESHIP_INV(6, Integer.class),
        UPDATE_SHIP_YAW(7, Float.class),
        UPDATE_SHIP_PITCH(8, Float.class),
        UNUSED_2(9, new Class[0]),
        SET_ENTITY_FIRE(10, Integer.class),
        OPEN_REFINERY_GUI(11, Integer.class, Integer.class, Integer.class),
        UPDATE_CONTROLLABLE_ENTITY(12, new Class[0]),
        UNUSED_3(13, new Class[0]),
        UPDATE_ADVANCED_ENTITY(14, new Class[0]),
        BIND_SPACE_STATION_ID(15, Integer.class),
        UNLOCK_NEW_SCHEMATIC(16, new Class[0]),
        UPDATE_DISABLEABLE_BUTTON(17, Integer.class, Integer.class, Integer.class, Integer.class),
        ON_FAILED_CHEST_UNLOCK(18, Integer.class),
        RENAME_SPACE_STATION(19, String.class, Integer.class),
        OPEN_BUGGY_INV(20, new Class[0]),
        UPDATE_DYNAMIC_ENTITY_INV(21, Integer.class),
        UPDATE_DYNAMIC_TILE_INV(22, Integer.class, Integer.class, Integer.class),
        OPEN_EXTENDED_INVENTORY(23, new Class[0]),
        ON_ADVANCED_GUI_CLICKED_INT(24, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class),
        ON_ADVANCED_GUI_CLICKED_STRING(25, Integer.class, Integer.class, Integer.class, Integer.class, String.class),
        UPDATE_SHIP_MOTION_Y(26, Integer.class, Boolean.class);

        private int index;
        private Class<?>[] decodeAs;

        private EnumPacketServer(int index, Class<?> ... decodeAs) {
            this.index = index;
            this.decodeAs = decodeAs;
        }

        public int getIndex() {
            return this.index;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

