/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.oxygen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GCCoreConfigManager;
import micdoodle8.mods.galacticraft.core.oxygen.ThreadFindSeal;
import micdoodle8.mods.galacticraft.core.tick.GCCoreTickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenSealer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFluid;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockHalfSlab;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class OxygenPressureProtocol {
    public static final Map<Integer, ArrayList<Integer>> nonPermeableBlocks = new HashMap<Integer, ArrayList<Integer>>();

    public static void updateSealerStatus(GCCoreTileEntityOxygenSealer head) {
        try {
            head.threadSeal = new ThreadFindSeal(head);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public static void onEdgeBlockUpdated(World world, BlockVec3 vec) {
        if (GCCoreConfigManager.enableSealerEdgeChecks) {
            GCCoreTickHandlerServer.scheduleNewEdgeCheck(world.field_73011_w.field_76574_g, vec);
        }
    }

    public static boolean canBlockPassAir(World world, int id, BlockVec3 vec, int side) {
        ArrayList<Integer> metaList;
        Block block = Block.field_71973_m[id];
        if (block instanceof BlockLeavesBase) {
            return true;
        }
        if (block.func_71926_d()) {
            return block instanceof BlockGravel || block.field_72018_cp == Material.field_76253_m || block instanceof BlockSponge;
        }
        if (block instanceof BlockGlass) {
            return false;
        }
        if (block instanceof IPartialSealableBlock) {
            return !((IPartialSealableBlock)block).isSealed(world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)side));
        }
        if (nonPermeableBlocks.containsKey(id) && ((metaList = nonPermeableBlocks.get(id)).contains(-1) || metaList.contains(vec.getBlockMetadata((IBlockAccess)world)))) {
            return false;
        }
        if (block instanceof BlockHalfSlab) {
            return !(side == 0 && (vec.getBlockMetadata((IBlockAccess)world) & 8) == 8 || side == 1 && (vec.getBlockMetadata((IBlockAccess)world) & 8) == 0);
        }
        if (block instanceof BlockFarmland || block instanceof BlockEnchantmentTable || block instanceof BlockFluid) {
            return side != 1;
        }
        if (block instanceof BlockPistonBase) {
            BlockPistonBase piston = (BlockPistonBase)block;
            int meta = vec.getBlockMetadata((IBlockAccess)world);
            if (BlockPistonBase.func_72114_f((int)meta)) {
                int facing = BlockPistonBase.func_72117_e((int)meta);
                return side != facing;
            }
            return false;
        }
        return !block.isBlockSolidOnSide(world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)(side ^ 1)));
    }

    static {
        for (String s : GCCoreConfigManager.sealableIDs) {
            try {
                String[] split = s.split(":");
                if (nonPermeableBlocks.containsKey(Integer.parseInt(split[0]))) {
                    ArrayList<Integer> l = nonPermeableBlocks.get(Integer.parseInt(split[0]));
                    if (split.length > 1) {
                        l.add(Integer.parseInt(split[1]));
                    } else {
                        l.add(-1);
                    }
                    nonPermeableBlocks.put(Integer.parseInt(split[0]), l);
                    continue;
                }
                ArrayList<Integer> a = new ArrayList<Integer>();
                if (split.length > 1) {
                    a.add(Integer.parseInt(split[1]));
                } else {
                    a.add(-1);
                }
                nonPermeableBlocks.put(Integer.parseInt(split[0]), a);
            }
            catch (Exception e) {
                System.err.println("Galacticraft config External Sealable IDs: error parsing '" + s + "'  Must be in the form ID#:Metadata");
            }
        }
    }
}

