/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.tile.IColorable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCCoreAnnotations;
import micdoodle8.mods.galacticraft.core.network.GCCorePacketManager;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.tile.GCCoreTileEntityOxygenTransmitter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class GCCoreTileEntityOxygenPipe
extends GCCoreTileEntityOxygenTransmitter
implements IColorable,
IPacketReceiver {
    @GCCoreAnnotations.NetworkedField(targetSide=Side.CLIENT)
    public byte pipeColor = (byte)15;
    private byte lastPipeColor = (byte)-1;

    @Override
    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        TileEntity adjacentTile = new Vector3(this).modifyPositionFromSide(direction).getTileEntity((IBlockAccess)this.field_70331_k);
        if (type == NetworkType.OXYGEN) {
            if (adjacentTile instanceof IColorable) {
                return this.getColor() == ((IColorable)adjacentTile).getColor();
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean canUpdate() {
        return this.field_70331_k == null || !this.field_70331_k.field_72995_K;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.ticks % 60L == 0L && this.lastPipeColor != this.getColor()) {
            GCCorePacketManager.sendPacketToClients(GCCorePacketManager.getPacket("GCCoreEntities", this, this.getColor()), this.field_70331_k, new Vector3(this).translate(0.5), 12.0);
            this.lastPipeColor = this.getColor();
        }
    }

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 1;
    }

    @Override
    public boolean isNetworkedTile() {
        return !this.field_70331_k.field_72995_K;
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.field_70331_k != null && this.field_70331_k.field_72995_K) {
            Vector3 thisVec = new Vector3(this);
            this.field_70331_k.func_72902_n(thisVec.intX(), thisVec.intY(), thisVec.intZ());
        }
    }

    @Override
    public void setColor(byte col) {
        this.pipeColor = col;
        if (this.field_70331_k != null) {
            if (this.field_70331_k.field_72995_K) {
                Vector3 thisVec = new Vector3(this);
                this.field_70331_k.func_72902_n(thisVec.intX(), thisVec.intY(), thisVec.intZ());
            } else {
                this.getNetwork().split(this);
                this.resetNetwork();
            }
        }
    }

    @Override
    public byte getColor() {
        return this.pipeColor;
    }

    @Override
    public void onAdjacentColorChanged(ForgeDirection direction) {
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (!this.field_70331_k.field_72995_K) {
            this.refresh();
        }
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        byte by = par1NBTTagCompound.func_74771_c("pipeColor");
        this.setColor(by);
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74774_a("pipeColor", this.getColor());
    }

    @Override
    public void handlePacketData(INetworkManager network, int packetType, Packet250CustomPayload packet, EntityPlayer player, ByteArrayDataInput dataStream) {
        byte colorBefore = this.pipeColor;
        super.handlePacketData(network, packetType, packet, player, dataStream);
        if (this.pipeColor != colorBefore) {
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }
}

