/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.transmitters;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.IClientTicker;
import mekanism.api.transmitters.IBlockableConnection;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.ITransmitterNetwork;
import mekanism.api.transmitters.TransmissionType;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class DynamicNetwork<A, N extends DynamicNetwork<A, N>>
implements ITransmitterNetwork<A, N>,
IClientTicker {
    public LinkedHashSet<IGridTransmitter<N>> transmitters = new LinkedHashSet();
    public HashSet<A> possibleAcceptors = new HashSet();
    public HashMap<A, ForgeDirection> acceptorDirections = new HashMap();
    private List<DelayQueue> updateQueue = new ArrayList<DelayQueue>();
    protected int ticksSinceCreate = 0;
    protected boolean fixed = false;
    protected boolean needsUpdate = false;

    protected abstract ITransmitterNetwork<A, N> create(IGridTransmitter<N> ... var1);

    protected abstract ITransmitterNetwork<A, N> create(Collection<IGridTransmitter<N>> var1);

    protected abstract ITransmitterNetwork<A, N> create(Set<N> var1);

    public void addAllTransmitters(Set<IGridTransmitter<N>> newTransmitters) {
        this.transmitters.addAll(newTransmitters);
    }

    public boolean isFirst(IGridTransmitter<N> transmitter) {
        return ((IGridTransmitter)this.transmitters.iterator().next()).equals(transmitter);
    }

    @Override
    public void removeTransmitter(IGridTransmitter<N> transmitter) {
        this.transmitters.remove(transmitter);
        if (this.transmitters.size() == 0) {
            this.deregister();
        }
    }

    @Override
    public void register() {
        try {
            IGridTransmitter aTransmitter = (IGridTransmitter)this.transmitters.iterator().next();
            if (aTransmitter instanceof TileEntity) {
                if (!((TileEntity)aTransmitter).field_70331_k.field_72995_K) {
                    TransmitterNetworkRegistry.getInstance().registerNetwork(this);
                } else {
                    MinecraftForge.EVENT_BUS.post((Event)new ClientTickUpdate(this, 1));
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public void deregister() {
        this.transmitters.clear();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            TransmitterNetworkRegistry.getInstance().removeNetwork(this);
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new ClientTickUpdate(this, 0));
        }
    }

    @Override
    public int getSize() {
        return this.transmitters.size();
    }

    @Override
    public int getAcceptorSize() {
        return this.possibleAcceptors.size();
    }

    public int getCapacity() {
        return (int)this.getMeanCapacity() * this.transmitters.size();
    }

    public double getMeanCapacity() {
        return this.transmitters.size() > 0 ? (double)((IGridTransmitter)this.transmitters.iterator().next()).getCapacity() : 0.0;
    }

    @Override
    public void tick() {
        boolean didFix = false;
        if (!this.fixed) {
            ++this.ticksSinceCreate;
            if (this.transmitters.size() == 0) {
                this.deregister();
                return;
            }
            if (this.ticksSinceCreate > 1200) {
                this.ticksSinceCreate = 0;
                this.fixMessedUpNetwork((IGridTransmitter)this.transmitters.iterator().next());
                didFix = true;
            }
        }
        if (!didFix) {
            this.onUpdate();
        }
    }

    public void onUpdate() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            Iterator<DelayQueue> i = this.updateQueue.iterator();
            try {
                while (i.hasNext()) {
                    DelayQueue q = i.next();
                    if (q.delay > 0) {
                        --q.delay;
                        continue;
                    }
                    this.needsUpdate = true;
                    i.remove();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void fixMessedUpNetwork(IGridTransmitter<N> transmitter) {
        if (transmitter instanceof TileEntity) {
            NetworkFinder finder = new NetworkFinder(((TileEntity)transmitter).func_70314_l(), this.getTransmissionType(), Coord4D.get((TileEntity)transmitter), new Coord4D[0]);
            List<Coord4D> partNetwork = finder.exploreNetwork();
            HashSet<IGridTransmitter<N>> newTransporters = new HashSet<IGridTransmitter<N>>();
            for (Coord4D node : partNetwork) {
                TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)transmitter).field_70331_k);
                if (!TransmissionType.checkTransmissionType(nodeTile, this.getTransmissionType(), (TileEntity)transmitter)) continue;
                ((IGridTransmitter)nodeTile).removeFromTransmitterNetwork();
                newTransporters.add((IGridTransmitter)nodeTile);
            }
            ITransmitterNetwork<A, N> newNetwork = this.create((Collection<IGridTransmitter<N>>)newTransporters);
            newNetwork.refresh();
            newNetwork.setFixed(true);
            this.deregister();
        }
    }

    @Override
    public synchronized void split(IGridTransmitter<N> splitPoint) {
        if (splitPoint instanceof TileEntity) {
            this.removeTransmitter(splitPoint);
            TileEntity[] connectedBlocks = new TileEntity[6];
            boolean[] dealtWith = new boolean[]{false, false, false, false, false, false};
            ArrayList<ITransmitterNetwork<A, N>> newNetworks = new ArrayList<ITransmitterNetwork<A, N>>();
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity sideTile = Coord4D.get((TileEntity)splitPoint).getFromSide(side).getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                if (sideTile == null) continue;
                connectedBlocks[side.ordinal()] = sideTile;
            }
            for (int count = 0; count < connectedBlocks.length; ++count) {
                TileEntity tileEntity = connectedBlocks[count];
                if (!TransmissionType.checkTransmissionType(tileEntity, this.getTransmissionType()) || dealtWith[count]) continue;
                NetworkFinder finder = new NetworkFinder(((TileEntity)splitPoint).field_70331_k, this.getTransmissionType(), Coord4D.get(tileEntity), Coord4D.get((TileEntity)splitPoint));
                List<Coord4D> partNetwork = finder.exploreNetwork();
                for (int check = count; check < connectedBlocks.length; ++check) {
                    TileEntity connectedBlockB;
                    if (check == count || !TransmissionType.checkTransmissionType(connectedBlockB = connectedBlocks[check], this.getTransmissionType()) || dealtWith[check] || !partNetwork.contains(Coord4D.get(connectedBlockB))) continue;
                    dealtWith[check] = true;
                }
                HashSet<IGridTransmitter<N>> newNetCables = new HashSet<IGridTransmitter<N>>();
                for (Coord4D node : finder.iterated) {
                    TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).field_70331_k);
                    if (!TransmissionType.checkTransmissionType(nodeTile, this.getTransmissionType()) || nodeTile == splitPoint) continue;
                    newNetCables.add((IGridTransmitter)nodeTile);
                }
                newNetworks.add(this.create((Collection<IGridTransmitter<N>>)newNetCables));
            }
            if (newNetworks.size() > 0) {
                this.onNetworksCreated(newNetworks);
                for (ITransmitterNetwork iTransmitterNetwork : newNetworks) {
                    iTransmitterNetwork.refresh();
                }
            }
            this.deregister();
        }
    }

    @Override
    public void onNetworksCreated(List<N> networks) {
    }

    @Override
    public void setFixed(boolean value) {
        this.fixed = value;
    }

    @Override
    public boolean needsTicks() {
        return this.getSize() > 0;
    }

    @Override
    public void clientTick() {
        ++this.ticksSinceCreate;
        if (this.ticksSinceCreate == 5 && this.getSize() > 0) {
            TileEntity tile = (TileEntity)this.transmitters.iterator().next();
            MinecraftForge.EVENT_BUS.post((Event)new NetworkClientRequest(tile));
        }
    }

    @Override
    public boolean canMerge(List<ITransmitterNetwork<?, ?>> networks) {
        return true;
    }

    public void addUpdate(EntityPlayer player) {
        this.updateQueue.add(new DelayQueue(player));
    }

    public static class DelayQueue {
        public EntityPlayer player;
        public int delay;

        public DelayQueue(EntityPlayer p) {
            this.player = p;
            this.delay = 5;
        }
    }

    public static class NetworkFinder {
        public TransmissionType transmissionType;
        public World worldObj;
        public Coord4D start;
        public List<Coord4D> iterated = new ArrayList<Coord4D>();
        public List<Coord4D> toIgnore = new ArrayList<Coord4D>();

        public NetworkFinder(World world, TransmissionType type, Coord4D location, Coord4D ... ignore) {
            this.worldObj = world;
            this.start = location;
            this.transmissionType = type;
            if (ignore != null) {
                for (int i = 0; i < ignore.length; ++i) {
                    this.toIgnore.add(ignore[i]);
                }
            }
        }

        public void loopAll(Coord4D location) {
            if (TransmissionType.checkTransmissionType(location.getTileEntity((IBlockAccess)this.worldObj), this.transmissionType)) {
                this.iterated.add(location);
            } else {
                this.toIgnore.add(location);
            }
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity;
                Coord4D obj = location.getFromSide(direction);
                if (this.iterated.contains(obj) || this.toIgnore.contains(obj) || (tileEntity = obj.getTileEntity((IBlockAccess)this.worldObj)) instanceof IBlockableConnection && !((IBlockableConnection)tileEntity).canConnectMutual(direction.getOpposite()) || !TransmissionType.checkTransmissionType(tileEntity, this.transmissionType, location.getTileEntity((IBlockAccess)this.worldObj))) continue;
                this.loopAll(obj);
            }
        }

        public List<Coord4D> exploreNetwork() {
            this.loopAll(this.start);
            return this.iterated;
        }
    }

    public static class NetworkClientRequest
    extends Event {
        public TileEntity tileEntity;

        public NetworkClientRequest(TileEntity tile) {
            this.tileEntity = tile;
        }
    }

    public static class ClientTickUpdate
    extends Event {
        public DynamicNetwork network;
        public byte operation;

        public ClientTickUpdate(DynamicNetwork net, byte b) {
            this.network = net;
            this.operation = b;
        }
    }
}

