/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.ListUtils;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.OreGas;
import mekanism.client.gui.GuiConfigurationTab;
import mekanism.client.gui.GuiEnergyInfo;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiPowerBar;
import mekanism.client.gui.GuiRedstoneControl;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.PacketHandler;
import mekanism.common.inventory.container.ContainerChemicalCrystalizer;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityChemicalCrystalizer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiChemicalCrystalizer
extends GuiMekanism {
    public TileEntityChemicalCrystalizer tileEntity;
    public Gas prevGas;
    public ItemStack renderStack;
    public int stackSwitch = 0;
    public int stackIndex = 0;
    public List<ItemStack> iterStacks = new ArrayList<ItemStack>();

    public GuiChemicalCrystalizer(InventoryPlayer inventory, TileEntityChemicalCrystalizer tentity) {
        super(tentity, new ContainerChemicalCrystalizer(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystalizer.png")));
        this.guiElements.add(new GuiPowerBar(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystalizer.png"), 160, 23));
        this.guiElements.add(new GuiConfigurationTab(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystalizer.png")));
        this.guiElements.add(new GuiEnergyInfo(new GuiEnergyInfo.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                String multiplier = MekanismUtils.getEnergyDisplay(GuiChemicalCrystalizer.this.tileEntity.ENERGY_USAGE);
                return ListUtils.asList("Using: " + multiplier + "/t", "Needed: " + MekanismUtils.getEnergyDisplay(GuiChemicalCrystalizer.this.tileEntity.getMaxEnergy() - GuiChemicalCrystalizer.this.tileEntity.getEnergy()));
            }
        }, (GuiMekanism)this, (TileEntity)this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystalizer.png")));
    }

    @Override
    protected void func_74189_g(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
        this.field_73886_k.func_78276_b(this.tileEntity.func_70303_b(), 37, 4, 0x404040);
        if (this.tileEntity.inputTank.getGas() != null) {
            this.field_73886_k.func_78276_b(this.tileEntity.inputTank.getGas().getGas().getLocalizedName(), 29, 15, 52480);
            if (this.tileEntity.inputTank.getGas().getGas() instanceof OreGas) {
                this.field_73886_k.func_78276_b("(" + ((OreGas)this.tileEntity.inputTank.getGas().getGas()).getOreName() + ")", 29, 24, 52480);
            }
        }
        if (this.renderStack != null) {
            try {
                GL11.glPushMatrix();
                GL11.glEnable((int)2896);
                field_74196_a.func_82406_b(this.field_73886_k, this.field_73882_e.func_110434_K(), this.renderStack, 131, 14);
                GL11.glDisable((int)2896);
                GL11.glPopMatrix();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (xAxis >= 6 && xAxis <= 22 && yAxis >= 5 && yAxis <= 63) {
            this.func_74190_a(this.tileEntity.inputTank.getGas() != null ? this.tileEntity.inputTank.getGas().getGas().getLocalizedName() + ": " + this.tileEntity.inputTank.getStored() : MekanismUtils.localize("gui.empty"), xAxis, yAxis);
        }
        super.func_74189_g(mouseX, mouseY);
    }

    @Override
    protected void func_74185_a(float partialTick, int mouseX, int mouseY) {
        this.field_73882_e.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystalizer.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_74194_b, this.field_74195_c);
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        int displayInt = this.tileEntity.getScaledProgress(48);
        this.func_73729_b(guiWidth + 53, guiHeight + 61, 176, 63, displayInt, 8);
        if (this.tileEntity.getScaledInputGasLevel(58) > 0) {
            this.displayGauge(6, 5, this.tileEntity.getScaledInputGasLevel(58), null, this.tileEntity.inputTank.getGas());
        }
        super.func_74185_a(partialTick, mouseX, mouseY);
    }

    private Gas getInputGas() {
        return this.tileEntity.inputTank.getGas() != null ? this.tileEntity.inputTank.getGas().getGas() : null;
    }

    private void resetStacks() {
        this.iterStacks.clear();
        this.renderStack = null;
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        if (button == 0) {
            int xAxis = x - (this.field_73880_f - this.field_74194_b) / 2;
            int yAxis = y - (this.field_73881_g - this.field_74195_c) / 2;
            if (xAxis > 24 && xAxis < 42 && yAxis > 56 && yAxis < 64) {
                ArrayList<Integer> data = new ArrayList<Integer>();
                data.add(0);
                PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketTileEntity().setParams(Coord4D.get(this.tileEntity), data), new Object[0]);
                this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.prevGas != this.getInputGas()) {
            this.prevGas = this.getInputGas();
            boolean reset = false;
            if (this.prevGas == null || !(this.prevGas instanceof OreGas) || !((OreGas)this.prevGas).isClean()) {
                reset = true;
                this.resetStacks();
            }
            if (!reset) {
                OreGas gas = (OreGas)this.prevGas;
                String oreDictName = "ore" + gas.getName().substring(5);
                this.updateStackList(oreDictName);
            }
        }
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0 && this.iterStacks != null && this.iterStacks.size() > 0) {
            this.stackSwitch = 20;
            if (this.stackIndex == -1 || this.stackIndex == this.iterStacks.size() - 1) {
                this.stackIndex = 0;
            } else if (this.stackIndex < this.iterStacks.size() - 1) {
                ++this.stackIndex;
            }
            this.renderStack = this.iterStacks.get(this.stackIndex);
        } else if (this.iterStacks != null && this.iterStacks.size() == 0) {
            this.renderStack = null;
        }
    }

    public void displayGauge(int xPos, int yPos, int scale, FluidStack fluid, GasStack gas) {
        int renderRemaining;
        if (fluid == null && gas == null) {
            return;
        }
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        int start = 0;
        do {
            renderRemaining = 0;
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            this.field_73882_e.field_71446_o.func_110577_a(MekanismRenderer.getBlocksTexture());
            if (fluid != null) {
                this.func_94065_a(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, fluid.getFluid().getIcon(), 16, 16 - (16 - renderRemaining));
            } else if (gas != null) {
                this.func_94065_a(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, gas.getGas().getIcon(), 16, 16 - (16 - renderRemaining));
            }
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
        this.field_73882_e.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalCrystalizer.png"));
        this.func_73729_b(guiWidth + xPos, guiHeight + yPos, 176, 4, 16, 59);
    }

    private void updateStackList(String oreName) {
        if (this.iterStacks == null) {
            this.iterStacks = new ArrayList<ItemStack>();
        } else {
            this.iterStacks.clear();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (String s : OreDictionary.getOreNames()) {
            if (oreName.equals(s) || oreName.equals("*")) {
                keys.add(s);
                continue;
            }
            if (oreName.endsWith("*") && !oreName.startsWith("*")) {
                if (!s.startsWith(oreName.substring(0, oreName.length() - 1))) continue;
                keys.add(s);
                continue;
            }
            if (oreName.startsWith("*") && !oreName.endsWith("*")) {
                if (!s.endsWith(oreName.substring(1))) continue;
                keys.add(s);
                continue;
            }
            if (!oreName.startsWith("*") || !oreName.endsWith("*") || !s.contains(oreName.substring(1, oreName.length() - 1))) continue;
            keys.add(s);
        }
        for (String key : keys) {
            for (ItemStack stack : OreDictionary.getOres((String)key)) {
                ItemStack toAdd = stack.func_77946_l();
                if (this.iterStacks.contains(stack) || !(toAdd.func_77973_b() instanceof ItemBlock)) continue;
                this.iterStacks.add(stack.func_77946_l());
            }
        }
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }
}

