/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mekanism.api.ListUtils;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiEnergyInfo;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiRedstoneControl;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.container.ContainerChemicalOxidizer;
import mekanism.common.tile.TileEntityChemicalOxidizer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiChemicalOxidizer
extends GuiMekanism {
    public TileEntityChemicalOxidizer tileEntity;

    public GuiChemicalOxidizer(InventoryPlayer inventory, TileEntityChemicalOxidizer tentity) {
        super(tentity, new ContainerChemicalOxidizer(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalOxidizer.png")));
        this.guiElements.add(new GuiEnergyInfo(new GuiEnergyInfo.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                String multiplier = MekanismUtils.getEnergyDisplay(GuiChemicalOxidizer.this.tileEntity.ENERGY_USAGE);
                return ListUtils.asList("Using: " + multiplier + "/t", "Needed: " + MekanismUtils.getEnergyDisplay(GuiChemicalOxidizer.this.tileEntity.getMaxEnergy() - GuiChemicalOxidizer.this.tileEntity.getEnergy()));
            }
        }, (GuiMekanism)this, (TileEntity)this.tileEntity, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalOxidizer.png")));
    }

    @Override
    protected void func_74189_g(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
        this.field_73886_k.func_78276_b(this.tileEntity.func_70303_b(), 45, 6, 0x404040);
        this.field_73886_k.func_78276_b(MekanismUtils.localize("container.inventory"), 8, this.field_74195_c - 96 + 2, 0x404040);
        if (xAxis >= 116 && xAxis <= 168 && yAxis >= 76 && yAxis <= 80) {
            this.func_74190_a(MekanismUtils.getEnergyDisplay(this.tileEntity.getEnergy()), xAxis, yAxis);
        }
        if (xAxis >= 134 && xAxis <= 150 && yAxis >= 14 && yAxis <= 72) {
            this.func_74190_a(this.tileEntity.gasTank.getGas() != null ? this.tileEntity.gasTank.getGas().getGas().getLocalizedName() + ": " + this.tileEntity.gasTank.getStored() : MekanismUtils.localize("gui.empty"), xAxis, yAxis);
        }
        super.func_74189_g(mouseX, mouseY);
    }

    @Override
    protected void func_74185_a(float partialTick, int mouseX, int mouseY) {
        super.func_74185_a(partialTick, mouseX, mouseY);
        this.field_73882_e.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalOxidizer.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_74194_b, this.field_74195_c);
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        int displayInt = this.tileEntity.getScaledEnergyLevel(52);
        this.func_73729_b(guiWidth + 116, guiHeight + 76, 176, 0, displayInt, 4);
        displayInt = this.tileEntity.getScaledProgress(48);
        this.func_73729_b(guiWidth + 64, guiHeight + 40, 176, 63, displayInt + 1, 8);
        if (this.tileEntity.getScaledGasLevel(58) > 0) {
            this.displayGauge(134, 14, this.tileEntity.getScaledGasLevel(58), null, this.tileEntity.gasTank.getGas());
        }
    }

    public void displayGauge(int xPos, int yPos, int scale, FluidStack fluid, GasStack gas) {
        int renderRemaining;
        if (fluid == null && gas == null) {
            return;
        }
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        int start = 0;
        do {
            renderRemaining = 0;
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            this.field_73882_e.field_71446_o.func_110577_a(MekanismRenderer.getBlocksTexture());
            if (fluid != null) {
                this.func_94065_a(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, fluid.getFluid().getIcon(), 16, 16 - (16 - renderRemaining));
            } else if (gas != null) {
                this.func_94065_a(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, gas.getGas().getIcon(), 16, 16 - (16 - renderRemaining));
            }
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
        this.field_73882_e.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiChemicalOxidizer.png"));
        this.func_73729_b(guiWidth + xPos, guiHeight + yPos, 176, 4, 16, 59);
    }
}

