/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mekanism.api.ListUtils;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiConfigurationTab;
import mekanism.client.gui.GuiEnergyInfo;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiRecipeType;
import mekanism.client.gui.GuiRedstoneControl;
import mekanism.client.gui.GuiSortingTab;
import mekanism.client.gui.GuiUpgradeManagement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.IFactory;
import mekanism.common.Tier;
import mekanism.common.inventory.container.ContainerFactory;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiFactory
extends GuiMekanism {
    public TileEntityFactory tileEntity;

    public GuiFactory(InventoryPlayer inventory, TileEntityFactory tentity) {
        super(tentity, new ContainerFactory(inventory, tentity));
        this.tileEntity = tentity;
        this.field_74195_c += 11;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, this.tileEntity.tier.guiLocation));
        this.guiElements.add(new GuiUpgradeManagement(this, this.tileEntity, this.tileEntity.tier.guiLocation));
        this.guiElements.add(new GuiRecipeType(this, this.tileEntity, this.tileEntity.tier.guiLocation));
        this.guiElements.add(new GuiConfigurationTab(this, this.tileEntity, this.tileEntity.tier.guiLocation));
        this.guiElements.add(new GuiSortingTab(this, this.tileEntity, this.tileEntity.tier.guiLocation));
        this.guiElements.add(new GuiEnergyInfo(new GuiEnergyInfo.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                String multiplier = MekanismUtils.getEnergyDisplay(MekanismUtils.getEnergyPerTick(GuiFactory.this.tileEntity.getSpeedMultiplier(new Object[0]), GuiFactory.this.tileEntity.getEnergyMultiplier(new Object[0]), GuiFactory.this.tileEntity.ENERGY_PER_TICK));
                return ListUtils.asList("Using: " + multiplier + "/t", "Needed: " + MekanismUtils.getEnergyDisplay(GuiFactory.this.tileEntity.getMaxEnergy() - GuiFactory.this.tileEntity.getEnergy()));
            }
        }, (GuiMekanism)this, (TileEntity)this.tileEntity, this.tileEntity.tier.guiLocation));
    }

    @Override
    protected void func_74189_g(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_73880_f - this.field_74194_b) / 2;
        int yAxis = mouseY - (this.field_73881_g - this.field_74195_c) / 2;
        this.field_73886_k.func_78276_b(this.tileEntity.func_70303_b(), 48, 4, 0x404040);
        this.field_73886_k.func_78276_b(MekanismUtils.localize("container.inventory"), 8, this.field_74195_c - 93 + 2, 0x404040);
        this.field_73886_k.func_78276_b(IFactory.RecipeType.values()[this.tileEntity.recipeType].getName(), 104, this.field_74195_c - 93 + 2, 0x404040);
        if (xAxis >= 165 && xAxis <= 169 && yAxis >= 17 && yAxis <= 69) {
            this.func_74190_a(MekanismUtils.getEnergyDisplay(this.tileEntity.getEnergy()), xAxis, yAxis);
        }
        if (xAxis >= 8 && xAxis <= 168 && yAxis >= 78 && yAxis <= 83) {
            this.func_74190_a(this.tileEntity.gasTank.getGas() != null ? this.tileEntity.gasTank.getGas().getGas().getLocalizedName() + ": " + this.tileEntity.gasTank.getStored() : MekanismUtils.localize("gui.none"), xAxis, yAxis);
        }
        super.func_74189_g(mouseX, mouseY);
    }

    @Override
    protected void func_74185_a(float partialTick, int mouseX, int mouseY) {
        super.func_74185_a(partialTick, mouseX, mouseY);
        this.field_73882_e.field_71446_o.func_110577_a(this.tileEntity.tier.guiLocation);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_74194_b, this.field_74195_c);
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        int displayInt = this.tileEntity.getScaledEnergyLevel(52);
        this.func_73729_b(guiWidth + 165, guiHeight + 17 + 52 - displayInt, 176, 52 - displayInt, 4, displayInt);
        if (this.tileEntity.tier == Tier.FactoryTier.BASIC) {
            for (int i = 0; i < this.tileEntity.tier.processes; ++i) {
                int xPos = 59 + i * 38;
                displayInt = this.tileEntity.getScaledProgress(20, i);
                this.func_73729_b(guiWidth + xPos, guiHeight + 33, 176, 52, 8, displayInt);
            }
        } else if (this.tileEntity.tier == Tier.FactoryTier.ADVANCED) {
            for (int i = 0; i < this.tileEntity.tier.processes; ++i) {
                int xPos = 39 + i * 26;
                displayInt = this.tileEntity.getScaledProgress(20, i);
                this.func_73729_b(guiWidth + xPos, guiHeight + 33, 176, 52, 8, displayInt);
            }
        } else if (this.tileEntity.tier == Tier.FactoryTier.ELITE) {
            for (int i = 0; i < this.tileEntity.tier.processes; ++i) {
                int xPos = 33 + i * 19;
                displayInt = this.tileEntity.getScaledProgress(20, i);
                this.func_73729_b(guiWidth + xPos, guiHeight + 33, 176, 52, 8, displayInt);
            }
        }
        if (this.tileEntity.getScaledGasLevel(160) > 0) {
            this.displayGauge(8, 78, this.tileEntity.getScaledGasLevel(160), 5, this.tileEntity.gasTank.getGas());
        }
    }

    public void displayGauge(int xPos, int yPos, int sizeX, int sizeY, GasStack gas) {
        if (gas == null) {
            return;
        }
        int guiWidth = (this.field_73880_f - this.field_74194_b) / 2;
        int guiHeight = (this.field_73881_g - this.field_74195_c) / 2;
        this.field_73882_e.field_71446_o.func_110577_a(MekanismRenderer.getBlocksTexture());
        this.func_94065_a(guiWidth + xPos, guiHeight + yPos, gas.getGas().getIcon(), sizeX, sizeY);
    }
}

