/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.client.model.ModelBoxSelectiveFace;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelRendererSelectiveFace {
    public float textureWidth = 64.0f;
    public float textureHeight = 32.0f;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    public boolean mirror;
    public boolean showModel = true;
    public boolean isHidden;
    public List<ModelBoxSelectiveFace> cubeList = new ArrayList<ModelBoxSelectiveFace>();
    private int textureOffsetX;
    private int textureOffsetY;
    private ModelBase baseModel;
    private Map<MekanismRenderer.BooleanArray, MekanismRenderer.DisplayInteger> displayLists = new HashMap<MekanismRenderer.BooleanArray, MekanismRenderer.DisplayInteger>();

    public ModelRendererSelectiveFace(ModelBase modelBase) {
        this.baseModel = modelBase;
        this.setTextureSize(modelBase.field_78090_t, modelBase.field_78089_u);
    }

    public ModelRendererSelectiveFace(ModelBase modelBase, int offsetX, int offsetY) {
        this(modelBase);
        this.setTextureOffset(offsetX, offsetY);
    }

    public ModelRendererSelectiveFace setTextureOffset(int offsetX, int offsetY) {
        this.textureOffsetX = offsetX;
        this.textureOffsetY = offsetY;
        return this;
    }

    public ModelRendererSelectiveFace addBox(float minX, float minY, float minZ, int sizeX, int sizeY, int sizeZ) {
        this.cubeList.add(new ModelBoxSelectiveFace(this, this.textureOffsetX, this.textureOffsetY, minX, minY, minZ, sizeX, sizeY, sizeZ, 0.0f));
        return this;
    }

    public void setRotationPoint(float pointX, float pointY, float pointZ) {
        this.rotationPointX = pointX;
        this.rotationPointY = pointY;
        this.rotationPointZ = pointZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(boolean[] dontRender, float scaleFactor) {
        if (!this.isHidden && this.showModel) {
            MekanismRenderer.DisplayInteger currentDisplayList = this.displayLists.get(new MekanismRenderer.BooleanArray(dontRender));
            if (currentDisplayList == null) {
                currentDisplayList = this.compileDisplayList(dontRender, scaleFactor);
            }
            GL11.glTranslatef((float)this.offsetX, (float)this.offsetY, (float)this.offsetZ);
            if (this.rotateAngleX == 0.0f && this.rotateAngleY == 0.0f && this.rotateAngleZ == 0.0f) {
                if (this.rotationPointX == 0.0f && this.rotationPointY == 0.0f && this.rotationPointZ == 0.0f) {
                    currentDisplayList.render();
                } else {
                    GL11.glTranslatef((float)(this.rotationPointX * scaleFactor), (float)(this.rotationPointY * scaleFactor), (float)(this.rotationPointZ * scaleFactor));
                    currentDisplayList.render();
                    GL11.glTranslatef((float)(-this.rotationPointX * scaleFactor), (float)(-this.rotationPointY * scaleFactor), (float)(-this.rotationPointZ * scaleFactor));
                }
            } else {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(this.rotationPointX * scaleFactor), (float)(this.rotationPointY * scaleFactor), (float)(this.rotationPointZ * scaleFactor));
                if (this.rotateAngleZ != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.rotateAngleY != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.rotateAngleX != 0.0f) {
                    GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                currentDisplayList.render();
                GL11.glPopMatrix();
            }
            GL11.glTranslatef((float)(-this.offsetX), (float)(-this.offsetY), (float)(-this.offsetZ));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private MekanismRenderer.DisplayInteger compileDisplayList(boolean[] dontRender, float scaleFactor) {
        MekanismRenderer.DisplayInteger displayList = MekanismRenderer.DisplayInteger.createAndStart();
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int i = 0; i < this.cubeList.size(); ++i) {
            this.cubeList.get(i).render(tessellator, dontRender, scaleFactor);
        }
        displayList.endList();
        this.displayLists.put(new MekanismRenderer.BooleanArray(dontRender), displayList);
        return displayList;
    }

    public ModelRendererSelectiveFace setTextureSize(int sizeX, int sizeY) {
        this.textureWidth = sizeX;
        this.textureHeight = sizeY;
        return this;
    }
}

