/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Set;
import mekanism.api.ChanceOutput;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public abstract class ChanceMachineRecipeHandler
extends TemplateRecipeHandler {
    private int ticksPassed;

    public abstract String getRecipeId();

    public abstract Set<Map.Entry<ItemStack, ChanceOutput>> getRecipes();

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)12, (int)0, (int)28, (int)5, (int)144, (int)68);
    }

    public void drawExtras(int i) {
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(i));
        float f = this.ticksPassed >= 20 ? (float)((this.ticksPassed - 20) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(63, 34, 176, 0, 24, 7, f, 0);
        f = this.ticksPassed <= 20 ? (float)this.ticksPassed / 20.0f : 1.0f;
        this.drawProgressBar(149, 12, 176, 7, 4, 52, f, 3);
        if (recipe.output.hasSecondary()) {
            GuiDraw.drawString((String)(Math.round(recipe.output.secondaryChance * 100.0) + "%"), (int)116, (int)52, (int)0x404040, (boolean)false);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(63, 34, 24, 7), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ItemStack, ChanceOutput> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ItemStack, ChanceOutput> irecipe : this.getRecipes()) {
            if (irecipe.getValue().hasPrimary() && NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().primaryOutput, (ItemStack)result)) {
                this.arecipes.add(new CachedIORecipe(irecipe));
                continue;
            }
            if (!irecipe.getValue().hasSecondary() || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().secondaryOutput, (ItemStack)result)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<ItemStack, ChanceOutput> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getKey(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe));
        }
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack input;
        public ChanceOutput output;

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            if (this.output.hasPrimary()) {
                return new PositionedStack((Object)this.output.primaryOutput, 100, 30);
            }
            return null;
        }

        public PositionedStack getOtherStack() {
            if (this.output.hasSecondary()) {
                return new PositionedStack((Object)this.output.secondaryOutput, 116, 30);
            }
            return null;
        }

        public CachedIORecipe(ItemStack itemstack, ChanceOutput chance) {
            super((TemplateRecipeHandler)ChanceMachineRecipeHandler.this);
            this.input = new PositionedStack((Object)itemstack, 40, 12);
            this.output = chance;
        }

        public CachedIORecipe(Map.Entry recipe) {
            this((ItemStack)recipe.getKey(), (ChanceOutput)recipe.getValue());
        }
    }
}

