/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import java.util.HashMap;
import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.client.model.ModelChemicalOxidizer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tile.TileEntityChemicalOxidizer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderChemicalOxidizer
extends TileEntitySpecialRenderer {
    private ModelChemicalOxidizer model = new ModelChemicalOxidizer();
    private static final double offset = 0.001;
    private Map<ForgeDirection, HashMap<Gas, MekanismRenderer.DisplayInteger>> cachedGasses = new HashMap<ForgeDirection, HashMap<Gas, MekanismRenderer.DisplayInteger>>();

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityChemicalOxidizer)tileEntity, x, y, z, partialTick);
    }

    private void renderAModelAt(TileEntityChemicalOxidizer tileEntity, double x, double y, double z, float partialTick) {
        this.render(false, x, y, z, tileEntity);
        if (tileEntity.gasTank.getGas() != null) {
            this.push();
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)tileEntity.gasTank.getStored() / (float)tileEntity.gasTank.getMaxGas()));
            this.func_110628_a(MekanismRenderer.getBlocksTexture());
            this.getListAndRender(ForgeDirection.getOrientation((int)tileEntity.facing), tileEntity.gasTank.getGas().getGas()).render();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.pop();
        }
        this.render(true, x, y, z, tileEntity);
    }

    private void render(boolean glass, double x, double y, double z, TileEntityChemicalOxidizer tileEntity) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        this.func_110628_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "ChemicalOxidizer.png"));
        switch (tileEntity.facing) {
            case 2: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (!glass) {
            this.model.render(0.0625f);
        } else {
            this.model.renderGlass(0.0625f);
        }
        GL11.glPopMatrix();
    }

    private MekanismRenderer.DisplayInteger getListAndRender(ForgeDirection side, Gas gas) {
        if (gas == null || gas.getIcon() == null) {
            return null;
        }
        if (this.cachedGasses.containsKey(side) && this.cachedGasses.get(side).containsKey(gas)) {
            return this.cachedGasses.get(side).get(gas);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Block.field_71943_B;
        toReturn.setTexture(gas.getIcon());
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        if (this.cachedGasses.containsKey(side)) {
            this.cachedGasses.get(side).put(gas, display);
        } else {
            HashMap<Gas, MekanismRenderer.DisplayInteger> map = new HashMap<Gas, MekanismRenderer.DisplayInteger>();
            map.put(gas, display);
            this.cachedGasses.put(side, map);
        }
        switch (side) {
            case NORTH: {
                toReturn.minX = 0.126;
                toReturn.minY = 0.0635;
                toReturn.minZ = 0.3135;
                toReturn.maxX = 0.499;
                toReturn.maxY = 0.9365;
                toReturn.maxZ = 0.6865;
                break;
            }
            case SOUTH: {
                toReturn.minX = 0.501;
                toReturn.minY = 0.0635;
                toReturn.minZ = 0.3135;
                toReturn.maxX = 0.874;
                toReturn.maxY = 0.9365;
                toReturn.maxZ = 0.6865;
                break;
            }
            case WEST: {
                toReturn.minX = 0.3135;
                toReturn.minY = 0.0635;
                toReturn.minZ = 0.501;
                toReturn.maxX = 0.6865;
                toReturn.maxY = 0.9365;
                toReturn.maxZ = 0.874;
                break;
            }
            case EAST: {
                toReturn.minX = 0.3135;
                toReturn.minY = 0.0635;
                toReturn.minZ = 0.126;
                toReturn.maxX = 0.6865;
                toReturn.maxY = 0.9365;
                toReturn.maxZ = 0.499;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        display.endList();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return display;
    }

    private void pop() {
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }
}

