/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mekanism.api.Coord4D;
import mekanism.client.ClientProxy;
import mekanism.common.ConnectedTextureRenderer;
import mekanism.common.IActiveState;
import mekanism.common.IBoundingBlock;
import mekanism.common.ItemAttacher;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.TileEntityDynamicValve;
import mekanism.common.tile.TileEntitySalinationController;
import mekanism.common.tile.TileEntitySalinationTank;
import mekanism.common.tile.TileEntitySalinationValve;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockBasic
extends Block {
    public Icon[][] icons = new Icon[256][6];
    public ConnectedTextureRenderer glassRenderer = new ConnectedTextureRenderer("glass/DynamicGlass", this.field_71990_ca, 10);

    public BlockBasic(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(5.0f);
        this.func_71894_b(10.0f);
        this.func_71849_a(Mekanism.tabMekanism);
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_72796_p(x, y, z);
            if (id == this.field_71990_ca && tileEntity instanceof TileEntityDynamicTank) {
                ((TileEntityDynamicTank)tileEntity).update();
            }
            if (tileEntity instanceof TileEntityBasicBlock) {
                ((TileEntityBasicBlock)tileEntity).onNeighborChange(id);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        if (this.field_71990_ca == Mekanism.basicBlockID) {
            this.icons[0][0] = register.func_94245_a("mekanism:OsmiumBlock");
            this.icons[1][0] = register.func_94245_a("mekanism:BronzeBlock");
            this.icons[2][0] = register.func_94245_a("mekanism:RefinedObsidian");
            this.icons[3][0] = register.func_94245_a("mekanism:CoalBlock");
            this.icons[4][0] = register.func_94245_a("mekanism:RefinedGlowstone");
            this.icons[5][0] = register.func_94245_a("mekanism:SteelBlock");
            this.icons[6][0] = register.func_94245_a("mekanism:BinSide");
            this.icons[6][1] = register.func_94245_a("mekanism:BinTop");
            this.icons[6][2] = register.func_94245_a("mekanism:BinFront");
            this.icons[6][3] = register.func_94245_a("mekanism:BinTopOn");
            this.icons[6][4] = register.func_94245_a("mekanism:BinFrontOn");
            this.icons[7][0] = register.func_94245_a("mekanism:TeleporterFrame");
            this.icons[8][0] = register.func_94245_a("mekanism:SteelCasing");
            this.icons[9][0] = register.func_94245_a("mekanism:DynamicTank");
            this.icons[10][0] = register.func_94245_a("mekanism:DynamicGlass");
            this.icons[11][0] = register.func_94245_a("mekanism:DynamicValve");
            this.icons[12][0] = register.func_94245_a("mekanism:CopperBlock");
            this.icons[13][0] = register.func_94245_a("mekanism:TinBlock");
            this.icons[14][0] = register.func_94245_a("mekanism:SalinationController");
            this.icons[14][1] = register.func_94245_a("mekanism:SalinationControllerOn");
            this.icons[14][2] = register.func_94245_a("mekanism:SalinationBlock");
            this.icons[15][0] = register.func_94245_a("mekanism:SalinationValve");
            this.glassRenderer.registerIcons(register);
        } else if (this.field_71990_ca == Mekanism.basicBlock2ID) {
            this.icons[0][0] = register.func_94245_a("mekanism:SalinationBlock");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if (this.field_71990_ca == Mekanism.basicBlockID) {
            if (metadata == 6) {
                TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
                if (side == 0 || side == 1) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[6][3] : this.icons[6][1];
                }
                if (side == tileEntity.facing) {
                    return MekanismUtils.isActive(world, x, y, z) ? this.icons[6][4] : this.icons[6][2];
                }
                return this.icons[6][0];
            }
            if (metadata == 10) {
                return this.glassRenderer.getIcon(world, x, y, z, side);
            }
            if (metadata == 14) {
                TileEntitySalinationController tileEntity = (TileEntitySalinationController)world.func_72796_p(x, y, z);
                if (side == tileEntity.facing) {
                    return tileEntity.structured ? this.icons[14][1] : this.icons[14][0];
                }
                return this.icons[14][2];
            }
            return this.func_71858_a(side, metadata);
        }
        if (this.field_71990_ca == Mekanism.basicBlock2ID) {
            return this.func_71858_a(side, metadata);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (this.field_71990_ca == Mekanism.basicBlockID) {
            if (meta != 6 && meta != 14) {
                return this.icons[meta][0];
            }
            if (meta == 6) {
                if (side == 0 || side == 1) {
                    return this.icons[6][1];
                }
                if (side == 3) {
                    return this.icons[6][2];
                }
                return this.icons[6][0];
            }
            if (meta == 14) {
                if (side == 3) {
                    return this.icons[14][0];
                }
                return this.icons[14][2];
            }
        } else if (this.field_71990_ca == Mekanism.basicBlock2ID) {
            return this.icons[meta][0];
        }
        return null;
    }

    public int func_71899_b(int i) {
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int i, CreativeTabs creativetabs, List list) {
        if (this.field_71990_ca == Mekanism.basicBlockID) {
            list.add(new ItemStack(i, 1, 0));
            list.add(new ItemStack(i, 1, 1));
            list.add(new ItemStack(i, 1, 2));
            list.add(new ItemStack(i, 1, 3));
            list.add(new ItemStack(i, 1, 4));
            list.add(new ItemStack(i, 1, 5));
            list.add(new ItemStack(i, 1, 6));
            list.add(new ItemStack(i, 1, 7));
            list.add(new ItemStack(i, 1, 8));
            list.add(new ItemStack(i, 1, 9));
            list.add(new ItemStack(i, 1, 10));
            list.add(new ItemStack(i, 1, 11));
            list.add(new ItemStack(i, 1, 12));
            list.add(new ItemStack(i, 1, 13));
            list.add(new ItemStack(i, 1, 14));
            list.add(new ItemStack(i, 1, 15));
        } else if (this.field_71990_ca == Mekanism.basicBlock2ID) {
            list.add(new ItemStack(i, 1, 0));
        }
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (this.field_71990_ca == Mekanism.basicBlockID) {
            TileEntityDynamicTank tileEntity;
            if ((meta == 9 || meta == 10 || meta == 11) && (tileEntity = (TileEntityDynamicTank)world.func_72796_p(x, y, z)) != null && (!world.field_72995_K ? tileEntity.structure != null : tileEntity.clientHasStructure)) {
                return false;
            }
        } else if (this.field_71990_ca == Mekanism.basicBlock2ID) {
            // empty if block
        }
        return super.canCreatureSpawn(type, world, x, y, z);
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        if (this.field_71990_ca == Mekanism.basicBlockID && !world.field_72995_K && meta == 6) {
            TileEntityBin bin = (TileEntityBin)world.func_72796_p(x, y, z);
            MovingObjectPosition pos = MekanismUtils.rayTrace(world, player);
            if (pos != null && pos.field_72310_e == bin.facing && bin.bottomStack != null) {
                if (!player.func_70093_af()) {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, bin.removeStack().func_77946_l()));
                } else {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, bin.remove(1).func_77946_l()));
                }
            }
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityplayer, int i1, float f1, float f2, float f3) {
        int metadata = world.func_72805_g(x, y, z);
        if (this.field_71990_ca == Mekanism.basicBlockID) {
            if (metadata != 6 && ItemAttacher.canAttach(entityplayer.func_71045_bC())) {
                return false;
            }
            if (metadata == 2 && entityplayer.func_70093_af()) {
                entityplayer.openGui((Object)Mekanism.instance, 1, world, x, y, z);
                return true;
            }
            if (metadata == 14 && !entityplayer.func_70093_af()) {
                entityplayer.openGui((Object)Mekanism.instance, 33, world, x, y, z);
                return true;
            }
            if (world.field_72995_K) {
                return true;
            }
            if (metadata == 6) {
                TileEntityBin bin = (TileEntityBin)world.func_72796_p(x, y, z);
                if (bin.getItemCount() < bin.MAX_STORAGE) {
                    if (bin.addTicks == 0) {
                        if (entityplayer.func_71045_bC() != null) {
                            ItemStack remain = bin.add(entityplayer.func_71045_bC());
                            entityplayer.func_70062_b(0, remain);
                            bin.addTicks = 5;
                        }
                    } else {
                        ItemStack[] inv = entityplayer.field_71071_by.field_70462_a;
                        for (int i = 0; i < inv.length && bin.getItemCount() != bin.MAX_STORAGE; ++i) {
                            if (inv[i] != null) {
                                ItemStack remain;
                                inv[i] = remain = bin.add(inv[i]);
                            }
                            ((EntityPlayerMP)entityplayer).func_71110_a(entityplayer.field_71070_bA, entityplayer.field_71070_bA.func_75138_a());
                        }
                    }
                }
                return true;
            }
            if (!(metadata != 9 && metadata != 10 && metadata != 11 || entityplayer.func_70093_af() || ((TileEntityDynamicTank)world.func_72796_p((int)x, (int)y, (int)z)).structure == null)) {
                TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)world.func_72796_p(x, y, z);
                if (!this.manageInventory(entityplayer, tileEntity)) {
                    PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Object[0]);
                    entityplayer.openGui((Object)Mekanism.instance, 18, world, x, y, z);
                } else {
                    entityplayer.field_71071_by.func_70296_d();
                    tileEntity.sendPacketToRenderer();
                }
                return true;
            }
        }
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return this.field_71990_ca != Mekanism.basicBlockID || world.func_72805_g(x, y, z) != 10;
    }

    private boolean manageInventory(EntityPlayer player, TileEntityDynamicTank tileEntity) {
        ItemStack itemStack = player.func_71045_bC();
        if (itemStack != null && tileEntity.structure != null) {
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) {
                ItemStack filled;
                if (tileEntity.structure.fluidStored != null && tileEntity.structure.fluidStored.amount >= 1000 && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)tileEntity.structure.fluidStored, (ItemStack)itemStack)) != null) {
                    if (player.field_71075_bZ.field_75098_d) {
                        tileEntity.structure.fluidStored.amount -= FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                        if (tileEntity.structure.fluidStored.amount == 0) {
                            tileEntity.structure.fluidStored = null;
                        }
                        return true;
                    }
                    if (itemStack.field_77994_a > 1) {
                        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                            if (player.field_71071_by.field_70462_a[i] == null) {
                                player.field_71071_by.field_70462_a[i] = filled;
                                --itemStack.field_77994_a;
                                tileEntity.structure.fluidStored.amount -= FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                                if (tileEntity.structure.fluidStored.amount == 0) {
                                    tileEntity.structure.fluidStored = null;
                                }
                                return true;
                            }
                            if (!player.field_71071_by.field_70462_a[i].func_77969_a(filled) || filled.func_77976_d() <= player.field_71071_by.field_70462_a[i].field_77994_a) continue;
                            ++player.field_71071_by.field_70462_a[i].field_77994_a;
                            --itemStack.field_77994_a;
                            tileEntity.structure.fluidStored.amount -= FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                            if (tileEntity.structure.fluidStored.amount == 0) {
                                tileEntity.structure.fluidStored = null;
                            }
                            return true;
                        }
                    } else if (itemStack.field_77994_a == 1) {
                        player.func_70062_b(0, filled);
                        tileEntity.structure.fluidStored.amount -= FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                        if (tileEntity.structure.fluidStored.amount == 0) {
                            tileEntity.structure.fluidStored = null;
                        }
                        return true;
                    }
                }
            } else if (FluidContainerRegistry.isFilledContainer((ItemStack)itemStack)) {
                FluidStack itemFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
                int max = tileEntity.structure.volume * 16000;
                if (tileEntity.structure.fluidStored == null || tileEntity.structure.fluidStored.isFluidEqual(itemFluid) && tileEntity.structure.fluidStored.amount + itemFluid.amount <= max) {
                    if (FluidContainerRegistry.isBucket((ItemStack)itemStack)) {
                        if (tileEntity.structure.fluidStored == null) {
                            tileEntity.structure.fluidStored = itemFluid;
                        } else {
                            tileEntity.structure.fluidStored.amount += itemFluid.amount;
                        }
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.func_70062_b(0, new ItemStack(Item.field_77788_aw));
                        }
                        return true;
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        --itemStack.field_77994_a;
                    }
                    if (itemStack.field_77994_a == 0) {
                        player.func_70062_b(0, null);
                    }
                    if (tileEntity.structure.fluidStored == null) {
                        tileEntity.structure.fluidStored = itemFluid;
                    } else {
                        tileEntity.structure.fluidStored.amount += itemFluid.amount;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return ClientProxy.BASIC_RENDER_ID;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (tileEntity instanceof IActiveState && ((IActiveState)tileEntity).getActive() && ((IActiveState)tileEntity).lightUpdate()) {
            return 15;
        }
        if (this.field_71990_ca == Mekanism.basicBlockID) {
            switch (metadata) {
                case 2: {
                    return 8;
                }
                case 4: {
                    return 15;
                }
                case 7: {
                    return 12;
                }
            }
        }
        return 0;
    }

    public boolean hasTileEntity(int metadata) {
        if (this.field_71990_ca == Mekanism.basicBlockID) {
            return metadata == 6 || metadata == 9 || metadata == 10 || metadata == 11 || metadata == 12 || metadata == 14 || metadata == 15;
        }
        if (this.field_71990_ca == Mekanism.basicBlock2ID) {
            return metadata == 0;
        }
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (this.field_71990_ca == Mekanism.basicBlockID) {
            switch (metadata) {
                case 6: {
                    return new TileEntityBin();
                }
                case 9: {
                    return new TileEntityDynamicTank();
                }
                case 10: {
                    return new TileEntityDynamicTank();
                }
                case 11: {
                    return new TileEntityDynamicValve();
                }
                case 14: {
                    return new TileEntitySalinationController();
                }
                case 15: {
                    return new TileEntitySalinationValve();
                }
            }
        } else if (this.field_71990_ca == Mekanism.basicBlock2ID) {
            switch (metadata) {
                case 0: {
                    return new TileEntitySalinationTank();
                }
            }
        }
        return null;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemstack) {
        TileEntityBasicBlock tileEntity;
        if (world.func_72796_p(x, y, z) instanceof TileEntityBasicBlock) {
            tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
            int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int height = Math.round(entityliving.field_70125_A);
            int change = 3;
            if (tileEntity.canSetFacing(0) && tileEntity.canSetFacing(1)) {
                if (height >= 65) {
                    change = 1;
                } else if (height <= -65) {
                    change = 0;
                }
            }
            if (change != 0 && change != 1) {
                switch (side) {
                    case 0: {
                        change = 2;
                        break;
                    }
                    case 1: {
                        change = 5;
                        break;
                    }
                    case 2: {
                        change = 3;
                        break;
                    }
                    case 3: {
                        change = 4;
                    }
                }
            }
            tileEntity.setFacing((short)change);
            tileEntity.redstone = world.func_72864_z(x, y, z);
            if (tileEntity instanceof IBoundingBlock) {
                ((IBoundingBlock)((Object)tileEntity)).onPlace();
            }
        }
        world.func_72902_n(x, y, z);
        world.func_72969_x(x, y, z);
        if (!world.field_72995_K && world.func_72796_p(x, y, z) != null && (tileEntity = world.func_72796_p(x, y, z)) instanceof TileEntityDynamicTank) {
            ((TileEntityDynamicTank)tileEntity).update();
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack ret = new ItemStack(this.field_71990_ca, 1, world.func_72805_g(x, y, z));
        if (this.field_71990_ca == Mekanism.basicBlockID && ret.func_77960_j() == 6) {
            TileEntityBin tileEntity = (TileEntityBin)world.func_72796_p(x, y, z);
            InventoryBin inv = new InventoryBin(ret);
            inv.setItemCount(tileEntity.getItemCount());
            if (tileEntity.getItemCount() > 0) {
                inv.setItemType(tileEntity.itemType);
            }
        }
        return ret;
    }

    public int func_71885_a(int i, Random random, int j) {
        return 0;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && this.canHarvestBlock(player, world.func_72805_g(x, y, z))) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_72796_p(x, y, z);
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, this.getPickBlock(null, world, x, y, z));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_94571_i(x, y, z);
    }

    public ItemStack dismantleBlock(World world, int x, int y, int z, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(null, world, x, y, z);
        world.func_94571_i(x, y, z);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        if (this.field_71990_ca == Mekanism.basicBlockID && world.func_72805_g(x, y, z) == 10) {
            return this.glassRenderer.shouldRenderSide(world, x, y, z, side);
        }
        return super.func_71877_c(world, x, y, z, side);
    }
}

