/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mekanism.common.Mekanism;
import mekanism.common.item.ItemBlockCardboardBox;
import mekanism.common.tile.TileEntityCardboardBox;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockCardboardBox
extends BlockContainer {
    public Icon[] icons = new Icon[6];

    public BlockCardboardBox(int id) {
        super(id, Material.field_76253_m);
        this.func_71849_a(Mekanism.tabMekanism);
        this.func_71848_c(0.5f);
        this.func_71894_b(1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        this.icons[0] = register.func_94245_a("mekanism:CardboardBoxTop");
        this.icons[1] = register.func_94245_a("mekanism:CardboardBoxSide");
        this.icons[2] = register.func_94245_a("mekanism:CardboardBoxSideStorage");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.icons[0];
        }
        return meta == 0 ? this.icons[1] : this.icons[2];
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer entityplayer, int facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && entityplayer.func_70093_af()) {
            ItemStack itemStack = new ItemStack(Mekanism.CardboardBox);
            TileEntityCardboardBox tileEntity = (TileEntityCardboardBox)world.func_72796_p(x, y, z);
            if (tileEntity.storedData != null) {
                BlockData data = tileEntity.storedData;
                if (Block.field_71973_m[data.id] != null) {
                    data.meta = Block.field_71973_m[data.id].func_85104_a(world, x, y, z, facing, hitX, hitY, hitZ, data.meta);
                }
                world.func_72832_d(x, y, z, data.id, data.meta, 3);
                if (data.tileTag != null && world.func_72796_p(x, y, z) != null) {
                    data.updateLocation(x, y, z);
                    world.func_72796_p(x, y, z).func_70307_a(data.tileTag);
                }
                if (Block.field_71973_m[data.id] != null) {
                    Block.field_71973_m[data.id].func_71860_a(world, x, y, z, (EntityLivingBase)entityplayer, new ItemStack(data.id, 1, data.meta));
                    Block.field_71973_m[data.id].func_85105_g(world, x, y, z, data.meta);
                }
                float motion = 0.7f;
                double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
                double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
                double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
                EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
                world.func_72838_d((Entity)entityItem);
            }
        }
        return false;
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityCardboardBox();
    }

    public ItemStack dismantleBlock(World world, int x, int y, int z, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(null, world, x, y, z);
        world.func_94571_i(x, y, z);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityCardboardBox tileEntity = (TileEntityCardboardBox)world.func_72796_p(x, y, z);
        ItemStack itemStack = new ItemStack(Mekanism.CardboardBox, 1, world.func_72805_g(x, y, z));
        if (itemStack.func_77960_j() == 1 && tileEntity.storedData != null) {
            ((ItemBlockCardboardBox)itemStack.func_77973_b()).setBlockData(itemStack, tileEntity.storedData);
        }
        return itemStack;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && this.canHarvestBlock(player, world.func_72805_g(x, y, z))) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, this.getPickBlock(null, world, x, y, z));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_94571_i(x, y, z);
    }

    public int func_71925_a(Random random) {
        return 0;
    }

    public int func_71885_a(int i, Random random, int j) {
        return 0;
    }

    public static class BlockData {
        public int id;
        public int meta;
        public NBTTagCompound tileTag;

        public BlockData(int i, int j, NBTTagCompound nbtTags) {
            this.id = i;
            this.meta = j;
            this.tileTag = nbtTags;
        }

        public BlockData() {
        }

        public void updateLocation(int x, int y, int z) {
            if (this.tileTag != null) {
                this.tileTag.func_74768_a("x", x);
                this.tileTag.func_74768_a("y", y);
                this.tileTag.func_74768_a("z", z);
            }
        }

        public NBTTagCompound write(NBTTagCompound nbtTags) {
            nbtTags.func_74768_a("id", this.id);
            nbtTags.func_74768_a("meta", this.meta);
            if (this.tileTag != null) {
                nbtTags.func_74766_a("tileTag", this.tileTag);
            }
            return nbtTags;
        }

        public static BlockData read(NBTTagCompound nbtTags) {
            BlockData data = new BlockData();
            data.id = nbtTags.func_74762_e("id");
            data.meta = nbtTags.func_74762_e("meta");
            if (nbtTags.func_74764_b("tileTag")) {
                data.tileTag = nbtTags.func_74775_l("tileTag");
            }
            return data;
        }
    }
}

