/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Pos3D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityReddustFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityBalloon
extends Entity
implements IEntityAdditionalSpawnData {
    public EnumColor color = EnumColor.DARK_BLUE;
    public Coord4D latched;
    public EntityLivingBase latchedEntity;
    public boolean hasCachedEntity;
    public UUID cachedEntityUUID;

    public EntityBalloon(World world) {
        super(world);
        this.field_70158_ak = true;
        this.field_70156_m = true;
        this.func_70107_b(this.field_70165_t + 0.5, this.field_70163_u + 3.0, this.field_70161_v + 0.5);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.func_70105_a(0.25f, 0.25f);
        this.field_70181_x = 0.04;
        this.field_70180_af.func_75682_a(2, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(3, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(4, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(5, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(6, (Object)new Integer(-1));
    }

    public EntityBalloon(World world, double x, double y, double z, EnumColor c) {
        this(world);
        this.func_70107_b(x + 0.5, y + 3.0, z + 0.5);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.color = c;
    }

    public EntityBalloon(EntityLivingBase entity, EnumColor c) {
        this(entity.field_70170_p);
        this.latchedEntity = entity;
        this.func_70107_b(this.latchedEntity.field_70165_t, this.latchedEntity.field_70163_u + (double)this.latchedEntity.field_70131_O + (double)1.7f, this.latchedEntity.field_70161_v);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.color = c;
        this.field_70180_af.func_75692_b(2, (Object)new Byte(2));
        this.field_70180_af.func_75692_b(3, (Object)new Integer(0));
        this.field_70180_af.func_75692_b(4, (Object)new Integer(0));
        this.field_70180_af.func_75692_b(5, (Object)new Integer(0));
        this.field_70180_af.func_75692_b(6, (Object)new Integer(entity.field_70157_k));
    }

    public EntityBalloon(World world, Coord4D obj, EnumColor c) {
        this(world);
        this.latched = obj;
        this.func_70107_b((float)this.latched.xCoord + 0.5f, (float)this.latched.yCoord + 2.8f, (float)this.latched.zCoord + 0.5f);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.color = c;
        this.field_70180_af.func_75692_b(2, (Object)new Byte(1));
        this.field_70180_af.func_75692_b(3, (Object)new Integer(this.latched != null ? this.latched.xCoord : 0));
        this.field_70180_af.func_75692_b(4, (Object)new Integer(this.latched != null ? this.latched.yCoord : 0));
        this.field_70180_af.func_75692_b(5, (Object)new Integer(this.latched != null ? this.latched.zCoord : 0));
        this.field_70180_af.func_75692_b(6, (Object)new Integer(-1));
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70163_u > 255.0) {
            this.pop();
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.latched = this.field_70180_af.func_75683_a(2) == 1 ? new Coord4D(this.field_70180_af.func_75679_c(3), this.field_70180_af.func_75679_c(4), this.field_70180_af.func_75679_c(5), this.field_70170_p.field_73011_w.field_76574_g) : null;
            this.latchedEntity = this.field_70180_af.func_75683_a(2) == 2 ? (EntityLivingBase)this.field_70170_p.func_73045_a(this.field_70180_af.func_75679_c(6)) : null;
        } else {
            if (this.hasCachedEntity) {
                this.findCachedEntity();
                this.cachedEntityUUID = null;
                this.hasCachedEntity = false;
            }
            if (this.field_70173_aa == 1) {
                this.field_70180_af.func_75692_b(2, (Object)new Byte((byte)(this.latched != null ? 1 : (this.latchedEntity != null ? 2 : 0))));
                this.field_70180_af.func_75692_b(3, (Object)new Integer(this.latched != null ? this.latched.xCoord : 0));
                this.field_70180_af.func_75692_b(4, (Object)new Integer(this.latched != null ? this.latched.yCoord : 0));
                this.field_70180_af.func_75692_b(5, (Object)new Integer(this.latched != null ? this.latched.zCoord : 0));
                this.field_70180_af.func_75692_b(6, (Object)new Integer(this.latchedEntity != null ? this.latchedEntity.field_70157_k : -1));
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.latched != null && this.latched.exists(this.field_70170_p) && this.latched.isAirBlock((IBlockAccess)this.field_70170_p)) {
                this.latched = null;
                this.field_70180_af.func_75692_b(2, (Object)0);
            }
            if (this.latchedEntity != null && (this.latchedEntity.func_110143_aJ() <= 0.0f || this.latchedEntity.field_70128_L || !this.field_70170_p.field_72996_f.contains(this.latchedEntity))) {
                this.latchedEntity = null;
                this.field_70180_af.func_75692_b(2, (Object)0);
            }
        }
        if (!this.isLatched()) {
            this.field_70181_x = Math.min(this.field_70181_x * (double)1.02f, (double)0.2f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.98;
            this.field_70179_y *= 0.98;
            if (this.field_70122_E) {
                this.field_70159_w *= 0.7;
                this.field_70179_y *= 0.7;
            }
            if (this.field_70181_x == 0.0) {
                this.field_70181_x = 0.04;
            }
        } else if (this.latched != null) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        } else if (this.latchedEntity != null && this.latchedEntity.func_110143_aJ() > 0.0f) {
            int floor = this.getFloor(this.latchedEntity);
            this.latchedEntity.field_70181_x = this.latchedEntity.field_70163_u - (double)(floor + 1) < -0.1 ? Math.max(0.04, this.latchedEntity.field_70181_x * 1.015) : (this.latchedEntity.field_70163_u - (double)(floor + 1) > 0.1 ? Math.min(-0.04, this.latchedEntity.field_70181_x * 1.015) : 0.0);
            this.func_70107_b(this.latchedEntity.field_70165_t, this.latchedEntity.field_70163_u + (double)this.latchedEntity.field_70131_O + (double)1.7f, this.latchedEntity.field_70161_v);
        }
    }

    private int getFloor(EntityLivingBase entity) {
        int xPos = MathHelper.func_76128_c((double)entity.field_70165_t);
        int yPos = MathHelper.func_76128_c((double)entity.field_70163_u);
        int zPos = MathHelper.func_76128_c((double)entity.field_70161_v);
        for (int i = yPos; i > 0; --i) {
            if (i >= 256 || this.field_70170_p.func_72799_c(xPos, i, zPos)) continue;
            return i + 1;
        }
        return -1;
    }

    private void findCachedEntity() {
        for (Object obj : this.field_70170_p.field_72996_f) {
            EntityLivingBase entity;
            if (!(obj instanceof EntityLivingBase) || !(entity = (EntityLivingBase)obj).func_110124_au().equals(this.cachedEntityUUID)) continue;
            this.latchedEntity = entity;
        }
    }

    private void pop() {
        this.field_70170_p.func_72956_a((Entity)this, "mekanism:etc.Pop", 1.0f, 1.0f);
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                try {
                    this.doParticle();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticle() {
        Pos3D pos = new Pos3D(this.field_70165_t + ((double)this.field_70146_Z.nextFloat() * 0.6 - 0.3), this.field_70163_u - 0.8 + ((double)this.field_70146_Z.nextFloat() * 0.6 - 0.3), this.field_70161_v + ((double)this.field_70146_Z.nextFloat() * 0.6 - 0.3));
        EntityReddustFX fx = new EntityReddustFX(this.field_70170_p, pos.xPos, pos.yPos, pos.zPos, 1.0f, 0.0f, 0.0f, 0.0f);
        fx.func_70538_b(this.color.getColor(0), this.color.getColor(1), this.color.getColor(2));
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public boolean func_70104_M() {
        return this.latched == null;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbtTags) {
        this.color = EnumColor.values()[nbtTags.func_74762_e("color")];
        if (nbtTags.func_74764_b("latched")) {
            this.latched = Coord4D.read(nbtTags.func_74775_l("latched"));
        }
        if (nbtTags.func_74764_b("idMost")) {
            this.hasCachedEntity = true;
            this.cachedEntityUUID = new UUID(nbtTags.func_74763_f("idMost"), nbtTags.func_74763_f("idLeast"));
        }
    }

    protected void func_70014_b(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("color", this.color.ordinal());
        if (this.latched != null) {
            nbtTags.func_74766_a("latched", this.latched.write(new NBTTagCompound()));
        }
        if (this.latchedEntity != null) {
            nbtTags.func_74772_a("idMost", this.latchedEntity.func_110124_au().getMostSignificantBits());
            nbtTags.func_74772_a("idLeast", this.latchedEntity.func_110124_au().getLeastSignificantBits());
        }
    }

    public boolean func_85031_j(Entity entity) {
        this.pop();
        return true;
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeDouble(this.field_70165_t);
        data.writeDouble(this.field_70163_u);
        data.writeDouble(this.field_70161_v);
        data.writeInt(this.color.ordinal());
        if (this.latched != null) {
            data.writeByte(1);
            data.writeInt(this.latched.xCoord);
            data.writeInt(this.latched.yCoord);
            data.writeInt(this.latched.zCoord);
            data.writeInt(this.latched.dimensionId);
        } else if (this.latchedEntity != null) {
            data.writeByte(2);
            data.writeInt(this.latchedEntity.field_70157_k);
        } else {
            data.writeByte(0);
        }
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.func_70107_b(data.readDouble(), data.readDouble(), data.readDouble());
        this.color = EnumColor.values()[data.readInt()];
        byte type = data.readByte();
        if (type == 1) {
            this.latched = Coord4D.read(data);
        } else if (type == 2) {
            this.latchedEntity = (EntityLivingBase)this.field_70170_p.func_73045_a(data.readInt());
        } else {
            this.latched = null;
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.latchedEntity != null) {
            this.latchedEntity.field_70160_al = false;
        }
    }

    public boolean func_70112_a(double dist) {
        return dist <= 64.0;
    }

    public boolean func_70102_a(Vec3 par1Vec3) {
        return true;
    }

    public boolean func_70097_a(DamageSource dmgSource, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        this.func_70018_K();
        if (dmgSource != DamageSource.field_76376_m && dmgSource != DamageSource.field_76369_e && dmgSource != DamageSource.field_76379_h) {
            this.pop();
            return true;
        }
        return false;
    }

    public boolean isLatched() {
        if (!this.field_70170_p.field_72995_K) {
            return this.latched != null || this.latchedEntity != null;
        }
        return this.field_70180_af.func_75683_a(2) > 0;
    }

    public boolean isLatchedToEntity() {
        return this.field_70180_af.func_75683_a(2) == 2 && this.latchedEntity != null;
    }
}

