/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.miner;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.ItemInfo;
import mekanism.common.IBoundingBlock;
import mekanism.common.miner.MinerFilter;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class ThreadMinerSearch
extends Thread {
    public TileEntityDigitalMiner tileEntity;
    public State state = State.IDLE;
    public BitSet oresToMine = new BitSet();
    public Map<ItemInfo, Boolean> acceptedItems = new HashMap<ItemInfo, Boolean>();
    public int found = 0;

    public ThreadMinerSearch(TileEntityDigitalMiner tile) {
        this.tileEntity = tile;
    }

    @Override
    public void run() {
        this.state = State.SEARCHING;
        if (!this.tileEntity.inverse && this.tileEntity.filters.isEmpty()) {
            this.state = State.FINISHED;
            return;
        }
        Coord4D coord = this.tileEntity.getStartingCoord();
        int diameter = this.tileEntity.getDiameter();
        int size = this.tileEntity.getTotalSize();
        ItemInfo info = new ItemInfo(0, 0);
        for (int i = 0; i < size; ++i) {
            int x = coord.xCoord + i % diameter;
            int z = coord.zCoord + i / diameter % diameter;
            int y = coord.yCoord + i / diameter / diameter;
            if (this.tileEntity.func_70320_p()) {
                return;
            }
            if (this.tileEntity.field_70329_l == x && this.tileEntity.field_70330_m == y && this.tileEntity.field_70327_n == z || !this.tileEntity.field_70331_k.func_72863_F().func_73149_a(x >> 4, z >> 4) || this.tileEntity.field_70331_k.func_72796_p(x, y, z) instanceof IBoundingBlock) continue;
            info.id = this.tileEntity.field_70331_k.func_72798_a(x, y, z);
            info.meta = this.tileEntity.field_70331_k.func_72805_g(x, y, z);
            if (info.id == 0 || info.id == Block.field_71986_z.field_71990_ca) continue;
            boolean canFilter = false;
            if (this.acceptedItems.containsKey(info)) {
                canFilter = this.acceptedItems.get(info);
            } else {
                ItemStack stack = new ItemStack(info.id, 1, info.meta);
                if (this.tileEntity.replaceStack != null && this.tileEntity.replaceStack.func_77969_a(stack)) continue;
                boolean hasFilter = false;
                for (MinerFilter filter : this.tileEntity.filters) {
                    if (!filter.canFilter(stack)) continue;
                    hasFilter = true;
                }
                canFilter = this.tileEntity.inverse ? !hasFilter : hasFilter;
                this.acceptedItems.put(info, canFilter);
            }
            if (!canFilter) continue;
            this.oresToMine.set(i);
            ++this.found;
        }
        this.state = State.FINISHED;
        this.tileEntity.oresToMine = this.oresToMine;
        MekanismUtils.saveChunk(this.tileEntity);
    }

    public void reset() {
        this.state = State.IDLE;
    }

    public static enum State {
        IDLE("Not ready"),
        SEARCHING("Searching"),
        PAUSED("Paused"),
        FINISHED("Ready");

        public String desc;

        private State(String s) {
            this.desc = s;
        }
    }
}

