/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TMultiPart;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.HashList;
import mekanism.common.ILogisticalTransporter;
import mekanism.common.PacketHandler;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.TransmitterIcons;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.transporter.InvStack;
import mekanism.common.transporter.TransporterManager;
import mekanism.common.transporter.TransporterStack;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class PartLogisticalTransporter
extends PartSidedPipe
implements ILogisticalTransporter,
IPipeTile {
    public static TransmitterIcons transporterIcons = new TransmitterIcons(3, 2);
    public static final int SPEED = 5;
    public EnumColor color;
    public int pullDelay = 0;
    public HashList<TransporterStack> transit = new HashList();
    public Set<TransporterStack> needsSync = new HashSet<TransporterStack>();

    public String getType() {
        return "mekanism:logistical_transporter";
    }

    @Override
    public TransmitterType getTransmitter() {
        return TransmitterType.LOGISTICAL_TRANSPORTER;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ITEM;
    }

    public static void registerIcons(IconRegister register) {
        transporterIcons.registerCenterIcons(register, new String[]{"LogisticalTransporter", "RestrictiveTransporter", "DiversionTransporter"});
        transporterIcons.registerSideIcons(register, new String[]{"LogisticalTransporterSide", "RestrictiveTransporterSide"});
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float f, int pass) {
        if (pass == 1) {
            RenderPartTransmitter.getInstance().renderContents(this, f, pos);
        }
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        this.testingSide = side;
        boolean unblocked = this.tile().canReplacePart((TMultiPart)this, (TMultiPart)this);
        this.testingSide = null;
        return unblocked;
    }

    @Override
    public byte getPossibleTransmitterConnections() {
        byte connections = 0;
        if (this.world().func_72864_z(this.x(), this.y(), this.z())) {
            return connections;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity;
            if (!this.canConnectMutual(side) || !TransmissionType.checkTransmissionType(tileEntity = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world()), this.getTransmitter().getTransmission())) continue;
            ILogisticalTransporter transporter = (ILogisticalTransporter)tileEntity;
            if (this.getColor() != null && transporter.getColor() != null && this.getColor() != transporter.getColor()) continue;
            connections = (byte)(connections | 1 << side.ordinal());
        }
        return connections;
    }

    @Override
    public byte getPossibleAcceptorConnections() {
        byte connections = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity;
            if (!this.canConnectMutual(side) || !this.isValidAcceptor(tileEntity = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world()), side)) continue;
            connections = (byte)(connections | 1 << side.ordinal());
        }
        return connections;
    }

    @Override
    public Icon getCenterIcon() {
        return transporterIcons.getCenterIcon(0);
    }

    @Override
    public Icon getSideIcon() {
        return transporterIcons.getSideIcon(0);
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, ForgeDirection side) {
        return TransporterUtils.getConnections(this)[side.ordinal()];
    }

    @Override
    public void onModeChange(ForgeDirection side) {
    }

    @Override
    public void update() {
        super.update();
        if (this.world().field_72995_K) {
            for (TransporterStack stack : this.transit) {
                if (stack == null) continue;
                stack.progress = Math.min(100, stack.progress + 5);
            }
        } else {
            HashSet<TransporterStack> remove = new HashSet<TransporterStack>();
            this.pullItems();
            for (TransporterStack stack : this.transit) {
                if (!stack.initiatedPath && !this.recalculate(stack, null)) {
                    remove.add(stack);
                    continue;
                }
                stack.progress += 5;
                if (stack.progress > 100) {
                    Coord4D prevSet = null;
                    if (stack.hasPath()) {
                        int currentIndex = stack.pathToTarget.indexOf(Coord4D.get((TileEntity)this.tile()));
                        Coord4D next = stack.pathToTarget.get(currentIndex - 1);
                        if (!stack.isFinal(this)) {
                            if (next != null && stack.canInsertToTransporter(stack.getNext(this).getTileEntity((IBlockAccess)this.world()), ForgeDirection.getOrientation((int)stack.getSide(this)))) {
                                ILogisticalTransporter nextTile = (ILogisticalTransporter)next.getTileEntity((IBlockAccess)this.world());
                                nextTile.entityEntering(stack);
                                remove.add(stack);
                                continue;
                            }
                            if (next != null) {
                                prevSet = next;
                            }
                        } else if (stack.pathType != TransporterStack.Path.NONE && next != null && next.getTileEntity((IBlockAccess)this.world()) instanceof IInventory) {
                            this.needsSync.add(stack);
                            IInventory inventory = (IInventory)next.getTileEntity((IBlockAccess)this.world());
                            if (inventory != null) {
                                ItemStack rejected = InventoryUtils.putStackInInventory(inventory, stack.itemStack, stack.getSide(this), stack.pathType == TransporterStack.Path.HOME);
                                if (rejected == null) {
                                    TransporterManager.remove(stack);
                                    remove.add(stack);
                                    continue;
                                }
                                this.needsSync.add(stack);
                                stack.itemStack = rejected;
                                prevSet = next;
                            }
                        }
                    }
                    if (!this.recalculate(stack, prevSet)) {
                        remove.add(stack);
                        continue;
                    }
                    if (prevSet != null) {
                        stack.progress = 0;
                        continue;
                    }
                    stack.progress = 50;
                    continue;
                }
                if (stack.progress != 50) continue;
                if (stack.isFinal(this)) {
                    if (!(stack.pathType != TransporterStack.Path.DEST || this.checkSideForInsert(stack) && InventoryUtils.canInsert(stack.getDest().getTileEntity((IBlockAccess)this.world()), stack.color, stack.itemStack, stack.getSide(this), false))) {
                        if (this.recalculate(stack, null)) continue;
                        remove.add(stack);
                        continue;
                    }
                    if (!(stack.pathType != TransporterStack.Path.HOME || this.checkSideForInsert(stack) && InventoryUtils.canInsert(stack.getDest().getTileEntity((IBlockAccess)this.world()), stack.color, stack.itemStack, stack.getSide(this), true))) {
                        if (this.recalculate(stack, null)) continue;
                        remove.add(stack);
                        continue;
                    }
                    if (stack.pathType != TransporterStack.Path.NONE || this.recalculate(stack, null)) continue;
                    remove.add(stack);
                    continue;
                }
                TileEntity next = stack.getNext(this).getTileEntity((IBlockAccess)this.world());
                boolean recalculate = false;
                if (!stack.canInsertToTransporter(next, ForgeDirection.getOrientation((int)stack.getSide(this)))) {
                    recalculate = true;
                }
                if (!recalculate || this.recalculate(stack, null)) continue;
                remove.add(stack);
            }
            for (TransporterStack stack : remove) {
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Coord4D.get((TileEntity)this.tile()), this.getSyncPacket(stack, true)), Coord4D.get((TileEntity)this.tile()), 50.0);
                this.transit.remove(stack);
                MekanismUtils.saveChunk((TileEntity)this.tile());
            }
            for (TransporterStack stack : this.needsSync) {
                if (!this.transit.contains(stack)) continue;
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Coord4D.get((TileEntity)this.tile()), this.getSyncPacket(stack, false)), Coord4D.get((TileEntity)this.tile()), 50.0);
            }
            this.needsSync.clear();
        }
    }

    private boolean checkSideForInsert(TransporterStack stack) {
        ForgeDirection side = ForgeDirection.getOrientation((int)stack.getSide(this));
        return this.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL || this.getConnectionType(side) == PartSidedPipe.ConnectionType.PUSH;
    }

    private void pullItems() {
        if (this.pullDelay == 0) {
            boolean did = false;
            for (ForgeDirection side : this.getConnections(PartSidedPipe.ConnectionType.PULL)) {
                IInventory inv;
                InvStack stack;
                TileEntity tile = Coord4D.get((TileEntity)this.tile()).getFromSide(side).getTileEntity((IBlockAccess)this.world());
                if (!(tile instanceof IInventory) || (stack = InventoryUtils.takeTopItem(inv = (IInventory)tile, side.ordinal())) == null || stack.getStack() == null) continue;
                ItemStack rejects = TransporterUtils.insert(tile, this, stack.getStack(), this.color, true, 0);
                if (!TransporterManager.didEmit(stack.getStack(), rejects)) continue;
                did = true;
                stack.use(TransporterManager.getToUse((ItemStack)stack.getStack(), (ItemStack)rejects).field_77994_a);
            }
            if (did) {
                this.pullDelay = 10;
            }
        } else {
            --this.pullDelay;
        }
    }

    private boolean recalculate(TransporterStack stack, Coord4D from) {
        this.needsSync.add(stack);
        if (!TransporterManager.didEmit(stack.itemStack, stack.recalculatePath(this, 0)) && !stack.calculateIdle(this)) {
            TransporterUtils.drop(this, stack);
            return false;
        }
        if (from != null) {
            stack.originalLocation = from;
        }
        return true;
    }

    @Override
    public ItemStack insert(Coord4D original, ItemStack itemStack, EnumColor color, boolean doEmit, int min) {
        return this.insert_do(original, itemStack, color, doEmit, min, false);
    }

    private ItemStack insert_do(Coord4D original, ItemStack itemStack, EnumColor color, boolean doEmit, int min, boolean force) {
        ForgeDirection from = Coord4D.get((TileEntity)this.tile()).sideDifference(original).getOpposite();
        TransporterStack stack = new TransporterStack();
        stack.itemStack = itemStack;
        stack.originalLocation = original;
        stack.homeLocation = original;
        stack.color = color;
        if (force && !this.canReceiveFrom(original.getTileEntity((IBlockAccess)this.world()), from) || !stack.canInsertToTransporter((TileEntity)this.tile(), from)) {
            return itemStack;
        }
        ItemStack rejected = stack.recalculatePath(this, min);
        if (TransporterManager.didEmit(stack.itemStack, rejected)) {
            stack.itemStack = TransporterManager.getToUse(stack.itemStack, rejected);
            if (doEmit) {
                this.transit.add(stack);
                TransporterManager.add(stack);
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Coord4D.get((TileEntity)this.tile()), this.getSyncPacket(stack, false)), Coord4D.get((TileEntity)this.tile()), 50.0);
                MekanismUtils.saveChunk((TileEntity)this.tile());
            }
            return rejected;
        }
        return itemStack;
    }

    @Override
    public ItemStack insertRR(TileEntityLogisticalSorter outputter, ItemStack itemStack, EnumColor color, boolean doEmit, int min) {
        ForgeDirection from = Coord4D.get((TileEntity)this.tile()).sideDifference(Coord4D.get(outputter)).getOpposite();
        TransporterStack stack = new TransporterStack();
        stack.itemStack = itemStack;
        stack.originalLocation = Coord4D.get(outputter);
        stack.homeLocation = Coord4D.get(outputter);
        stack.color = color;
        if (!this.canReceiveFrom(outputter, from) || !stack.canInsertToTransporter((TileEntity)this.tile(), from)) {
            return itemStack;
        }
        ItemStack rejected = stack.recalculateRRPath(outputter, this, min);
        if (TransporterManager.didEmit(stack.itemStack, rejected)) {
            stack.itemStack = TransporterManager.getToUse(stack.itemStack, rejected);
            if (doEmit) {
                this.transit.add(stack);
                TransporterManager.add(stack);
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Coord4D.get((TileEntity)this.tile()), this.getSyncPacket(stack, false)), Coord4D.get((TileEntity)this.tile()), 50.0);
                MekanismUtils.saveChunk((TileEntity)this.tile());
            }
            return rejected;
        }
        return itemStack;
    }

    @Override
    public void entityEntering(TransporterStack stack) {
        stack.progress = 0;
        this.transit.add(stack);
        PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Coord4D.get((TileEntity)this.tile()), this.getSyncPacket(stack, false)), Coord4D.get((TileEntity)this.tile()), 50.0);
        MekanismUtils.saveChunk((TileEntity)this.tile());
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        if (this.world().field_72995_K) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketDataRequest().setParams(Coord4D.get((TileEntity)this.tile())), new Object[0]);
        }
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        int type = dataStream.readInt();
        if (type == 0) {
            int c = dataStream.readInt();
            EnumColor prev = this.color;
            this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
            if (prev != this.color) {
                this.tile().markRender();
            }
            this.transit.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                this.transit.add(TransporterStack.readFromPacket(dataStream));
            }
        } else if (type == 1) {
            boolean kill = dataStream.readBoolean();
            int index = dataStream.readInt();
            if (kill) {
                this.transit.remove(index);
            } else {
                TransporterStack stack = TransporterStack.readFromPacket(dataStream);
                if (stack.progress == 0) {
                    stack.progress = 5;
                }
                this.transit.replace(index, stack);
            }
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        data.add(0);
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
        data.add(this.transit.size());
        for (TransporterStack stack : this.transit) {
            stack.write(this, data);
        }
        return data;
    }

    public ArrayList getSyncPacket(TransporterStack stack, boolean kill) {
        ArrayList<Constable> data = new ArrayList<Constable>();
        data.add(Integer.valueOf(1));
        data.add(Boolean.valueOf(kill));
        data.add(Integer.valueOf(this.transit.indexOf(stack)));
        if (!kill) {
            stack.write(this, data);
        }
        return data;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
        if (nbtTags.func_74764_b("stacks")) {
            NBTTagList tagList = nbtTags.func_74761_m("stacks");
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                TransporterStack stack = TransporterStack.readFromNBT((NBTTagCompound)tagList.func_74743_b(i));
                this.transit.add(stack);
                TransporterManager.add(stack);
            }
        }
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        super.save(nbtTags);
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        NBTTagList stacks = new NBTTagList();
        for (TransporterStack stack : this.transit) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            stack.write(tagCompound);
            stacks.func_74742_a((NBTBase)tagCompound);
        }
        if (stacks.func_74745_c() != 0) {
            nbtTags.func_74782_a("stacks", (NBTBase)stacks);
        }
    }

    @Override
    public boolean isSolidOnSide(ForgeDirection side) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return PipeUtils.EMPTY;
    }

    @Override
    public IPipe getPipe() {
        return null;
    }

    @Override
    public IPipeTile.PipeType getPipeType() {
        return IPipeTile.PipeType.ITEM;
    }

    @Override
    public int injectItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (doAdd) {
            TileEntity tile = Coord4D.get((TileEntity)this.tile()).getFromSide(from).getTileEntity((IBlockAccess)this.world());
            ItemStack rejects = TransporterUtils.insert(tile, this, stack, null, true, 0);
            return TransporterManager.getToUse((ItemStack)stack, (ItemStack)rejects).field_77994_a;
        }
        return 0;
    }

    @Override
    public boolean isPipeConnected(ForgeDirection with) {
        return true;
    }

    @Override
    protected boolean onConfigure(EntityPlayer player, int part, int side) {
        TransporterUtils.incrementColor(this);
        this.refreshConnections();
        this.tile().notifyPartChange((TMultiPart)this);
        PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Coord4D.get((TileEntity)this.tile()), this.getNetworkedData(new ArrayList())), Coord4D.get((TileEntity)this.tile()), 50.0);
        player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("tooltip.configurator.toggleColor") + ": " + (this.color != null ? this.color.getName() : (Object)((Object)EnumColor.BLACK) + MekanismUtils.localize("gui.none")))));
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        super.onRightClick(player, side);
        player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " " + MekanismUtils.localize("tooltip.configurator.viewColor") + ": " + (this.color != null ? this.color.getName() : "None"))));
        return true;
    }

    @Override
    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(EnumColor c) {
        this.color = c;
    }

    @Override
    public TileEntity getTile() {
        return this.tile();
    }

    @Override
    public EnumColor getRenderColor() {
        return this.color;
    }

    @Override
    public boolean canEmitTo(TileEntity tileEntity, ForgeDirection side) {
        if (!this.canConnect(side)) {
            return false;
        }
        return this.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL || this.getConnectionType(side) == PartSidedPipe.ConnectionType.PUSH;
    }

    @Override
    public boolean canReceiveFrom(TileEntity tileEntity, ForgeDirection side) {
        if (!this.canConnect(side)) {
            return false;
        }
        return this.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL;
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.world().field_72995_K) {
            for (TransporterStack stack : this.transit) {
                TransporterUtils.drop(this, stack);
            }
        }
    }

    @Override
    public int getCost() {
        return 1;
    }
}

