/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataOutputStream;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.common.IInvConfiguration;
import mekanism.common.ITileNetwork;
import mekanism.common.PacketHandler;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PacketConfigurationUpdate
implements IMekanismPacket {
    public Coord4D object3D;
    public int configIndex;
    public int inputSide;
    public int clickType;
    public ConfigurationPacket packetType;

    @Override
    public String getName() {
        return "ConfigurationUpdate";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.packetType = (ConfigurationPacket)((Object)data[0]);
        this.object3D = (Coord4D)data[1];
        if (this.packetType == ConfigurationPacket.EJECT_COLOR) {
            this.clickType = (Integer)data[2];
        }
        if (this.packetType == ConfigurationPacket.SIDE_DATA) {
            this.clickType = (Integer)data[2];
            this.configIndex = (Integer)data[3];
        }
        if (this.packetType == ConfigurationPacket.INPUT_COLOR) {
            this.clickType = (Integer)data[2];
            this.inputSide = (Integer)data[3];
        }
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        this.packetType = ConfigurationPacket.values()[dataStream.readInt()];
        this.object3D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
        TileEntity tile = this.object3D.getTileEntity((IBlockAccess)world);
        if (tile instanceof IInvConfiguration) {
            IInvConfiguration config = (IInvConfiguration)tile;
            if (this.packetType == ConfigurationPacket.EJECT) {
                config.getEjector().setEjecting(!config.getEjector().isEjecting());
            } else if (this.packetType == ConfigurationPacket.SIDE_DATA) {
                this.clickType = dataStream.readInt();
                this.configIndex = dataStream.readInt();
                if (this.clickType == 0) {
                    MekanismUtils.incrementOutput((IInvConfiguration)tile, this.configIndex);
                } else if (this.clickType == 1) {
                    MekanismUtils.decrementOutput((IInvConfiguration)tile, this.configIndex);
                } else if (this.clickType == 2) {
                    ((IInvConfiguration)tile).getConfiguration()[this.configIndex] = 0;
                }
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(this.object3D, ((ITileNetwork)tile).getNetworkedData(new ArrayList())), this.object3D, 50.0);
            } else if (this.packetType == ConfigurationPacket.EJECT_COLOR) {
                this.clickType = dataStream.readInt();
                if (this.clickType == 0) {
                    config.getEjector().setOutputColor(TransporterUtils.increment(config.getEjector().getOutputColor()));
                } else if (this.clickType == 1) {
                    config.getEjector().setOutputColor(TransporterUtils.decrement(config.getEjector().getOutputColor()));
                } else if (this.clickType == 2) {
                    config.getEjector().setOutputColor(null);
                }
            } else if (this.packetType == ConfigurationPacket.INPUT_COLOR) {
                this.clickType = dataStream.readInt();
                this.inputSide = dataStream.readInt();
                ForgeDirection side = ForgeDirection.getOrientation((int)this.inputSide);
                if (this.clickType == 0) {
                    config.getEjector().setInputColor(side, TransporterUtils.increment(config.getEjector().getInputColor(side)));
                } else if (this.clickType == 1) {
                    config.getEjector().setInputColor(side, TransporterUtils.decrement(config.getEjector().getInputColor(side)));
                } else if (this.clickType == 2) {
                    config.getEjector().setInputColor(side, null);
                }
            } else if (this.packetType == ConfigurationPacket.STRICT_INPUT) {
                config.getEjector().setStrictInput(!config.getEjector().hasStrictInput());
            }
            for (EntityPlayer p : ((TileEntityBasicBlock)((Object)config)).playersUsing) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(this.object3D, ((ITileNetwork)tile).getNetworkedData(new ArrayList())), p);
            }
        }
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.packetType.ordinal());
        dataStream.writeInt(this.object3D.xCoord);
        dataStream.writeInt(this.object3D.yCoord);
        dataStream.writeInt(this.object3D.zCoord);
        dataStream.writeInt(this.object3D.dimensionId);
        if (this.packetType != ConfigurationPacket.EJECT && this.packetType != ConfigurationPacket.STRICT_INPUT) {
            dataStream.writeInt(this.clickType);
        }
        if (this.packetType == ConfigurationPacket.SIDE_DATA) {
            dataStream.writeInt(this.configIndex);
        }
        if (this.packetType == ConfigurationPacket.INPUT_COLOR) {
            dataStream.writeInt(this.inputSide);
        }
    }

    public static enum ConfigurationPacket {
        EJECT,
        SIDE_DATA,
        EJECT_COLOR,
        INPUT_COLOR,
        STRICT_INPUT;

    }
}

