/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataOutputStream;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasNetwork;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.EnergyNetwork;
import mekanism.common.FluidNetwork;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PacketTransmitterUpdate
implements IMekanismPacket {
    public PacketType packetType;
    public TileEntity tileEntity;
    public double power;
    public GasStack gasStack;
    public boolean didGasTransfer;
    public FluidStack fluidStack;
    public boolean didFluidTransfer;

    @Override
    public String getName() {
        return "TransmitterUpdate";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.packetType = (PacketType)((Object)data[0]);
        this.tileEntity = (TileEntity)data[1];
        switch (this.packetType) {
            case ENERGY: {
                this.power = (Double)data[2];
                break;
            }
            case GAS: {
                this.gasStack = (GasStack)data[2];
                this.didGasTransfer = (Boolean)data[3];
                break;
            }
            case FLUID: {
                this.fluidStack = (FluidStack)data[2];
                this.didFluidTransfer = (Boolean)data[3];
            }
        }
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        TileEntity tileEntity;
        IGridTransmitter transmitter;
        int transmitterType = dataStream.readInt();
        int x = dataStream.readInt();
        int y = dataStream.readInt();
        int z = dataStream.readInt();
        if (transmitterType == 0 && (transmitter = (IGridTransmitter)world.func_72796_p(x, y, z)) != null) {
            transmitter.refreshTransmitterNetwork();
        }
        if (transmitterType == 1) {
            double powerLevel = dataStream.readDouble();
            TileEntity tileEntity2 = world.func_72796_p(x, y, z);
            if (tileEntity2 != null) {
                ((EnergyNetwork)((IGridTransmitter)tileEntity2).getTransmitterNetwork()).clientEnergyScale = powerLevel;
            }
        } else if (transmitterType == 2) {
            tileEntity = world.func_72796_p(x, y, z);
            Gas gasType = GasRegistry.getGas(dataStream.readInt());
            int amount = dataStream.readInt();
            GasStack stack = null;
            this.didGasTransfer = dataStream.readBoolean();
            if (gasType != null) {
                stack = new GasStack(gasType, amount);
            }
            if (tileEntity != null) {
                GasNetwork net = (GasNetwork)((IGridTransmitter)tileEntity).getTransmitterNetwork();
                if (gasType != null) {
                    net.refGas = gasType;
                }
                net.gasStored = stack;
                net.didTransfer = this.didGasTransfer;
            }
        } else if (transmitterType == 3) {
            tileEntity = world.func_72796_p(x, y, z);
            int type = dataStream.readInt();
            Fluid fluidType = type != -1 ? FluidRegistry.getFluid((int)type) : null;
            int amount = dataStream.readInt();
            FluidStack stack = null;
            this.didFluidTransfer = dataStream.readBoolean();
            if (fluidType != null) {
                stack = new FluidStack(fluidType, amount);
            }
            if (tileEntity != null) {
                FluidNetwork net = (FluidNetwork)((IGridTransmitter)tileEntity).getTransmitterNetwork();
                if (fluidType != null) {
                    net.refFluid = fluidType;
                }
                net.fluidStored = stack;
                net.didTransfer = this.didFluidTransfer;
                net.fluidScale = net.getScale();
            }
        }
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.packetType.ordinal());
        dataStream.writeInt(this.tileEntity.field_70329_l);
        dataStream.writeInt(this.tileEntity.field_70330_m);
        dataStream.writeInt(this.tileEntity.field_70327_n);
        switch (this.packetType) {
            case ENERGY: {
                dataStream.writeDouble(this.power);
                break;
            }
            case GAS: {
                dataStream.writeInt(this.gasStack != null ? this.gasStack.getGas().getID() : -1);
                dataStream.writeInt(this.gasStack != null ? this.gasStack.amount : 0);
                dataStream.writeBoolean(this.didGasTransfer);
                break;
            }
            case FLUID: {
                dataStream.writeInt(this.fluidStack != null ? this.fluidStack.getFluid().getID() : -1);
                dataStream.writeInt(this.fluidStack != null ? this.fluidStack.amount : 0);
                dataStream.writeBoolean(this.didFluidTransfer);
            }
        }
    }

    public static enum PacketType {
        UPDATE,
        ENERGY,
        GAS,
        FLUID;

    }
}

